/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef lint
static char sccsid[] = "@(#)cm_codetable.c	1.2 00/08/19 SMI; KLE";
#endif

#define MAX_SESSION    512
#define PAGE_UP         0
#define PAGE_DOWN       1

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "cm_prc.h"

extern	struct 	CM_screen *cmscreen[];
extern	struct 	input_method im[];
extern	struct 	dictionary dic[];
extern	int    	total_im, total_dic;
extern	struct 	cm_to_env *alloc_env();
extern	struct 	cm_to_env *cm_commit();
extern	int	luc_label_type;
extern  int     Maximum_Cans;

int	max_len;

int     area_low[MAX_SESSION],area_high[MAX_SESSION];
int     s_pointer[MAX_SESSION];

im_switch_no(in_c)
int	in_c;
{
	int	i;

	for (i = USER_IM_ST; i < total_im; i++) {
		if (in_c == im[i].function_key)
			return i;
	}
	return -1;
}

look_up_dict(dic_no, string, low, high)
int	dic_no;
char	*string;
int	*low, *high;
{
	int 	i, l, h, d, len;

	len = strlen(string);
	for (l = 0, h = dic[dic_no].wc - 1; l < h; ) {
		i = (l + h) / 2;
		if ((d = strncmp(string, dic[dic_no].word[i], len)) == 0)
			break;
		if (d > 0)
			l = i + 1;
		else 	h = i - 1;
	}
	if (l < h) {
		for (*low = i; *low > 0; (*low)--) {
		    if (strncmp(string, dic[dic_no].word[*low-1], len) != 0) {
			break;
		    }
		}
		for (*high = i; *high < dic[dic_no].wc - 1; (*high)++) {
		    if (strncmp(string, dic[dic_no].word[*high+1], len) != 0) {
			break;
		    }
		}
	} else {
		*low = l + 1;
		*high = h - 1;
	}
}


codetable_im_event_handler(cms, in_c, outptr)
Cm_session cms;
u_int	in_c;
struct	cm_to_env	*outptr;
{
	char	sel[2];
	char	c, *p;
	int	i, k, h, l;
	struct  cm_to_env *tp;

	if ((in_c == '\015') || (in_c == '\025')){
		/* CR or Ctrl-U means commit and NL is part of the string */
		DISP_BUF[0] = '\015';
		DISP_BUF[1] = '\0';
		cm_commit(cms, outptr);
		return;
	}


	if (in_c == im[IM].commit_key) {
		if (cmscreen[cms]->im_mode == PRE_EDIT) {
			cm_commit(cms, outptr);
		}
		return;
	}

	if (in_c == im[IM].next_choice) {
		if (cmscreen[cms]->im_mode == LOOKUP_CHOICE) {
/*
			outptr->ce_operation = ENV_SELECT_NEXT;
			outptr->ce_next = (struct cm_to_env *)NULL;
*/
			move_search_pointer(cms,PAGE_DOWN);
			tp = alloc_env(outptr);
			make_selections(cms, tp, 0);
			return;
		}
	}

	if (in_c == im[IM].prev_choice) {
		if (cmscreen[cms]->im_mode == LOOKUP_CHOICE) {
/*
			outptr->ce_operation = ENV_SELECT_PREV;
			outptr->ce_next = (struct cm_to_env *)NULL;
*/
			move_search_pointer(cms,PAGE_UP);
			tp = alloc_env(outptr);
			make_selections(cms, tp, 0);	
			return;
		}
	}

	if (in_c == '\010' || in_c == '\177') {	/* Back Space & Delete */
		if (DISP_LEN == 0) { 
		    DISP_BUF[0] = in_c;
		    DISP_BUF[1] = '\0';
		    cm_commit(cms, outptr);
		    return;
		}

		/* Delete characters in pre-edit region */
		if ((DISP_LEN > 0) && 
			(DISP_BUF[DISP_LEN-1] == im[IM].wild_char)) {
			DISP_LEN--;
			DISP_BUF[DISP_LEN] = '\0';
		} else {
		    	--INBUF_LEN;
		    	c = INBUF[INBUF_LEN];
		    	INBUF[INBUF_LEN] = '\0';
		    	for (k = 0; im[IM].tab_idx[idx(c)].pe_text[k] != '\0'
				&& k < MAX_CHAR_PE; k++)
				;
		    	DISP_LEN -= k;
		    	DISP_BUF[DISP_LEN] = '\0';
		}

		if (INBUF_LEN == 0) {
		    	reset_range(cms);
		}

		if (DISP_LEN > 0) {
			cm_interm(cms, outptr);
		} else {
			tp = cm_commit(cms, outptr);
			tp = alloc_env(tp);
			tp->ce_operation = ENV_SELECT_END;
			tp->ce_next = (struct cm_to_env *)NULL;
                    	cmscreen[cms]->im_mode = PRE_EDIT;
			return;
		}

		if (cmscreen[cms]->im_mode == LOOKUP_CHOICE) {
			if (im[IM].wild_char == -1) {
				tp = alloc_env(outptr);
		    		find_candidate(INBUF, cms);
				make_selections(cms, tp, 0);
			} else if (DISP_BUF[DISP_LEN-1] == im[IM].wild_char) {
				tp = alloc_env(outptr);
		    		find_candidate(INBUF, cms);
				make_selections(cms, tp, DISP_LEN);
			} else {
				tp = alloc_env(outptr);
				tp->ce_operation = ENV_SELECT_END;
				tp->ce_next = (struct cm_to_env *)NULL;
                    		cmscreen[cms]->im_mode = PRE_EDIT;
			}
		}

		return;
	}

	if (in_c == im[IM].wild_char) {
		if (DISP_LEN >= max_len)
			return;
		DISP_BUF[DISP_LEN] = in_c & 0xff;
		DISP_ATTR[DISP_LEN++] = ATTR_REVERSE;
		DISP_BUF[DISP_LEN] = '\0';
	    	cm_interm(cms, outptr);
	    	tp = alloc_env(outptr);
		if (make_selections(cms, tp, DISP_LEN) == 0)
			do_nothing(outptr);
		return;
	}

	if (in_c == im[IM].disp_sel_key) {
	    if (DISP_LEN == 0) {
		DISP_BUF[0] = in_c & 0xff;
		DISP_BUF[1] = '\0';
		DISP_LEN = 1;
		cm_commit(cms, outptr);
		return;
	    }
	    if (display_all(IM)) {
		make_selections(cms, outptr, 0);
	    } else {
	    	if (cmscreen[cms]->cm_s_r.low < cmscreen[cms]->cm_s_r.high) {
		    make_selections(cms, outptr, 0);
		} else 
		  if (cmscreen[cms]->cm_s_r.low == cmscreen[cms]->cm_s_r.high) {
	    	    p = (char *)(im[IM].data + 
	      		im[IM].c_tab[cmscreen[cms]->cm_s_r.low].code);
	    	    strcpy(DISP_BUF, p);
	    	    DISP_LEN = strlen(p);
	    	    cm_commit(cms, outptr);
		} else {
		    DISP_BUF[DISP_LEN] = '\0';
		    cm_commit(cms, outptr);
		}
	    }
	    return;
	}

	if (in_c == im[IM].cmt_fst_sel_key &&
		cmscreen[cms]->cm_s_r.low < cmscreen[cms]->cm_s_r.high) {
	    	p = (char *)(im[IM].data + 
	      		im[IM].c_tab[cmscreen[cms]->cm_s_r.low].code);
	    	strcpy(DISP_BUF, p);
	    	DISP_LEN = strlen(p);
		outptr->ce_operation = ENV_SELECT_END;
		tp = alloc_env(outptr);
	    	cm_commit(cms, tp);
		cmscreen[cms]->cm_s_r.low = cmscreen[cms]->cm_s_r.high = 0;
		return;
	}

	if (cmscreen[cms]->im_mode == LOOKUP_CHOICE) {
		if (is_select_char(in_c, cms)) {
			sel[0] = (unsigned char)(in_c & 0xff);
			sel[1] = '\0';
			outptr->ce_sel_string = (e_char *)sel;
			outptr->ce_operation = ENV_SELECT_COMMIT;
			outptr->ce_next = (struct cm_to_env *)NULL;
			return;
		}
		if (is_unused_char(in_c, cms)) {
			/* the char is not used for pre-edit */
			if (auto_commit(IM)) {
				DISP_BUF[0] = in_c & 0xff;
				DISP_BUF[1] = '\0';
				DISP_LEN = 1;
				tp = cm_commit(cms, outptr);
				tp = alloc_env(tp);
				tp->ce_operation = ENV_SELECT_END;
		    		tp->ce_next = (struct cm_to_env *)NULL;
				cms_init(cms);
			} else {
				ring_bell();
				do_nothing(outptr);
			}
			return;
		}
	}

	if (is_unused_char(in_c, cms)) {
		/* the char is not used for pre-edit */
		if (auto_commit(IM) || INBUF_LEN == 0) {
			DISP_BUF[0] = in_c & 0xff;
			DISP_BUF[1] = '\0';
			DISP_LEN = 1;
			cm_commit(cms, outptr);
		} else {
			ring_bell();
			do_nothing(outptr);
		}
		return;
	}

	if (DISP_LEN >= MAXLEN_PREEDIT)
		return;

	c = INBUF[INBUF_LEN++] = in_c & 0xff;
	INBUF[INBUF_LEN] = '\0';
	for (k = 0; im[IM].tab_idx[idx(c)].pe_text[k]; k++) {
		DISP_BUF[DISP_LEN] = im[IM].tab_idx[idx(c)].pe_text[k];
		DISP_ATTR[DISP_LEN++] = ATTR_REVERSE;
	}
	DISP_BUF[DISP_LEN] = '\0';
	h = cmscreen[cms]->cm_s_r.high;
	l = cmscreen[cms]->cm_s_r.low;
	find_candidate(INBUF, cms);
	if (display_all(IM)) {
	    if (cmscreen[cms]->cm_s_r.low == cmscreen[cms]->cm_s_r.high) {
	    	p = (char *)(im[IM].data + 
	      		im[IM].c_tab[cmscreen[cms]->cm_s_r.low].code);
	    	strcpy(DISP_BUF, p);
	    	DISP_LEN = strlen(p);
	    	tp = cm_commit(cms, outptr);
		if (cmscreen[cms]->im_mode == LOOKUP_CHOICE) {
			tp = alloc_env(tp);
			tp->ce_operation = ENV_SELECT_END;
		    	tp->ce_next = (struct cm_to_env *)NULL;
			cms_init(cms);
		}
	    } else if (cmscreen[cms]->cm_s_r.low > cmscreen[cms]->cm_s_r.high) {
		INBUF_LEN--;
		DISP_LEN -= k;
		INBUF[INBUF_LEN] = '\0';
		DISP_BUF[DISP_LEN] = '\0';
		cmscreen[cms]->cm_s_r.high = h;
		cmscreen[cms]->cm_s_r.low = l;
		ring_bell();
		do_nothing(outptr);
	    } else {
	    	cm_interm(cms, outptr);
		if (auto_popup(IM) ||
			cmscreen[cms]->im_mode == LOOKUP_CHOICE) {
			tp = alloc_env(outptr);
			make_selections(cms, tp, 0);
		}
	    }
	} else {	/* Only display exactly key-matched choices */
	    if (auto_popup(IM)) {
	    	if (cmscreen[cms]->cm_s_r.low < cmscreen[cms]->cm_s_r.high) {
	    		cm_interm(cms, outptr);
			tp = alloc_env(outptr);
			make_selections(cms, tp, 0);
			return;
		} else 
		if (cmscreen[cms]->cm_s_r.low == cmscreen[cms]->cm_s_r.high) {
	    	    	p = (char *)(im[IM].data + 
	      		    im[IM].c_tab[cmscreen[cms]->cm_s_r.low].code);
	    	    	strcpy(DISP_BUF, p);
	    	    	DISP_LEN = strlen(p);
	    	    	cm_commit(cms, outptr);
			return;
		}
	    }
	    cm_interm(cms, outptr);
	}
}


struct cm_to_env *
cm_commit(cms, outptr)
Cm_session cms;
struct cm_to_env *outptr;
{
	struct cm_to_env *tp;

	outptr->ce_operation = ENV_COMMIT;
	outptr->ce_string = DISP_BUF;

	/* Reset the interm region in the ENV */
	tp = alloc_env(outptr);
	tp->ce_operation = ENV_INTERM_RESET;
	tp = alloc_env(tp);
	tp->ce_operation = ENV_SELECT_END;
	tp->ce_next = (struct cm_to_env *)NULL;
	cms_init(cms);

	return tp;
}


cm_interm(cms, outptr)
Cm_session cms;
struct cm_to_env *outptr;
{
	outptr->ce_operation = ENV_INTERM;
	outptr->ce_text = DISP_BUF;
	outptr->ce_text_attr = DISP_ATTR;
	outptr->ce_cursor = -1;		/* -1 = ENV calculates it for me */
	outptr->ce_v_pos = 1;
	outptr->ce_v_type = POS_END;
	outptr->ce_next = (struct cm_to_env *)NULL;
}


make_selections(cms, tp, len)
Cm_session cms;
struct cm_to_env *tp;
int	len;
{
	int	i, j;
	char	*p, buf[64];

	tp->ce_ncandidate = cmscreen[cms]->cm_s_r.high - 
					cmscreen[cms]->cm_s_r.low + 1;

	if (tp->ce_ncandidate <= 0) {
		do_nothing(tp);
		return 0;
	}
	if (tp->ce_ncandidate == 1) { 	/* just one, commit it */
	    	p = (char *)(im[IM].data + 
	      		im[IM].c_tab[cmscreen[cms]->cm_s_r.low].code);
		strcpy(DISP_BUF, p);
		DISP_LEN = strlen(p);
		cm_commit(cms, tp);
		return 1;
	}

	for (i = 0, j = 0; i < tp->ce_ncandidate; i++) {
	    p = (char *)(im[IM].data + 
	      		im[IM].c_tab[cmscreen[cms]->cm_s_r.low+i].code);
	    if (len == 0 || 
		    keylen(im[IM].c_tab[cmscreen[cms]->cm_s_r.low+i].key, 
			DISP_BUF[0], p, buf) == len) {
		if (len != 0)
		    p = buf;
	    	strcpy(cmscreen[cms]->cm_s_r.buf[j], p);
	    	cmscreen[cms]->cm_s_r.choices[j] = cmscreen[cms]->cm_s_r.buf[j];
		j++;
	    }
	}
	if (j == 0)
		return 0;

	tp->ce_ncandidate = j;
	tp->ce_candidate = (e_char **)cmscreen[cms]->cm_s_r.choices;

	/* All the choices are sent to ENV, so these can be NULLS */
	tp->ce_prevexist = NULL;
	tp->ce_nextexist = NULL;

	cmscreen[cms]->im_mode = LOOKUP_CHOICE;
    	tp->ce_operation = ENV_SELECT;
	tp->ce_next = NULL;

	return j;
}


keylen(k, fc, cstr, buf)
int	k;
char	fc, *cstr, *buf;
{
	int	i;
	char	c, *s;

	sprintf(buf, "%s %c", cstr, fc);
	s = &buf[strlen(buf)];
	for (i = 1; i < 5; i++) {
		if ((c = ((k >> (4 - i) * 7) & 0x7f)) == 0)
			break;
		*s++ = c;
	}
	*s = '\0';
	return i;
}


find_candidate(str, cms)
e_char		*str;
Cm_session	cms;
{
	int	d, i, h, l;
	
	for (l = im[IM].tab_idx[idx(str[0]) - 1].edge,
		h = im[IM].tab_idx[idx(str[0])].edge - 1; l < h; ) {
		i = (l + h) / 2;
		if ((d = match((char *)&str[1], IM, i)) == 0)
			break;
		if (d > 0)
			l = i + 1;
		else	h = i - 1;
	}

	if (l < h) {
		for (l = i; l > im[IM].tab_idx[idx(str[0]) - 1].edge; l--) {
		    	if (match((char *)&str[1], IM, l-1) != 0)
				break;
		}
		for (h = i; h < im[IM].tab_idx[idx(str[0])].edge - 1; h++) {
			if (match((char *)&str[1], IM, h+1) != 0)
				break;
		}
		area_low[cms] = l; area_high[cms] = h; s_pointer[cms] = l;
		cmscreen[cms]->cm_s_r.low = l;

		cmscreen[cms]->cm_s_r.high = ((h - l) < (Maximum_Cans - 1)) ? h : l + Maximum_Cans - 1;
		return;
	}

	if (l == h && match((char *)&str[1], IM, l) == 0) {
		area_low[cms] = area_high[cms] = s_pointer[cms] = l;
		cmscreen[cms]->cm_s_r.low = cmscreen[cms]->cm_s_r.high = l;
		return;
	}

	area_low[cms] = s_pointer[cms] = 1;
	area_high[cms] = 0;
	cmscreen[cms]->cm_s_r.low = 1;
	cmscreen[cms]->cm_s_r.high = 0;
}


match(keystr, im_no, idx)
char	*keystr;
int	im_no, idx;
{
	code_table	*ct_item = (code_table *) &im[im_no].c_tab[idx];
	char		*data = im[im_no].data;
	int	i;
	int	len = strlen(keystr);
	char	*tab_str, buf[8];

	if (ct_item->key & KEYSTR_MASK) {
		tab_str = (char *)(ct_item->key - KEYSTR_MASK + data);
	} else {
		for (i = 0; i < 4; i++) {
			buf[i] = (ct_item->key >> (7 * (3 - i))) & 0x7f;
		}
		buf[4] = '\0';
		tab_str = buf;
	}

	if (!case_sensitive(im_no)) {
		for (i = 0; keystr[i] != '\0'; i++)
			keystr[i] = toupper(keystr[i]);
		for (i = 0; tab_str[i] != '\0'; i++)
			tab_str[i] = toupper(tab_str[i]);
	}

	if (display_all(im_no)) {
		return strncmp(keystr, tab_str, len);
	} else {
		return strcmp(keystr, tab_str);
	}
}

move_search_pointer(cms,direct)
int     cms;
int direct;
{
    if(direct == 1) {
        s_pointer[cms] += Maximum_Cans;
        if(s_pointer[cms] > area_high[cms]) {
            s_pointer[cms] -= Maximum_Cans;
            return;
        }
        /* avoid single HANZI left,then it will be committed */
        else if (s_pointer[cms] == area_high[cms]) {
            cmscreen[cms]->cm_s_r.high = area_high[cms];
            cmscreen[cms]->cm_s_r.low  = s_pointer[cms] - 1;
        }
        else if(s_pointer[cms] > (area_high[cms] - Maximum_Cans - 1)) {
            cmscreen[cms]->cm_s_r.high = area_high[cms];
            cmscreen[cms]->cm_s_r.low  = s_pointer[cms];
        }
        else {
            cmscreen[cms]->cm_s_r.high += Maximum_Cans;
            cmscreen[cms]->cm_s_r.low  += Maximum_Cans;
        }
    }
    else {
        s_pointer[cms] -= Maximum_Cans;
        if(s_pointer[cms] < area_low[cms]) {
            s_pointer[cms] += Maximum_Cans;
            return;
        }
        else {
            cmscreen[cms]->cm_s_r.high = s_pointer[cms] + Maximum_Cans - 1;
            cmscreen[cms]->cm_s_r.low  = s_pointer[cms];
        }
    }
}

is_select_char(in_c, cms)
char	in_c;
Cm_session cms;
{
	if (luc_label_type == LUC_LABEL_NUMERIC && in_c >= '0' && in_c <= '9')
		return 1;
	if (luc_label_type == LUC_LABEL_ALPHA_UPPER 
		&& in_c >= 'A' && in_c <= 'Z')
		return 1;
	if (luc_label_type == LUC_LABEL_ALPHABETIC
		&& in_c >= 'a' && in_c <= 'z')
		return 1;
	return 0;
}

is_unused_char(in_c, cms)
char	in_c;
Cm_session cms;
{
	return (!im[IM].tab_idx[idx(in_c)].used);
}

read_code_table(im_no)
int	im_no;
{
	int	fd;
	int	tablen, data_len;
	char	header[80];

	if ((fd = open(im[im_no].ct_file, O_RDONLY)) == -1) {
		fprintf(stderr, "Can't open %s\n", im[im_no].ct_file);
		return;
	}

	read(fd, header, strlen(CODE_TABLE_HEAD));
	if (strncmp(header, CODE_TABLE_HEAD, strlen(CODE_TABLE_HEAD)) != 0) {
		fprintf(stderr, "Code Table file %s error.\n", 
			im[im_no].ct_file);
		close(fd);
		return;
	}
	read(fd, &tablen, sizeof(int));
	read(fd, &data_len, sizeof(int));
	read(fd, &max_len, sizeof(int));
	read(fd, im[im_no].tab_idx, sizeof(table_index) * MAXIDX);
	im[im_no].c_tab = (code_table *) malloc(sizeof(code_table) * tablen);
	im[im_no].data = (char *) malloc(data_len);
	read(fd, im[im_no].c_tab, sizeof(code_table) * tablen);
	read(fd, im[im_no].data, data_len);
	close(fd);

	if (im[im_no].dic_no >= 0 && dic[im[im_no].dic_no].word == NULL)
		load_dict(im[im_no].dic_no);
}


load_dict(dic_no)
int	dic_no;
{
	FILE	*fp, *fopen();
	char	buf[128];
	int	i, len;
	char	*p, *data;
	int	wordcmp();

	if ((fp = fopen(dic[dic_no].file, "r")) == NULL) {
		fprintf(stderr, "Can't open dictionary file %s\n", 
			dic[dic_no].file);
		return;
	}

	for (i = len = 0; fscanf(fp, "%s", buf) == 1; i++)
		len += strlen(buf) + 1;

	dic[dic_no].wc = i;
	dic[dic_no].word = (char **) malloc(i * sizeof(char *));
	data = (char *) malloc(len);

	rewind(fp);
	for (p = data, i = 0; fscanf(fp, "%s", buf) == 1; i++) {
		dic[dic_no].word[i] = p;
		strcpy(p, buf);
		p += strlen(buf) + 1;
	}
	fclose(fp);

	qsort(dic[dic_no].word, dic[dic_no].wc, sizeof(char *), wordcmp);
}

wordcmp(s1, s2)
char	**s1, **s2;
{
	return strcmp(*s1, *s2);
}

reset_range(cms)
Cm_session      cms;
{
        cmscreen[cms]->cm_s_r.low = 1;
        cmscreen[cms]->cm_s_r.high = 0;
}

ring_bell()
{
        putchar('\007');
        fflush(stdout);
}


cms_init(cms)
int     cms;
{
        cmscreen[cms]->im_mode = PRE_EDIT;
        DISP_LEN = INBUF_LEN = 0;
}
