/*
 * Copyright (c) 1990-1991 by Sun Microsystems, Inc.
 */

#ident  "@(#)cics_macro.h 1.6 93/05/19 SMI"

#ifndef _MLE_CICS_MACRO_H
#define _MLE_CICS_MACRO_H

/*
 *****************************************************************************
 *
 *  CIO/CI/CS interface :  pre-defined key=function macro (keymacro.h)
 *
 *****************************************************************************
 */

/*
 *--------------------------------------------------------------------------
 *
 *	**** NO OPERATION ****
 */
#define CS_NOP			0x0000

/*
 *--------------------------------------------------------------------------
 *
 *	**** CHARACTER INPUT ****
 */
#define CS_CHAR_EVENT  		CS_NOP
#define CS_STR_EVENT		0x0001

/*
 *--------------------------------------------------------------------------
 *
 *	**** MODE CHANGE ****
 */

/*
 *	A.	INPUT
 */
#define CS_IM_SWITCH		0x0100
#define CS_IM_KANJI		0x0101
#define CS_IM_HANKAKU		0x0102
#define CS_IM_CODE		0x0103

/*
 *	B.	CONVERT MODE
 */
#define CS_CM_SWITCH		0x0200
#define CS_CM_IKKATSU		0x0201
#define CS_CM_SAKIYOMI		0x0202
#define CS_CM_CHIKUJI		0x0203
#define CS_CM_TANBUN		0x0204
#define CS_CM_TANKAN		0x0205

/*
 *	C.	INPUT MODE
 */
#define CS_CIM_SWITCH		0x0300
#define CS_CIM_ROMAJI		0x0301
#define CS_CIM_KANA		0x0302

/*
 *	D.	"KOTEI" INPUT MODE
 */
#define CS_XIM_SWITCH		0x0400
#define CS_XIM_HIRA		0x0401
#define CS_XIM_ZENKANA		0x0402
#define CS_XIM_HANKANA		0x0403
#define CS_XIM_ZENALPHA		0x0404
#define CS_XIM_HANALPHA		0x0405
#define CS_XIM_EXIT		0x0406

/*
 *	E.	CODE
 */
#define CS_CODE_SWITCH		0x0500
#define CS_CODE_JIS		0x0501
#define CS_CODE_KUTEN		0x0502
#define CS_CODE_EUC		0x0503
#define CS_CODE_SJIS		0x0504

/*
 *--------------------------------------------------------------------------
 *
 *	**** CONVERT OPERATION ****
 */

/*
 *	A.	CONVERT
 */
#define CS_CNV_SWITCH		0x1000
#define CS_CNV_OFF		0x1002
#define CS_CNV_ON		0x1003
#define CS_CNV_CONVERT		0x1004
#define CS_CNV_HENKAN		CS_CNV_CONVERT
#define CS_CONVERT     		CS_CNV_CONVERT
#define CS_HENKAN      		CS_CONVERT
#define CS_CNV_NEXT		0x1005
#define CS_CNV_PREV		0x1006
#define CS_TO_HIRAGANA		0x1007
#define CS_TO_ZENKANA		0x1008
#define CS_TO_ZENALPHA		0x1009
#define CS_TO_HANKANA		0x100A
#define CS_TO_HANALPHA		0x100B
#define CS_TO_ZENKAKU		0x100C
#define CS_TO_HANKAKU		0x100D
#define CS_FOCUS_HEAD		0x1010
#define CS_FOCUS_TAIL		0x1011
#define CS_FOCUS_NEXT		0x1012
#define CS_FOCUS_PREV		0x1013
#define CS_FOCUS_LONG		0x1020
#define CS_FOCUS_SHORT		0x1021
#define CS_FOCUS_NLONG		0x1022
#define CS_FOCUS_NSHORT		0x1023
#define CS_COMMIT_PART		0x1030
#define CS_KAKUTEI_BUBUN	CS_COMMIT_PART
#define CS_COMMIT_ALL		0x1040
#define CS_KAKUTEI_ALL		CS_COMMIT_ALL
#define CS_COMMIT		CS_COMMIT_ALL
#define CS_KAKUTEI		CS_COMMIT

/*
 *	B.	SELECT
 */
#define CS_SELECT		0x1100
#define CS_SENTAKU		CS_SELECT

/*
 *	C.	EDIT
 */
#define CS_CNV_CANCEL		0x1200
#define CS_HENKAN_CANCEL	CS_CNV_CANCEL
#define CS_CURSOR_HEAD		0x1201
#define CS_CURSOR_TAIL		0x1202
#define CS_CURSOR_RIGHT		0x1203
#define CS_CURSOR_LEFT		0x1204
#define CS_ERASE_LCHAR		0x1205
#define CS_ERASE_CHAR		0x1206
#define CS_ERASE_EOL		0x1207
#define CS_ERASE_ALL		0x1208


/*
 *--------------------------------------------------------------------------
 *
 *	**** SELECT OPERATION ****
 */

/*
 *	A.	MENU SELECT
 */
#define CS_MENU_IM		0x1301
#define CS_MENU_CM		0x1302
#define CS_MENU_CIM		0x1303
#define CS_MENU_XIM		0x1304
#define CS_MENU_CODE		0x1305
#define CS_MENU_DICT		0x1306
#define CS_MENU_CS		0x1307

/*
 *	B.	ITEM SELECT
 */
#define CS_SELECT_NEXT		0x1310
#define CS_SELECT_PREV		0x1311
#define CS_SELECT_NUMBER	0x1320
#define CS_SELECT_HEAD		0x1330
#define CS_SELECT_TAIL		0x1331
#define CS_SELECT_RIGHT		0x1332
#define CS_SELECT_LEFT		0x1333
#define CS_SELECT_UP		0x1334
#define CS_SELECT_DOWN		0x1335
#define CS_SELECT_DONE		0x1340
#define CS_SELECT_UNDO		0x1341

/*
 *--------------------------------------------------------------------------
 *
 *	**** CONVERT ENGINE CHANGE ****
 */
#define CS_CS_SWITCH		0x1400

/*
 *--------------------------------------------------------------------------
 *
 *	**** ETC. ****
 */

#define CS_RESET_CS		0x7f00
#define CS_ONLINE_HELP          0x7f01
#define CS_UPDATE_DICT		0x7f02

#define CS_MISC_FIELD_TOP	0x7f10
#define CS_MISC_FIELD_LAST	0x7f11
#define CS_MISC_FIELD_NEXT	0x7f12
#define CS_MISC_FIELD_PREV	0x7f13

#endif		/* !_MLE_CICS_MACRO_H */
