/* ****************************************************************************
 *
 *	ximage.c	Test for XImage Handing
 *
 *		-Taura (learfox@hotmail.com)
 *
 *
 *	Compile:
 *		gcc ximage.c -o ximage -lX11 -lm -L/usr/X11/lib
 *
 *
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>


/* Pixmaps */
#include <X11/pixmaps/unknown1.xpm>



#define MAX_WIDTH 250
#define MAX_HEIGHT 187



/* Attribute mask. */
#define mask       CWBackPixel|CWBorderPixel| \
                   CWBackPixmap|CWBorderPixmap| \
                   CWBitGravity|CWWinGravity| \
                   CWColormap|CWBackingStore|CWCursor

/* Event mask to watch for. */
#define eventmask  ButtonPressMask|ButtonReleaseMask| \
                   KeyPressMask|KeyReleaseMask| \
		   ExposureMask


/*
 *   XLib Global variables.
 */
Display		*display;        
int		scr_num;
Screen		*scr_ptr;
Visual		*visual;
int		depth;
unsigned long	black_pix, white_pix;
GC		the_GC;
XGCValues	GCvalues;
Colormap	colormap;
XColor		xcolor;
XSizeHints	sizehints;
XWMHints	wmhints;

/* XEvents. */
XEvent the_event,              /* All events. */
       button_event,
       button_release_event,
       key_event,
       key_release_event;

/* XWindow attributes. */
XSetWindowAttributes attributes;

/* XFontinfos. */
XFontStruct *normal_xfont,
            *bold_xfont;

/* XFontnames. */
char *normal_fontname;
char *bold_fontname;

/*
 *   Windows involved in this program.
 */
Window toplevel,
       window1;


typedef struct
{
	XImage *ximage;
} ximage_struct;

typedef struct
{
	int load_state;
	char *data[16];
	ximage_struct image[16];
	int width, height;
	int fwidth, fheight;
}
xsw_imageset_struct;

xsw_imageset_struct xsw_imageset[1];





unsigned long XuGetColor(char *spec, XColor xcolor_in)
{
        /* Local variables. */
        unsigned long rtn_xcolor;


        /* Parse spec to get the xcolor_in. */
        if(
           (XParseColor(display, colormap, spec, &xcolor_in))
        ==
           BadColor
        )
        {
                fprintf(stderr,"Badcolor, \"%s\"\n",spec);
        }

        /* Allocate color_in. */
        XAllocColor(display, colormap, &xcolor_in);

        /* Get the pixel of the allocated color_in. */
        rtn_xcolor = xcolor_in.pixel;

        /* Return the pixel. */
        return(rtn_xcolor);
}



int update_ximage(XImage *ximage)
{
        /* Local variables. */
	int x, y;
	char color_spec[1024];

	static double gamma;	/* 0.0 to 1.0 */
	static double rxf, gxf, bxf;
        static double ryf, gyf, byf;
	static double xf, xft, yf, yft;
        unsigned long pixel;


	/* Color cycle. */
	rxf += 0.3;
        if(rxf > 6.2831853)
            rxf = 0;
	ryf = ( sin(rxf) + 1 ) / 2;

        gxf += 0.50;
        if(gxf > 6.2831853) 
            gxf = 0;
        gyf = ( sin(gxf) + 1 ) / 2;

        bxf += 0.09;
        if(bxf > 6.2831853) 
            bxf = 0;
        byf = ( sin(bxf) + 1 ) / 2;


	/* 2D Matrix, 3D Color Plane */
        for(x = 0, y = 0; y < MAX_HEIGHT;)
        {

	    /* Y colum */
            if(x >= MAX_WIDTH)
            {   
                x = 0;
                y++;

		/* Vertical color merge translation. */
		yft += 0.002;
                if(yft > 6.2831853)
                    yft = 0;

		/* "Zoom" affect. */
		yf += 0.3 * (( sin(yft) + 1 ) / 2);	/* Lens. */
		if(yf > 6.2831853)
		    yf = 0;
		gamma = ( sin(yf) + 1 ) / 2;

                sprintf(color_spec, "rgbi:%lf/%lf/%lf",
                    gamma * ryf,
                    gamma * gyf,
                    gamma * byf
                );
                pixel = XuGetColor(color_spec, xcolor);

                continue;
            }

	    /* X Colum. */

            
            XPutPixel(
                ximage,
                x, y, pixel
            );
 
            x++;
        }



        return(0);
}




/* ***************************************************************************
 *
 *                  int main(int argc, char *argv[])
 */
int main(int argc, char *argv[])
{   
	/* Local variables. */
	char *imgdata;
	XImage *ximage;
	int x, y;
	unsigned long pixel;
	XEvent buttonpress_xevent;
	char stringa[256];

        long fps_count = 0;
	long fps_last_count = 0;
        time_t fps_last_update = 0;


        /* Open a connection to the display. */
        if((display=XOpenDisplay(NULL)) == NULL)
        {
           fprintf(stderr,"%s: cannot connect to X server",argv[0]);
           if(getenv("DISPLAY") == NULL)
              fprintf(stderr,", 'DISPLAY' environment variable not set.\n");
           else
              fprintf(stderr," %s\n", XDisplayName(NULL));
           return(-1);
        }


	/* Get some default values of the server. */
        scr_num = DefaultScreen(display);
        scr_ptr = DefaultScreenOfDisplay(display);
        visual = DefaultVisualOfScreen(scr_ptr);
        depth = DefaultDepthOfScreen(scr_ptr);
        black_pix = BlackPixelOfScreen(scr_ptr);
        white_pix = WhitePixelOfScreen(scr_ptr);
        the_GC = DefaultGC(display,scr_num);
        colormap = DefaultColormap(display, scr_num);


        /* Set foreground colours. */
        XSetForeground(display, the_GC, black_pix);

        /* Setting the window attributes. */
        attributes.background_pixel = black_pix;
        attributes.background_pixmap = ParentRelative;
        attributes.border_pixel = white_pix;
        attributes.border_pixel = None;
        attributes.backing_store = NotUseful;
        attributes.bit_gravity = CenterGravity; 
        attributes.win_gravity = StaticGravity;
        attributes.colormap = DefaultColormapOfScreen(scr_ptr);
        attributes.cursor = XCreateFontCursor(display,XC_left_ptr);


	/* Clear the XEvents. */
	buttonpress_xevent.type = False;
	buttonpress_xevent.xany.window = False;


	/* Creating the toplevel window. */
	toplevel = XCreateWindow(
            display,
            DefaultRootWindow(display),
            300,
	    100,
            MAX_WIDTH,
            MAX_HEIGHT,
            1,
            depth,
            InputOutput,
            visual,
            mask, 
            &attributes
	);

	/* Creating child windows */
	window1 = XCreateSimpleWindow(display,
 		toplevel, 0, 0, MAX_WIDTH, MAX_HEIGHT, 0,
		black_pix, white_pix
	);


	/* Setting the XEvents for the windows to watch for. */
	XSelectInput(display, toplevel, eventmask);
	XSelectInput(display, window1, eventmask);

	/* Map all windows. */
	XMapWindow(display, toplevel);
	XMapSubwindows(display, toplevel);

	XClearWindow(display, toplevel);


	/* Create XImage. */
	imgdata = (void *)malloc(MAX_WIDTH * MAX_HEIGHT * 4);
	ximage = XCreateImage(
		display,
		visual,
		depth,
		ZPixmap,
		0,
		imgdata,
		MAX_WIDTH,
		MAX_HEIGHT,
		32,
		0
	);


        update_ximage(ximage);



	/* *************************************** */
	/* ***        Main Event Loop          *** */
	while(1)
	{
	    /* Check events. */
            XCheckTypedEvent(display, ButtonPress, &buttonpress_xevent);
	    if(buttonpress_xevent.type == ButtonPress)
	    {
		if(buttonpress_xevent.xany.window == window1)
		{
                   /* Close the connection to display. */
                   XCloseDisplay(display);
                
                   exit(0);
		}

		buttonpress_xevent.type = False;
		buttonpress_xevent.xany.window = False;
	    }


	    /* Draw image. */
	    sprintf(stringa, "FPS: %i", fps_last_count);
	    XSetForeground(display, the_GC, white_pix);
	    update_ximage(ximage);
            XPutImage(display, window1, the_GC, ximage,
	        0, 0,
		0, 0,
		MAX_WIDTH, MAX_HEIGHT
	    );
            XDrawString(
                display, window1, the_GC,
		8, 18, stringa, strlen(stringa)
            );


	    /* Frames per second. */
	    fps_count++;
	    if(fps_last_update < time(NULL))
	    {
		fps_last_update = time(NULL);
		fps_last_count = fps_count;
		fps_count = 0;
	    }

	    /* Sleep. */
	    usleep(120);
	}


	return(0);
}
