#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include <errno.h>
#include <ctype.h>
#include <signal.h>
#include <stdarg.h>
#include <string.h>             /* string handling. */
#include <netdb.h>              /* Get host stuff */
#include <waitflags.h>
#include <fcntl.h>

#include <sys/time.h>
#include <sys/signal.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <net/if.h>             /* Internet family. */
#include <arpa/inet.h>

#include <netinet/in.h>         /* For struct sockaddr_in */
#include <netinet/tcp.h>

#include <net/ppp_defs.h>       /* PPP definations. */






int main(int argc, char *argv[])
{
	/* Local variables. */
        int new_sock;
        struct hostent *he;
        struct servent *sp;
        struct sockaddr_in newhostaddr;
        struct timeval timeout;
        fd_set writefds;


        /* Get new hostname. */
        he = gethostbyname(argv[1]);
	if(he == NULL)
		return(-1);

        /* Get new socket. */
        new_sock = socket(AF_INET, SOCK_STREAM, 0);
        if(new_sock < 0)
		return(-1);

        newhostaddr.sin_family = AF_INET;               /* In hbo. */
        newhostaddr.sin_port = htons(23);               /* In nbo. */
        newhostaddr.sin_addr = *((struct in_addr *)he->h_addr);
        bzero(&(newhostaddr.sin_zero), 8);      /* Zero the rest of struct. */


        if(connect(new_sock, (struct sockaddr *)&newhostaddr,
                sizeof(struct sockaddr)) == -1)
                return(-1);

        /* Set socket to non-blocking. */
        fcntl(new_sock, F_SETFL, O_NONBLOCK);

	/* **************************************************************** */

	/* Close it. */
/*	close(new_sock); */


        /* Set timeout to 0. */
        timeout.tv_sec = 0;
        timeout.tv_usec = 0;


        /* Check if socket is valid. */
        FD_ZERO(&writefds);
        FD_SET(new_sock, &writefds);
        select(new_sock + 1, NULL, &writefds, NULL, &timeout);

	if(errno == EBADF)
	{
		printf("Invalid descriptor.\n");
		return(-1);
	}


	return(0);
}
