/* **************************************************************************
 *
 *	rcfile.c	Restart Configuration File Handling
 *	---------------------------------------------------
 *	Functions:
 *
 *	int RCLoadConfigurationFromFile(char *filename)
 *
 *	---
 *
 *	RCLoadConfigurationFromFile() loads configurations and puts them
 *	into the global variables from file filename.
 *	Returns the number of lines read or -1 for error.
 *
 */

#include "../include/swserv.h"



int RCLoadConfigurationFromFile(char *filename)
{
	/* Local variables. */
        FILE *fp;
        char *filebuf;
        off_t filesize;
        struct stat statbuf;

	char stringa[256];
	char stringb[256];
        char *strptr;

	int lines_read = 0;


        /* Does filename exist? */
        if(access(filename, F_OK) == -1)
        {
	    fprintf(stderr, "%s: No such file.\n", filename);
            return(-1);
        }


        /* Open filename. */
        fp = fopen(filename, "r");
        if(fp == NULL)
        {
                fprintf(stderr, "%s: Unable to open file.\n",
                        filename
                );
                return(-1);
        }


        /* Get statistics and stuff about the file. */
        fstat(fileno(fp), &statbuf);    /* Get stats on file. */
        filesize = statbuf.st_size;     /* Get size of file. */
        
        /* Allocate memory. */
        filebuf = malloc(filesize * sizeof(char) + 1);



	/* *********************************************************** */
	/* ***             Load Configuration Parameters           *** */
        while( fgets(filebuf,256,fp) != NULL )
        {
	    lines_read++;

            /* Skip comments. */
            if(strstr(filebuf,"#") != NULL)
		continue;
 
	    /* Skip short lines. */
	    if(strlen(filebuf) < 4)
                continue;


            /* Remove newline characters from filebuf. */
            while( (strptr = strchr(filebuf, '\n')) != NULL )
            {
                *strptr='\0';
            }


	    /*
             *   Parsing format:
             *
             *       <parameter>[ = <value>]
             */

	    /* Fetch parameter and put it into stringa. */
	    strncpy(stringa, filebuf, 256);
	    stringa[255] = '\0';
	    if( (strptr = strchr(stringa, '=')) != NULL)
	    {
		*strptr = '\0';
	    }


	    /* ListeningPort */
	    if( strstr(stringa, "ListeningPort") != NULL )
	    {
		if(uset_listening_port == 0)
		{
		    sscanf(filebuf, "%s %s %i",
			&stringb,
			&stringb,
			&listening_port
		    );
		    uset_listening_port = 1;
		}
		continue;
            }
	    /* ServerToplevelDir */
	    else if( strstr(stringa, "ServerToplevelDir") != NULL )
            {
                sscanf(filebuf, "%s %s %s",
                        &stringb,
                        &stringb,
                        &swserv_home_dir
                );
                continue;
            }
            /* ServerEtcDir */
            else if( strstr(stringa, "ServerEtcDir") != NULL )
            { 
                sscanf(filebuf, "%s %s %s",
                        &stringb,
                        &stringb,
                        &swserv_etc_dir
                );
                continue;
            }
            /* ServerLogsDir */
            else if( strstr(stringa, "ServerLogsDir") != NULL )
            {
                sscanf(filebuf, "%s %s %s",
                        &stringb,
                        &stringb,
                        &swserv_logs_dir
                );
                continue;
            }
            /* ServerBinDir */
            else if( strstr(stringa, "ServerBinDir") != NULL )
            {
                sscanf(filebuf, "%s %s %s",
                        &stringb,
                        &stringb,
                        &swserv_bin_dir
                );
                continue;
            }
            /* ServerDBDir */
            else if( strstr(stringa, "ServerDBDir") != NULL )
            { 
                sscanf(filebuf, "%s %s %s",
                        &stringb,
                        &stringb,
                        &swserv_db_dir
                );
                continue;
            }
            /* DBIn */
            else if( strstr(stringa, "DBIn") != NULL )
            {
		if(uset_db_in_fullname == 0)
		{
                    sscanf(filebuf, "%s %s %s",
                        &stringb,
                        &stringb,
                        &db_in_fullname
                    );
		    uset_db_in_fullname = 1;

		    /* Get full path name for db_in_fullname. */
		    sprintf(stringa, "%s/%s", swserv_db_dir, db_in_fullname);
		    strcpy(db_in_fullname, stringa);
		}
                continue;
            }
            /* DBOut */ 
            else if( strstr(stringa, "DBOut") != NULL ) 
            {
                if(uset_db_out_fullname == 0)
                {
                    sscanf(filebuf, "%s %s %s",
                        &stringb,
                        &stringb,
                        &db_out_fullname
                    );
                    uset_db_out_fullname = 1;
                
                    /* Get full path name for db_out_fullname. */
                    sprintf(stringa, "%s/%s", swserv_db_dir, db_out_fullname);
                    strcpy(db_out_fullname, stringa);
                }
                continue;
            }
            /* PrimaryLogFile */
            else if( strstr(stringa, "PrimaryLogFile") != NULL )
            {
                sscanf(filebuf, "%s %s %s",
                        &stringb,
                        &stringb,
                        &primary_log_fullname
                );
                
                /* Get full path name for primary_log_fullname. */
                sprintf(stringa, "%s/%s", swserv_logs_dir, primary_log_fullname);
                strcpy(primary_log_fullname, stringa);

                continue;
            }
            /* ObjectValuesUpdateInterval */
            else if( strstr(stringa, "ObjectValuesUpdateInterval") != NULL )
            {
                sscanf(filebuf, "%s %s %i",
                        &stringb,
                        &stringb,
                        &objval_update_interval
                );
                continue;
            }
            /* WeaponValuesUpdateInterval */
            else if( strstr(stringa, "WeaponValuesUpdateInterval") != NULL )
            {
                sscanf(filebuf, "%s %s %i",
                        &stringb,
                        &stringb,
                        &weapons_update_interval
                );
                continue;
            }
 	    /* Unknown parameter. */
	    else
	    {
		fprintf(stderr, "%s: Line %i: Unknown parameter: `%s'\n",
		    filename,
		    lines_read,
		    filebuf
		);
		continue;
	    }
	}


	/* Free filebuf and close file. */
	free(filebuf);
	fclose(fp);


	return(0);
}
