/* *************************************************************************
 *
 *	netcodes.h	Network Data Codes
 *	----------------------------------
 *
 *	Codes for network communications between ShipWars server and client.
 *
 *
 *
 */


/*
 *   Maximum Data Command Size:
 *
 *	Commands sent to the server or client may not exceed this many
 *	bytes (includes null terminating byte).
 */
#define MAX_NET_CMD_SIZE      256
#define MAX_NET_OVERFLOW_SIZE 100000


/*
 *   Maximum Message Size:
 *
 *	These are maximums for messages such as global messages, direct
 *	messages, etc.
 */
#define MAX_MESSAGE_SIZE 128


/*
 *   Network Command Codes
 *
 *	These are network command codes, their data type is of int.
 *	Farther below is a description of their formats.
 *	Keep in mind that the client and server handle these differently
 *	depending on who (client or server) sent the data stream.
 */
#define NET_CMD_COMMENT        10	/* Comment. */
#define NET_CMD_LOGIN          11	/* Send name and password. */
#define NET_CMD_LOGOUT         12	/* Log out. */
#define NET_CMD_WHOAMI	       13       /* Which ship you are. */
#define NET_CMD_ECHO           14       /* Echos back command, for pinging. */
#define NET_CMD_REFRESH        15	/* Refresh request to server. */
#define NET_CMD_SETINTERVAL    16	/* Set interval between object updates. */
#define NET_CMD_EXEC           17	/* Execute command. */

#define NET_CMD_GLOBALMESG     20	/* Message to all connected players. */
#define NET_CMD_GROUPMESG      21	/* Not supported yet. */
#define NET_CMD_DIRECTMESG     22	/* Not supported yet. */

#define NET_CMD_CREATEOBJECT   30       /* Create a new object. */
#define NET_CMD_RECYCLEOBJECT  31	/* Recycle an object. */
#define NET_CMD_SETOBJLOCAPP   32	/* Set position and apperance. */
#define NET_CMD_SETOBJVALUES   33	/* Set standard object values. */
#define NET_CMD_SETOBJMAXIMUMS 34	/* Set maximum parameters for object. */
#define NET_CMD_CREATEANIMATED 35       /* Create animated object. */
#define NET_CMD_SETWEAPON      36	/* Selects weapon. */
#define NET_CMD_SETSHIELDS     37	/* Raises/lowers shields. */
#define NET_CMD_SETDMGCTL      38	/* Activate/deactivate damage control. */
#define NET_CMD_SETCLOAK       39	/* Raises/lowers cloak. */


#define NET_CMD_WEAPONSLOCK    40	/* Cycles weapons lock. */
#define NET_CMD_WEAPONSUNLOCK  41       /* Unlocks weapons. */
#define NET_CMD_INTERCEPT      42	/* Sets intercept. */
#define NET_CMD_FIREWEAPON     43	/* Fires a weapon. */
#define NET_CMD_SETNAME        44	/* Set name of object. */
#define NET_CMD_SETWEAPONVAL   45	/* Sets values for a type of weapon */
					/* on a certain object.             */

#define NET_CMD_SETOBJLOCAPPS  46	/* Simpler than NET_CMD_SETOBJLOCAPP */



/*
 *   Network Data Stream Format:
 *
 *	The data stream is a simple null terminated string. Each data stream
 *	is prefixed by a special net command code (#define'ed above), a
 *	white space, and the rest of the data stream contains the
 *	argument data. Example:
 *
 *		"<netcmd> [<argument(s)>]"
 *
 *	Not all data streams have arguments. Some data streams have no
 *	arguments and some data streams have many arguments.
 *	Example of the login command string format:
 *
 *		"11 MAS Freedom;rhs8110"
 *
 *	The prefix code is 11, which matches the #define'ed NET_CMD_LOGIN.
 *	The argument is followed by a white space and then a 'name' and
 *	'password'. For this perticular format the 'name' and 'password'
 *	is seperated by a semicolon (;).
 *
 *	Below is a list explaining the formats for each type of net command:
 *
 *	  NET_CMD_COMMENT (client <--> server):
 *		"10 free-form string"
 *
 *	  NET_CMD_LOGIN (client <--> server):
 *		"11 MAS Freedom;rhs8110"
 *	  (The server only sends the code without the argument as a request to
 *        the client for a login name and password while the client always
 *	  sends the code and the login name and password to the server.)
 *
 *	  NET_CMD_LOGOUT (client <--> server):
 * 		"12"
 *	  (The logout data stream must first be sent by the client or server
 *	  and then another logout response must be sent back from the server or
 *	  client to verify before closing the socket.)
 *
 *	  NET_CMD_WHOAMI (client <--> server):
 *		"13 MAS Freedom;6"
 * 	  (The client sends only the command number and no argument to the
 *	  server.)
 *
 *	  NET_CMD_ECHO (client <--> server):
 *		"14 free-form string"
 * 
 *	  NET_CMD_REFRESH (client --> server):
 *		"15"
 *
 *	  NET_CMD_SETINTERVAL (client --> server):
 *              "16 1200"
 *        (In milliseconds.)
 *
 *	  NET_CMD_EXEC (client --> server):
 *              "17 command argument"
 *
 *	  NET_CMD_GLOBALMESG (client <--> server):
 * 		"20 free-form string"
 *
 *	  NET_CMD_GROUPMESG (client <--> server):
 *		*format not yet determined*
 *
 *	  NET_CMD_DIRECTMESG (client <--> server):
 *		"22 3 Hello there player number 3!"
 * 
 *	  NET_CMD_CREATEOBJECT (server --> client):
 * 		"30 6 3 12 534.234 -423.212 42.01 3.14 0"
 *		"30 <objnum> <type> <imageset> <x> <y> <z> <hdg> <pitch>"
 *
 *	  NET_CMD_RECYCLEOBJECT (server --> client):
 *		"31 6"
 *
 *	  NET_CMD_SETOBJLOCAPP (client <--> server):
 * 		"32 6 4 3 25 534.234 -423.212 0.0 3.14 0.0 0 0.03 3.14 24"
 *		"<cmdnum> <objnum> <type> <size> <imageset> <x> <y> <z> <hdg>
 *		    <pitch> <velocity> <velocity_heading> <throttle> <frame>"
 *	  (The client may *only* send this data stream to move its own
 *	  player ship. If the client recieved a move request for an object,
 *	  that has not been givin a create object request for, then the client
 *	  will automatically create that object.  Server moves all objects
 *	  *except* player objects.)
 *
 *	  NET_CMD_SETOBJVALUES (server --> client):
 *		"33 6 -1 -1 0.005 3.14 0 3.14 0.005 40 34.0 30.0 45.0 1 2 0
 *		    0.90 1.00 0"
 *		"<cmdnum> <objnum> <locked_on> <intercepting_object> <velocity>
 *		    <velocity_heading> <thrust_rev_state> <thrust_dir>
 *		    <thrust> <throttle> <hp> <power> <antimatter> <shield_state>
 *		    <selected_weapon> <cloak_state> <cloak_strength>
 *		    <visibility> <damage_control>"
 *
 *	  NET_CMD_SETOBJMAXIMUMS (server --> client):
 * 		"34 6 4 10 2 23 0.25 0.03 0.0025 0.004 25.0 40.0 0.05 0.002
 *		    40.0 2 0.98"
 *	  	"<cmdnum> <objnum> <type> <imageset> <owner> <size>
 *		    <scanner_range> <velocity_max> <thrust_power> <turnrate>
 *		    <hp_max> <power_max> <power_purity> <core_efficency>
 *		    <antimatter_max> <total_weapons> <visibility>"
 *	  (For setting maximum value parameters. This only needs to be sent
 *	  once after create or login. Or whenever a refresh is called.)
 *
 *	  NET_CMD_CREATEANIMATED (server --> client):
 *		"35 6 8 32 534.234 -423.212 0.0 3.14 0.0 250 2523432 0 4 0 1"
 *		"<cmdnum> <objnum> <type> <imgset> <x> <y> <z> <heading>
 *		    <pitch> <animation.interval> <animation.last_interval>
 *		    <animation.current_frame> <animation.total_frames>
 *		    <animation.cycle_count> <animation.cycle_times>"
 *
 *	  NET_CMD_SETWEAPON (client --> server):
 *		"36 2"
 *		"<cmdnum> <weaponnumber>"
 *        (Object will be the connection's object_num which is already known      
 *        by the server. ) 
 *
 *	  NET_CMD_SETSHIELDS (client --> server):
 *		"37 129.32"
 *		"<cmdnum> <shield_frequency>"
 *	  (Object will be the connection's object_num which is already known
 *	  by the server. )
 *
 *	  NET_CMD_SETDMGCTL (client --> server):
 *		"38"
 *		"<cmdnum>"
 *        (Object will be the connection's object_num which is already known      
 *        by the server. )
 *
 *	  NET_CMD_SETCLOAK (client --> server):
 *		"39"
 *		"<cmdnum>"
 *        (Object will be the connection's object_num which is already known      
 *        by the server. ) 
 *
 *	  NET_CMD_WEAPONSLOCK (client --> server):
 *		"40"
 *              "<cmdnum>"
 *        (Object will be the connection's object_num which is already known      
 *        by the server. ) 
 *
 *	  NET_CMD_WEAPONSUNLOCK (client --> server):
 *		"41"
 *              "<cmdnum>"
 *        (Object will be the connection's object_num which is already known      
 *        by the server. ) 
 *
 *	  NET_CMD_INTERCEPT (client --> server):
 *		"42 Kestra III"
 *		"<cmdnum> <argument>"
 *        (Object will be the connection's object_num which is already known      
 *        by the server. )
 *
 *	  NET_CMD_FIREWEAPON (client --> server):
 *		"43"
 *		"<cmdnum>"
 *        (Object will be the connection's object_num which is already known      
 *        by the server. )
 *
 *	  NET_CMD_SETNAME (server --> client):
 *		"44 6;MAS Freedom"
 *		"<cmdnum> <objnum>;<name>"
 *
 *        NET_CMD_SETWEAPONVAL (server --> client):
 *              "45 6 2 1 0 45 50 20 0.3 5.0 200 378612"
 *              "<cmdnum> <objnum> <weapon_num> <type> <emission_type>
 *		    <amount> <max> <power> <range> <create_power>
 *		    <delay> <last_used>"
 *
 *        NET_CMD_SETOBJLOCAPPS (client <--> server):
 *              "46 6 4 3 534.234 -423.212 0.0 3.14 0.0 0"
 *              "<cmdnum> <objnum> <type> <imageset> <size> <x> <y> <z> <hdg>
 *                  <pitch> <frame>"
 *        (The client may *only* send this data stream to move its own 
 *        player ship. If the client recieved a move request for an object,
 *        that has not been givin a create object request for, then the client
 *        will automatically create that object.  Server moves all objects
 *        *except* player objects, server always sends updates for all objects.)
 *
 *
 */
