/* **************************************************************************
 *
 *	prochandle.c	Process Handling
 *	--------------------------------
 *	Functions:
 *
 *	void fork_system(char *command_string)
 *	void zombiekiller()
 *
 *	---
 *
 *	fork_system() forks off a process then uses system()
 *	to execute command_string.
 *
 *	zombiekiller() is used to kill zombie processes
 *	created by finished child processes.
 *
 */

#include "../include/xsw.h"  




void fork_system(char *command_string)
{
	/* For eliminating zombies proccesses. */
	signal(SIGCHLD, zombiekiller);

        /* Fork off a process to ping so we can let the */
        /* rest of the program run.                    */
        switch(fork())
        {
	    /* Forking error. */
            case -1:
                perror("fork");
                exit(1);

	    /* We are the child: run then command then exit. */  
            case 0:
                if( system(command_string) == -1 )
                {
                        fprintf(stderr,"Shell command execution error.");
                        exit(-1);
                }
                exit(0);

	    /* We are the parent: do nothing. */        
            default:
                break;
        }
        return;
}



void zombiekiller()
{
        union wait wstatus;
        while(wait3(&wstatus,WNOHANG,NULL) > 0);
}
