/* **********************************************************************
 *
 *	lexec.c		Local Exec Command Interpriting and Executing
 *	-------------------------------------------------------------
 *	Functions:
 *
 *	int LExecDoHelp(char *arg)
 *	int LExecDoSet(char *arg)
 *	int LExecDoLname(char *arg)
 *	int LExecDoLpassword(char *arg)
 *	int LExecDoConnect(char *input)
 *	int LExecDoDisconnect(char *arg)
 *	int LExecDoRefresh(char *arg)
 *	int LExecHandleInput(char *input)
 *
 *	---
 *
 *	LExecHandleInput() is the front end handler for parsing
 *	input string input.   Returns non-zero on invalid input
 *	string input or error parsing it.
 *
 *
 *
 *
 */



#include "../include/xsw.h"



int LExecDoHelp(char *arg)
{
	/* Local variables. */
	char stringa[256];


	/* Print help. */
	strncpy(stringa,
 "Local commands; connect  disconnect  help  lname  lpassword  refresh  version",
		256
	);
	MesgWinAddMessage(stringa, normal_text_pixel);


	return(0);
}



int LExecDoVersion(char *arg)
{
        /* Local variables. */
        char stringa[256];

 
        /* Print help. */
        sprintf(stringa,
                "%s - Version %s",
                XSW_NAME,
		XSW_VERSION
        );
        MesgWinAddMessage(stringa, normal_text_pixel);
        

        return(0);
}



int LExecDoSet(char *arg)
{
        /* Local variables. */
        
        MesgWinAddMessage("LExecDoSet() is still under construction.",
            normal_text_pixel
        );

         
        return(0);
}



int LExecDoLname(char *arg)
{
	/* Local variables. */
	char stringa[MAX_LEXEC_ARG_LEN];


	/* Print current value? */
	if(strlen(arg) < 1)
	{
	    sprintf(stringa, "Login name: \"%s\"", loginname);
            MesgWinAddMessage(stringa, normal_text_pixel);
	    return(0);
	}


/* Sanitize login name? */

	/* Set the new login name. */
	strncpy(loginname, arg, MAX_NAME_LENGTH);
	loginname[MAX_NAME_LENGTH - 1] = '\0';


	/* Print response on message_win. */
	sprintf(stringa, "Login name: \"%s\"", loginname);
        MesgWinAddMessage(stringa, normal_text_pixel);


	return(0);
}


int LExecDoLpassword(char *arg)
{
        /* Local variables. */
        char stringa[1024];
 

        /* Print current value? */
        if(strlen(arg) < 1)
        {
            sprintf(stringa, "Login password: \"%s\"", loginpassword);
            MesgWinAddMessage(stringa, normal_text_pixel);
            return(0);
        }
          
 /* Sanitize login password? */


	/* Set login password. */
        strncpy(loginpassword, arg, MAX_PASSWORD_LENGTH);
	loginpassword[MAX_PASSWORD_LENGTH - 1] = '\0';
  

        /* Print response on message_win. */
        sprintf(stringa, "Login password: \"%s\"", loginpassword);
        MesgWinAddMessage(stringa, normal_text_pixel);
 

	return(0); 
}



int LExecDoConnect(char *input)
{
	/* Local variables. */
	char stringa[1024];
	long x;

	/* Print current status? */
	if(strlen(input) < 1)
	{
	    if(swserv_socket > -1)
	    {
		sprintf(stringa, "Connected to: %s  Port: %i",
		    swservaddress,
                    swservport
		);
		MesgWinAddMessage(stringa, normal_text_pixel);
	    }
	    else
	    {
		MesgWinAddMessage("Not connected.", normal_text_pixel);
	    }

            /* Print book marked server addresses. */
            for(x = 0; x < total_address_entries; x++)
            {
                sprintf(stringa, "%s: %s", 
                    swserv_addr_ent[x].alias,
                    swserv_addr_ent[x].url
                );
                MesgWinAddMessage(stringa, normal_text_pixel);
            }

	    return(0);
	}



	/* Check if we are already connected. */
	if(swserv_socket > -1)
	{
	    MesgWinAddMessage("Already connected.", normal_text_pixel);
	    return(-2);
	}


	/* Begin parsing. */
	if(strchr(input, ':') == NULL)
	{
	    swservport = -1;
	    for(x = 0; x < total_address_entries; x++)
	    {
		if(strcmp(input, swserv_addr_ent[x].alias) == 0)
		{
                    strcpy(swservaddress,
			StringParseAddress(swserv_addr_ent[x].url));
                    swservport = StringParsePort(swserv_addr_ent[x].url);
		    break;
		}
	    }
	    /* Did we find an alias match? */
	    if(swservport < 0)
	    {
		sprintf(stringa, "%s: No such alias.", input);
                MesgWinAddMessage(stringa, normal_text_pixel);
                return(-1);
	    }
	}
	else
	{
            strcpy(swservaddress, StringParseAddress(input));
            swservport = StringParsePort(input);
	}

        /* Open connection. */
        swserv_socket = NetOpenConnection(swservaddress, swservport);


	/* Check if we were able to connect. */
        if(swserv_socket < 0)
        {
            sprintf(stringa, "Unable to connect to: %s  port: %i",
                swservaddress, swservport);
            MesgWinAddMessage(stringa, normal_text_pixel);
	    return(-1);
        }
        /* We're connected, set up some default connect values. */
        else
        {
            MesgWinAddMessage("Connected!", normal_text_pixel);
            /* Set default update interval. */
            net_server_update_interval = DEFAULT_UPDATE_INTERVAL;
            /* Set connection_state to 1. */
            connection_state = 1;

	    /* Clear database and unmap windows on game_win. */
            DBClearObjectsFromMemory();
	    XUnmapSubwindows(display, game_win);
        }



	return(0);
}



int LExecDoDisconnect(char *arg)
{
	/* Local variables. */
	char stringa[256];


	/* Not connected? */
	if(swserv_socket < 0)
	{
	    strncpy(stringa, "Not connected.", 256);
            MesgWinAddMessage(stringa, normal_text_pixel);
	    return(-1);
	}


	/* Sent disconnect. */
	strncpy(stringa, "Disconnecting...", 256);
        MesgWinAddMessage(stringa, bold_text_pixel);

        NetSendDisconnect();
	disconnect_send_count++;


	/* Force disconnect? */
        if(disconnect_send_count > 2) 
        {
            swserv_socket = -1;
            lplayer_object = -1;
            connection_state = 0;
	    disconnect_send_count = 0;

	    strncpy(stringa, "Force disconnected.", 256);
	    MesgWinAddMessage(stringa, bold_text_pixel);

        }

	return(0);
}



int LExecDoRefresh(char *arg)
{
	/* Local variables. */
	char stringa[256];
	char sndbuf[MAX_NET_CMD_SIZE];

	/* Not connected? */
	if(swserv_socket < 0)
	{
            strncpy(stringa, "Not connected.", 256);
            MesgWinAddMessage(stringa, normal_text_pixel);
            return(-1);
	}


	/* Send refresh request to server. */
	strncpy(stringa, "Refresh request sent.", 256);
        MesgWinAddMessage(stringa, normal_text_pixel);

        sprintf(sndbuf, "%i\n%c", NET_CMD_REFRESH, '\0');
        NetSendData(sndbuf);


	return(0);
}



int LExecDoQuit(char *arg)
{
	xsw_exit_CB();

	exit(0);

	return(0);
}



int LExecHandleInput(char *input)
{
	/* Local variables. */
	int x, y, z;
	char *strptr;

	char stringa[MAX_LEXEC_ARG_LEN];
        char stringb[MAX_LEXEC_ARG_LEN];
	char arg[MAX_LEXEC_ARG_LEN];
	char command[MAX_LEXEC_ARG_LEN];
	int command_code;

	int status;


	/* Input command must be atleast 1 character long. */
	if(strlen(input) < 1)
		return(-1);

	/* Strip spaces. */
	strncpy(stringa, input, MAX_LEXEC_ARG_LEN);


	/* Copy input string to stringa and sanitize stringa. */
	strncpy(stringa, input, MAX_LEXEC_ARG_LEN);

	strncpy(stringb, StringStripSpaces(stringa), MAX_LEXEC_ARG_LEN);
	strncpy(stringa, stringb, MAX_LEXEC_ARG_LEN);

	stringa[MAX_LEXEC_ARG_LEN - 1] = '\0';
	if( (strptr = strchr(stringa, '\n')) != NULL)
		*strptr = '\0';


	/* ******************************************************** */
	/* ***                Begin Parsing                     *** */
	if( (strptr = strchr(stringa, ' ')) != NULL)
	{
		strncpy(arg, (strptr + 1), MAX_LEXEC_ARG_LEN);
		*strptr = '\0';
		strncpy(command, stringa, MAX_LEXEC_ARG_LEN);
	}
	else
	{
		strncpy(arg, "", MAX_LEXEC_ARG_LEN);
		strncpy(command, stringa, MAX_LEXEC_ARG_LEN);
	}


	/* ****************************************************** */
	/* ***                   Handle Command               *** */

	/* Help. */
        if( (0 == strcmp(command, "help")) ||
            (0 == strcmp(command, "hel")) ||
            (0 == strcmp(command, "h")) ||
            (0 == strcmp(command, "?"))
        )
	{
	    status = LExecDoHelp(arg);
	}
        /* Version. */
        else if( (0 == strcmp(command, "version")) ||
                 (0 == strcmp(command, "ver"))
        )
        {
	    status = LExecDoVersion(arg);
	}
	/* Set. (not available yet) */
	else if( (0 == strcmp(command, "set")) ||
	    (0 == strcmp(command, "se")) ||
            (0 == strcmp(command, "s"))
	)
	{
            status = LExecDoSet(arg);
	}
	/* Login name. */
        else if( (0 == strcmp(command, "lname")) ||
                 (0 == strcmp(command, "ln"))
	)
        {
            status = LExecDoLname(arg);
        }
	/* Login password. */
        else if( (0 == strcmp(command, "lpassword")) ||
                 (0 == strcmp(command, "lpasswd")) ||
		 (0 == strcmp(command, "lpass"))
	)
        {
            status = LExecDoLpassword(arg);
        }
	/* Connect to server. */
        else if( (0 == strcmp(command, "connect")) ||
		 (0 == strcmp(command, "con"))
	)
        {
	    status = LExecDoConnect(arg);
	}
	/* Disconnect. */
        else if( (0 == strcmp(command, "disconnect")) ||
                 (0 == strcmp(command, "discon")) ||
                 (0 == strcmp(command, "bye"))
        )
        {
            status = LExecDoDisconnect(arg);
        }
        /* Refresh. */
        else if( 0 == strcmp(command, "refresh")
        )
        {
            status = LExecDoRefresh(arg);
        }
        /* Quit. */
        else if( (0 == strcmp(command, "quit")) ||
		 (0 == strcmp(command, "exit"))
        )
        {
            status = LExecDoQuit(arg);
        }
	else
	{
            sprintf(stringa,
		"%s: no such command or macro.",
		command
	    );
            MesgWinAddMessage(stringa, normal_text_pixel);
	}


	return(status);
}
