/* graphics.h - interface to easy-to-use Xlib wrapper routines
** copyleft March 1997 Quantum Porcupine / grey (pascal@acm.org)
** all rights reserved.
**
** you may use this code in any production as long as you do not derive
** profit from it.  if you do use it, please let me know. :)
**
** see the included testgraph.c for examples on using this.
*/

#ifndef __graphics_h__
#define __graphics_h__

/* includes */
#include <X11/Xlib.h>
#include <X11/Xutil.h>

typedef struct QGraph {
        Display *disp;
        Window win;   
        Visual *vis;
        int scr;
	int w, h, size; /* width, height, and size (in bytes) of window */
        GC gc;
        XImage *xim; 
        void *im;
        unsigned long wht;
        unsigned long blk;
	int depth;
	int rmask, gmask, bmask;
	int rs, gs, bs;
	Colormap cm;
} QGraph;

QGraph *QSetupGraphics (char *disp, int w, int h);
	/* returns a pointer to a newly-initialized graph window structure
	   which has width w and height h */
int ShutdownGraphics (QGraph *g);
	/* closes and deallocates the graph window corresponding to g */

void *GetBuffer (QGraph *g);
	/* returns a pointer to the unsigned char array which contains g's
	   linear frame buffer */

void SetColor (QGraph *gb, int c, int r, int g, int b);
	/* sets a color of the palette for the window corresponding to gb.
	   c is the color index to change.  the values for r, g and b are
	   in the range 0..255. */

void Blit (QGraph *g, int x, int y, int w, int h);
	/* updates the window in the region corresponding to a rectangle
	   with the upper-left corner at (x,y) with width w and height h.
	   i.e. a nice partial blit. :) */

#endif
