/* graph32.h - MAGE 32-bit graphics interface (XGraph wrapper) */

#ifndef __GRAPH32_H__
#define __GRAPH32_H__

#include "graphics.h"

#define PACK8(r, g, b)  ((r<<16)+(g<<8)+b)
#define PACK16(r, g, b) (((r<<8)&0xFF0000) + (g&0xFF00) + (b>>8))
#define PACK24(r, g, b) ((r&0xFF0000) + ((g>>8)&0xFF00) + (b>>16))

typedef struct Graph {
	QGraph *xg;
	int bpp, shm;
	unsigned int rm, gm, bm;
	unsigned int rs, gs, bs;
} Graph;

Graph *SetupGraphics (int argc, char *argv[], int w, int h, char *title);
/* probe for the highest bitdepth and MITSHM possible */

void BlitBuffer (Graph *g, unsigned int *buf);
/* blit the buffer (stored as (R<<16)|(G<<8)|(B)) */

#endif
