/* graph32.c - bitdepth-independent blitting routines */

#include <stdlib.h>
#include <math.h>
#include "graph32.h"

#ifndef PI
# define PI 3.1415927
#endif

/*#define HSV*/

int dithmask[16] =
    { 0,  8,  2, 10,
     12,  4, 14,  6,
      3, 11,  1,  9,
     15,  7, 13,  5};
int oflowr[512], oflowg[512], oflowb[512];

Graph *SetupGraphics (int argc, char *argv[], int w, int h, char *title)
{
	Graph *g;
	int bpp;
	int shm;
	int err;
	int rm, gm, bm;
	int i;
	XVisualInfo *xvinfo;

	g = (Graph *)malloc(sizeof(Graph));
	if (!g)
		return NULL;

	printf ("meep\n");

	g->xg = QSetupGraphics ((char *)getenv("DISPLAY"), w, h);

	/*DefaultVisual(g->xg->disp, g->xg->scr)*/
	bpp = g->bpp = g->xg->depth;
	/*g->shm = (shm == XG_DIRECT);*/

	printf ("kerpuffle %d\n", g->bpp);

	if (bpp != 8)
	{
		printf ("happy\n");
		g->rm = g->xg->vis->red_mask;
		g->gm = g->xg->vis->green_mask;
		g->bm = g->xg->vis->blue_mask;
	}
	else
	{
		printf ("sad\n");
		g->rm = 0xE0;
		g->gm = 0x1C;
		g->bm = 0x03;

		printf ("Setting colors\n");
#ifdef HSV
		for (i = 0; i < 256; i++)
		{
			int hue = i&0xE0;
			int lum = (i&0x1C)<<3;
			int sat = (i&0x03)<<6;
			int cr, cg, cb;

			cr = 127.5*sin(hue*PI/128) + 127.5;
			cg = 127.5*sin((hue+85)*PI/128) + 127.5;
			cb = 127.5*sin((hue-85)*PI/128) + 127.5;

			cr = cr*(sat+63)/256 + 192 - sat;
			cg = cg*(sat+63)/256 + 192 - sat;
			cb = cb*(sat+63)/256 + 192 - sat;

			cr = cr*(lum+31)/256;
			cg = cg*(lum+31)/256;
			cb = cb*(lum+31)/256;

			SetColor (g->xg, i, cr, cg, cb);
		}
#else
		for (i = 0; i < 256; i++)
			SetColor (g->xg, i, i&0xE0, (i&0x1C)<<3,
			    (i&0x03)<<6);
#endif

		for (i = 0; i < 256; i++)
		{
			oflowr[i] = i&0xE0;
			oflowg[i] = (i>>3)&0x1C;
			oflowb[i] = (i>>6)&0x03;
		}
		for (i = 256; i < 512; i++)
		{
			oflowr[i] = 0xE0;
			oflowg[i] = 0x1C;
			oflowb[i] = 0x03;
		}
	}

	printf ("fluff?\n");

	rm = g->rm = g->xg->vis->red_mask;
	gm = g->gm = g->xg->vis->green_mask;
	bm = g->bm = g->xg->vis->blue_mask;

	if (bpp == 16)
	{
		printf ("mask16\n");
		for (i = 0; i < 24; i++)
		{
			if (rm == (rm & (255<<16>>i)))
				g->rs = i;
			if (gm == (gm & (255<<16>>i)))
				g->gs = i;
			if (bm == (bm & (255<<16>>i)))
				g->bs = i;
		}
	}
	else if (bpp == 24)
	{
		printf ("mask24\n");
		for (i = 0; i < 32; i++)
		{
			if (rm == rm & ((255<<16)>>i))
				g->rs = i;
			if (gm == gm & ((255<<16)>>i))
				g->gs = i;
			if (bm == bm & ((255<<16)>>i))
				g->bs = i;
		}
	}
	else if (bpp == 32)
	{
		printf ("mask32\n");
		/*for (i = 0; i < 32; i++)
		{
			if (rm == rm & ((255<<24)>>i))
				g->rs = i;
			if (gm == gm & ((255<<24)>>i))
				g->gs = i;
			if (bm == bm & ((255<<24)>>i))
				g->bs = i;
		}*/
	}

	printf ("%d %d %d\n", g->rs, g->gs, g->bs);

	// kludge. will work in X11R6, dunno about earlier or later
        XSelectInput (g->xg->disp, g->xg->win, 0x00FFFFFF);

	return g;
}

void BlitBuffer (Graph *g, unsigned int *buf)
{
	unsigned int rm, gm, bm;
	int rs, gs, bs;
	int i, j, w, h, res;
	unsigned char *vm;

	rm = g->rm;
	gm = g->gm;
	bm = g->bm;

	rs = g->rs;
	gs = g->gs;
	bs = g->bs;

	/*if (g->shm)
		vm = g->xg.VideoMemory;
	else
		vm = g->xg.VirtualScreen;*/
	vm = g->xg->im;

	w = g->xg->w;
	h = g->xg->h;
	res = w*h;

	if (g->bpp == 8)
	{
		unsigned char *scr = vm;
		int m, pos;
		int r, g, b;
		int error, pixel;

		error = rand();

		for (i = 0; i < res; i++)
		{
			pixel = buf[i];
			error = (error + pixel) & 0x1F1F3F;

			r = oflowr[((pixel>>16)&255) + ((error>>16)&255)];
			g = oflowg[((pixel>>8)&255) + ((error>>8)&255)];
			b = oflowb[((pixel)&255) + ((error)&255)];

			scr[i] = r + g + b;
		}

		/*pos = 0;
		for (j = 0; j < h; j++)
			for (i = 0; i < w; i++)
			{
				m = dithmask[((j&3)<<2)+(i&3)];
				r = oflow[((buf[pos]>>16)&255)+(m<<1)];
				g = oflow[((buf[pos]>>8)&255)+(m<<1)];
				b = oflow[((buf[pos])&255)+(m<<2)];
				scr[pos++] = (r&0xE0) | ((g>>3)&0x1C) |
				    ((b>>6)&0x03);
			}*/
	}
	else if (g->bpp == 16)
	{
		unsigned short *scr = (unsigned short *)vm;

		/*for (i = 0; i < res; i++)
			scr[i] = ((buf[i]>>rs)&rm) |
			    ((buf[i]<<8>>gs)&gm) |
			    ((buf[i]<<16>>bs)&bm);*/
		for (i = 0; i < res; i++)
			scr[i] = ((buf[i]>>8)&0xF800) |
			    ((buf[i]>>(5))&0x07E0) |
			    ((buf[i]>>(3))&0x001F);
	}
	else if (g->bpp == 24)
	{
		unsigned char *scr = (unsigned char *)vm;
		int pos = 0;

		for (i = 0; i < res; i++)
		{
			scr[pos++] = buf[i];
			scr[pos++] = buf[i]>>8;
			scr[pos++] = buf[i]>>16;
		}
	}
	else if (g->bpp == 32)
	{
		unsigned int *scr = (unsigned int *)vm;

		/*for (i = 0; i < res; i++)
			scr[i] = (((buf[i]<<24)>>rs)&rm) |
			    (((buf[i]<<16)>>gs)&gm) |
			    (((buf[i]<<8)<<bs)&bm);*/
		/*memcpy (scr, buf, res*4);*/
		if (buf != scr)
			for (i = 0; i < res; i++)
				scr[i] = buf[i];
	}

	/*if (g->shm)
		Sync (&(g->xg));
	else
		Blit (&(g->xg));*/
	Blit (g->xg, 0, 0, g->xg->w, g->xg->h);
}
