#include <stdio.h>
#include <strings.h>
#include <stdlib.h>
#include <unistd.h>


char *StringParseAddress(char *input_str)
{
        /* Local variables. */
        static char return_str[1024];
        static char temp_str[1024];
        char *strptr;

        /* input_str must be atleast 1 character long. */
        if(strlen(input_str) <= 0)
                return(NULL);


        /* Copy input_str to return_str. */
        strcpy(return_str, input_str);


        /* See if return_str is prefixed with "proto://" */
        strcpy(temp_str, return_str);
        if( (strptr = strstr(temp_str, "//")) != NULL)
        {
                strcpy(return_str, strptr + 2);
        }


        /* See if return_str is postfixed with ":1234" */
        strcpy(temp_str, return_str);
        if( (strptr = strstr(temp_str, ":")) != NULL)
        {
                *strptr = '\0';
                strcpy(return_str, temp_str);
        }


        return(return_str);
}



int StringParsePort(char *input_str)
{
        /* Local variables. */
        int return_port;   
        char stringa[1024];
        char stringb[1024];
        char *strptr;
        
 
        /* input_str must be atleast 1 character long. */
        if(strlen(input_str) <= 0)
                return(-1);
 
        
        return_port = -1;
        strcpy(stringa, input_str);


	/* Search for "://" in stringa. */
	if( (strptr = strstr(stringa, "://")) != NULL)
	{
		strcpy(stringb, strptr + 3);
		strcpy(stringa, stringb);
	}


        /* Search for ":" in stringa. */
        if( (strptr = strstr(stringa, ":")) != NULL)
        {
                strcpy(stringb, strptr + 1);
                return_port = atoi(stringb);
        }
        else
        {
                return(-1);
        }   
 
 
        return(return_port);
}


int main(int argc, char *argv[])
{
	if(argc < 2)
	{
		printf("%s: No argument givin.\n", argv[0]);
		return(0);
	}


	if(argv[1][0] == '-')
		printf("Contians \"-\".\n");

        if(argv[1][0] == '+')
                printf("Contians \"+\".\n");

        if(argv[1][0] == '/')
                printf("Contians \"/\".\n");

	return(0);
}
