/* *************************************************************************
 *
 *	Dynamic array example, by Taura LearFox.
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <malloc.h>



typedef struct
{
	long frames;
	long cycle_total;
	long cycle_count;
	long interval;
} animation_struct;



/* Create a normal structure for the objects, like we always do.
 */
struct xsw_object_struct
{
	char name[256];
	int type;
	struct xsw_object_struct *next;
	animation_struct animation[4];
} *xsw_object_first=0, *xsw_object_last=0;

/* See the 2 alias pointers above?  They will be pointers to the first and
 * last XSW Objects allocated in memory.
 */



/* We need to keep track of the total objects we have.
 * total_objects is relative to 1.   1 means 1 object.
 */
long total_objects;



/* ***************************************************************************
 *
 *	Convience function to allocate memory for XSW Objects.
 *
 */
int DBCreateObject(long *count)
{
	/* Local variables. */
	struct xsw_object_struct *new;


	/* Allocate the memory needed for 1 XSW Object. */
	new = calloc(1, sizeof(struct xsw_object_struct));
	if(new != 0)
	{
	    if(xsw_object_first == 0)
	    {
	        xsw_object_first = new;
            }
	    else
            {
		xsw_object_last->next = new;
            }

	    xsw_object_last = new;
	    new->next = 0;

	    ++ *count;

	    return(0);
	}
	else
	{
	    fprintf(stderr, "Object memory allocation error.\n");

	    return(-1);
	}
}



struct xsw_object_struct *DBGetObjectPointer(long object_num)
{
	/* Local variables. */
	long x;
	struct xsw_object_struct *object_ptr;


	/* object_num must be positive. */
	if(object_num < 0)
		return(0);


	/* must have atleast one object in memory. */
	if(total_objects <= 0)
		return(0);

        /* Go through the list of objects till we get the right pointer. */
	object_ptr = xsw_object_first;
        for(x = 0; x < total_objects; x++)
        {
           if(x != object_num)
           {
                object_ptr = object_ptr->next;
                continue;
           }
	   else
	   {
	        break;
	   }        
        }


	return(object_ptr);
}



int DBGetObjectType(long object_num)
{
	/* Local variables. */
        struct xsw_object_struct *object_ptr;


	/* Get object pointer. */
	object_ptr = DBGetObjectPointer(object_num);
	if(object_ptr == 0)
		return(-1);


	return(object_ptr->type);
}



int DBSetAnimationFrames(long object_num, int new_frames)
{
        /* Local variables. */
	struct xsw_object_struct *object_ptr;


	/* Get object pointer. */
	object_ptr = DBGetObjectPointer(object_num);
	if(object_ptr == 0)
		return(-1);


	return(object_ptr->animation[0].frames);
}



int DBSetObjectType(long object_num, int new_type)
{
        /* Local variables. */
        struct xsw_object_struct *object_ptr;


        /* Get object pointer. */
        object_ptr = DBGetObjectPointer(object_num);
        if(object_ptr == 0)
                return(-1);
                

	object_ptr->type = new_type;


        return(0);
}           



void DBFreeAll()
{
	long x;
        struct xsw_object_struct *object_ptr;
        struct xsw_object_struct *prev_object_ptr;



	/* Nothing to do? */
	if(total_objects <= 0)
		return;


	/* Begin freeing memory. */
	object_ptr = xsw_object_first;

	while(object_ptr != 0)
	{
		prev_object_ptr = object_ptr;
		object_ptr = prev_object_ptr->next;
		free(prev_object_ptr);
	}

	/* Set total objects to 0. */
	total_objects = 0;


	return;
}



int main(int argc, char *argv[])
{
	/* Local variables. */
	int x, y, z;
	char stringa[128];


	/* Set total objects to 0. */
	total_objects = 0;


	/* Allocate 500 objects. */
	for(x=0; x<500; x++)
	{
	    DBCreateObject(&total_objects);
	}

	/* Print results. */
	printf("Allocated %i XSW Objects.\n", total_objects);


	/* Set object 4 to type 6 (weapon object I think) */
	DBSetObjectType(4, 6);

	/* See what type is object 4. */
	printf("Object %i is type %i.\n",4, DBGetObjectType(4));



	/* Free memory after use. */
	DBFreeAll();


	return(0);
}
