/* ***********************************************************************
 *
 *	weapons.c	Weapon Fire Object Creation
 *	-------------------------------------------
 *	Functions:
 *
 *	int WepCreate(
 *          long weapon_type,
 *          long owner,
 *          double birth_x,
 *          double birth_y,
 *          birth_heading,
 *          double power,
 *          double range
 *      )
 *
 *      ---
 *
 *	Various weapon fire creation functions.   Creating a weapon
 *	fire object (such as a torpedo) and sending it off on its way.
 *	movement.c takes care of the impact and lifespan management
 *	for these objects.
 *
 *      EventHandleWeaponFire() is the front end function that should
 *      be called.   Does all permission checking on object_num.
 *	Returns number of objects created.
 */

#include "../include/swserv.h"



/* ************************************************************************
 * 
 *                           Stream Phazer
 * 
 */
int WepCreatePhazer1
(
        long owner,       /* Must not be garbage or error. */
        double birth_x,
        double birth_y,
        double birth_heading,
        double power,
        double range      /* Disgarded for projectile weapons */
)
{
        /* Local variables. */
        double rel_x, rel_y;
	char stringa[256];
        long objects_created = 0;
        long cw_object = 0;             /* Current object being worked on. */

  
        /* Owner must be valid. */
        if(owner < 0)
                return(-1);

	/* Stream weapon's birth_heading will be the direction */
	/* of what the owner object is locked on.              */
	if( (xsw_object[owner].locked_on > -1) &&
		(xsw_object[owner].locked_on <= MAX_OBJECTS) )
	{
		cw_object = xsw_object[owner].locked_on;
		birth_heading = MuLocationtoHeading(
		    xsw_object[cw_object].x - xsw_object[owner].x,
		    xsw_object[cw_object].y - xsw_object[owner].y
		);
	}


        /* *********************************************** */
        /* ***      Create Weapon Fire Object(s)       *** */
        
        /* Object 1 of 1. */
        cw_object = DBCreateObject(200, 150);
        if(cw_object < 0)
                return(-1);
        else
                objects_created++;

        /* Get relative position. */
	rel_x = 0;
	rel_y = 0;

        sprintf(xsw_object[cw_object].name, "");
        sprintf(xsw_object[cw_object].empire, xsw_object[owner].empire);
        xsw_object[cw_object].owner = owner;
        xsw_object[cw_object].type = XSW_OBJ_TYPE_STREAMWEAPON;
        xsw_object[cw_object].imageset = IMAGESET_CODE_WEP_STREAM_Y;
        xsw_object[cw_object].size = range;
        xsw_object[cw_object].window_width = 200;
        xsw_object[cw_object].window_height = 150;
        xsw_object[cw_object].heading = birth_heading;
        xsw_object[cw_object].x = birth_x + rel_x;
        xsw_object[cw_object].y = birth_y + rel_y;
        xsw_object[cw_object].z = 0;
        xsw_object[cw_object].velocity_heading = xsw_object[owner].velocity_heading;
        xsw_object[cw_object].velocity = xsw_object[owner].velocity;
        xsw_object[cw_object].velocity_max = 0.07;
        xsw_object[cw_object].thrust_rev_state = 0;
        xsw_object[cw_object].thrust_dir = 3.1415927;
        xsw_object[cw_object].thrust_power = 0.009;
        xsw_object[cw_object].thrust = xsw_object[owner].thrust;
        xsw_object[cw_object].throttle = 100;
        xsw_object[cw_object].turnrate = 0.0004;
        xsw_object[cw_object].power = power;
        xsw_object[cw_object].birth_time = cur_millitime;
        xsw_object[cw_object].age = 0;
        xsw_object[cw_object].lifespan = 300;
        xsw_object[cw_object].antimatter = 5;
        xsw_object[cw_object].antimatter_max = 5;

 
        return(objects_created);
}



/* ************************************************************************
 *
 *                       Pulse Phazer: Single Fire
 *
 */

int WepCreatePulsePhazer1
(
	long owner,       /* Must not be garbage or error. */
	double birth_x,
	double birth_y,
	double birth_heading,
	double power,
	double range      /* Disgarded for projectile weapons */
)
{
        /* Local variables. */
        double rel_x, rel_y;
        long objects_created = 0;
        long cw_object = 0;             /* Current object being worked on. */
        
        
        /* Owner must be valid. */
        if(owner < 0)
                return(-1);
        
        /* *********************************************** */
        /* ***      Create Weapon Fire Object(s)       *** */
        
        /* Object 1 of 1. */
        cw_object = DBCreateObject(200, 150);
        if(cw_object < 0)  
                return(-1);
        else
                objects_created++;

        /* Get relative position. */
        rel_x = MuPolarRotX(birth_heading, 0.020);
        rel_y = MuPolarRotY(birth_heading, 0.020);

        sprintf(xsw_object[cw_object].name, "");
        sprintf(xsw_object[cw_object].empire, xsw_object[owner].empire);
        xsw_object[cw_object].owner = owner;
        xsw_object[cw_object].type = XSW_OBJ_TYPE_WEAPON;
        xsw_object[cw_object].imageset = IMAGESET_CODE_WEP_PP_Y;
        xsw_object[cw_object].size = 6;
        xsw_object[cw_object].window_width = 200;
        xsw_object[cw_object].window_height = 150;
        xsw_object[cw_object].heading = birth_heading;
        xsw_object[cw_object].x = birth_x + rel_x;
        xsw_object[cw_object].y = birth_y + rel_y;
        xsw_object[cw_object].z = 0;
        xsw_object[cw_object].velocity_heading = xsw_object[owner].velocity_heading;
        xsw_object[cw_object].velocity = xsw_object[owner].velocity;
        xsw_object[cw_object].velocity_max = 0.07;
        xsw_object[cw_object].thrust_rev_state = 0;
        xsw_object[cw_object].thrust_dir = 3.1415927;
        xsw_object[cw_object].thrust_power = 0.009;
        xsw_object[cw_object].thrust = xsw_object[owner].thrust;
        xsw_object[cw_object].throttle = 100;
        xsw_object[cw_object].turnrate = 0.0004;
        xsw_object[cw_object].power = power;
        xsw_object[cw_object].birth_time = cur_millitime;
        xsw_object[cw_object].age = 0;
        xsw_object[cw_object].lifespan = 1600;
        xsw_object[cw_object].antimatter = 5;  
        xsw_object[cw_object].antimatter_max = 5;

        return(objects_created);
}



/* ************************************************************************
 *
 *                       Pulse Phazer: Double Fire
 * 
 */

int WepCreatePulsePhazer2
(
        long owner,       /* Must not be garbage or error. */
        double birth_x,
        double birth_y,
	double birth_heading,
        double power,
        double range      /* Disgarded for projectile weapons */
)
{
	/* Local variables. */
	double rel_x, rel_y;
	long objects_created = 0;
	long cw_object = 0;		/* Current object being worked on. */


	/* Owner must be valid. */
	if(owner < 0)
		return(-1);

	/* *********************************************** */
	/* ***      Create Weapon Fire Object(s)       *** */

	/* Object 1 of 2. */
	cw_object = DBCreateObject(200, 150);
	if(cw_object < 0)
		return(-1);
	else
		objects_created++;

	/* Get relative position. */
	rel_x = MuPolarRotX(5.4105207 + birth_heading, 0.039);
	rel_y = MuPolarRotY(5.4105207 + birth_heading, 0.039);

	sprintf(xsw_object[cw_object].name, "");
	sprintf(xsw_object[cw_object].empire, xsw_object[owner].empire);
	xsw_object[cw_object].owner = owner;
	xsw_object[cw_object].type = XSW_OBJ_TYPE_WEAPON;
	xsw_object[cw_object].imageset = IMAGESET_CODE_WEP_PP_Y;
	xsw_object[cw_object].size = 6;
        xsw_object[cw_object].window_width = 200;
        xsw_object[cw_object].window_height = 150;
	xsw_object[cw_object].heading = birth_heading;
	xsw_object[cw_object].x = birth_x + rel_x;
	xsw_object[cw_object].y = birth_y + rel_y;
	xsw_object[cw_object].z = 0;
        xsw_object[cw_object].velocity_heading = xsw_object[owner].velocity_heading;
	xsw_object[cw_object].velocity = xsw_object[owner].velocity;
	xsw_object[cw_object].velocity_max = 0.07;
	xsw_object[cw_object].thrust_rev_state = 0;
	xsw_object[cw_object].thrust_dir = 3.1415927;
	xsw_object[cw_object].thrust_power = 0.0009;
	xsw_object[cw_object].thrust = xsw_object[owner].thrust;
	xsw_object[cw_object].throttle = 100;
	xsw_object[cw_object].turnrate = 0.0004;
        xsw_object[cw_object].power = power;
	xsw_object[cw_object].birth_time = cur_millitime;
	xsw_object[cw_object].age = 0;
	xsw_object[cw_object].lifespan = 1600;
        xsw_object[cw_object].antimatter = 5;  
        xsw_object[cw_object].antimatter_max = 5;


        /* Object 2 of 2. */
        cw_object = DBCreateObject(200, 150);
        if(cw_object < 0)
                return(-1);
        else
                objects_created++;
        
        /* Get relative position. */
        rel_x = MuPolarRotX(0.87266463 + birth_heading, 0.039);
        rel_y = MuPolarRotY(0.87266463 + birth_heading, 0.039);
        
        sprintf(xsw_object[cw_object].name, "");
        sprintf(xsw_object[cw_object].empire, xsw_object[owner].empire);
        xsw_object[cw_object].owner = owner;
        xsw_object[cw_object].type = XSW_OBJ_TYPE_WEAPON;
        xsw_object[cw_object].imageset = IMAGESET_CODE_WEP_PP_Y;
        xsw_object[cw_object].size = 6;
        xsw_object[cw_object].window_width = 200;
        xsw_object[cw_object].window_height = 150;
        xsw_object[cw_object].heading = birth_heading;
        xsw_object[cw_object].x = birth_x + rel_x;
        xsw_object[cw_object].y = birth_y + rel_y;
        xsw_object[cw_object].z = 0;
        xsw_object[cw_object].velocity_heading = xsw_object[owner].velocity_heading;
        xsw_object[cw_object].velocity = xsw_object[owner].velocity;
        xsw_object[cw_object].velocity_max = 0.07;
        xsw_object[cw_object].thrust_rev_state = 0;
        xsw_object[cw_object].thrust_dir = 3.1415927;
        xsw_object[cw_object].thrust_power = 0.0009;
        xsw_object[cw_object].thrust = xsw_object[owner].thrust;
        xsw_object[cw_object].throttle = 100;
        xsw_object[cw_object].turnrate = 0.0004;
        xsw_object[cw_object].power = power;
        xsw_object[cw_object].birth_time = cur_millitime;
        xsw_object[cw_object].age = 0;
        xsw_object[cw_object].lifespan = 1600;
        xsw_object[cw_object].antimatter = 5;
        xsw_object[cw_object].antimatter_max = 5;



	return(objects_created);
}



/* ************************************************************************
 *
 *                   Disruptor: Double Fire
 *
 */

int WepCreateDisruptor3
(
        long owner,       /* Must not be garbage or error. */
        double birth_x,
        double birth_y,
	double birth_heading,
        double power,
        double range      /* Disgarded for projectile weapons */
)
{
        /* Local variables. */
        double rel_x, rel_y;
        long objects_created = 0;
        long cw_object = 0;             /* Current object being worked on. */
        
 
        /* Owner must be valid. */
        if(owner < 0)
                return(-1);
        
        /* *********************************************** */
        /* ***      Create Weapon Fire Object(s)       *** */
        
        /* Object 1 of 2. */
        cw_object = DBCreateObject(200, 150);
        if(cw_object < 0)
                return(-1);
        else
                objects_created++;
        
        /* Get relative position. */
        rel_x = MuPolarRotX(5.4105207 + birth_heading, 0.039);
        rel_y = MuPolarRotY(5.4105207 + birth_heading, 0.039);
        
        sprintf(xsw_object[cw_object].name, "");
        sprintf(xsw_object[cw_object].empire, xsw_object[owner].empire);
        xsw_object[cw_object].owner = owner;
        xsw_object[cw_object].type = XSW_OBJ_TYPE_WEAPON;
        xsw_object[cw_object].imageset = IMAGESET_CODE_WEP_PP_G;
        xsw_object[cw_object].size = 6;
        xsw_object[cw_object].window_width = 200;
        xsw_object[cw_object].window_height = 150;
        xsw_object[cw_object].heading = birth_heading;
        xsw_object[cw_object].x = birth_x + rel_x;
        xsw_object[cw_object].y = birth_y + rel_y;
        xsw_object[cw_object].z = 0;
        xsw_object[cw_object].velocity_heading = xsw_object[owner].velocity_heading;
        xsw_object[cw_object].velocity = xsw_object[owner].velocity;
        xsw_object[cw_object].velocity_max = 0.07;
        xsw_object[cw_object].thrust_rev_state = 0;
        xsw_object[cw_object].thrust_dir = 3.1415927;
        xsw_object[cw_object].thrust_power = 0.001;
        xsw_object[cw_object].thrust = xsw_object[owner].thrust;
        xsw_object[cw_object].throttle = 100;
        xsw_object[cw_object].turnrate = 0.0004;
        xsw_object[cw_object].power = power;
        xsw_object[cw_object].birth_time = cur_millitime;
        xsw_object[cw_object].age = 0;
        xsw_object[cw_object].lifespan = 1500;
        xsw_object[cw_object].antimatter = 5;  
        xsw_object[cw_object].antimatter_max = 5;
        
        
        /* Object 2 of 2. */
        cw_object = DBCreateObject(200, 150);
        if(cw_object < 0)
                return(-1);
        else
                objects_created++;
        
        /* Get relative position. */
        rel_x = MuPolarRotX(0.87266463 + birth_heading, 0.039);
        rel_y = MuPolarRotY(0.87266463 + birth_heading, 0.039);
 
        sprintf(xsw_object[cw_object].name, "");
        sprintf(xsw_object[cw_object].empire, xsw_object[owner].empire);
        xsw_object[cw_object].owner = owner;
        xsw_object[cw_object].type = XSW_OBJ_TYPE_WEAPON;
        xsw_object[cw_object].imageset = IMAGESET_CODE_WEP_PP_G;
        xsw_object[cw_object].size = 6;
        xsw_object[cw_object].window_width = 200;
        xsw_object[cw_object].window_height = 150;
        xsw_object[cw_object].heading = birth_heading;
        xsw_object[cw_object].x = birth_x + rel_x;
        xsw_object[cw_object].y = birth_y + rel_y;
        xsw_object[cw_object].z = 0;
        xsw_object[cw_object].velocity_heading = xsw_object[owner].velocity_heading;
        xsw_object[cw_object].velocity = xsw_object[owner].velocity;
        xsw_object[cw_object].velocity_max = 0.07;
        xsw_object[cw_object].thrust_rev_state = 0;
        xsw_object[cw_object].thrust_dir = 3.1415927;
        xsw_object[cw_object].thrust_power = 0.001;
        xsw_object[cw_object].thrust = xsw_object[owner].thrust;
        xsw_object[cw_object].throttle = 100;
        xsw_object[cw_object].turnrate = 0.0004;
        xsw_object[cw_object].power = power;
        xsw_object[cw_object].birth_time = cur_millitime;
        xsw_object[cw_object].age = 0;
        xsw_object[cw_object].lifespan = 1500;
        xsw_object[cw_object].antimatter = 5;  
        xsw_object[cw_object].antimatter_max = 5;
 
 
        return(objects_created);
}



/* ************************************************************************  
 *
 *                   Photon Torpedo: Single Fire
 *
 */

int WepCreatePhotonTorp1                
(
        long owner,       /* Must not be garbage or error. */
        double birth_x,
        double birth_y,
        double birth_heading,
        double power,
        double range      /* Disgarded for projectile weapons */
)
{
        /* Local variables. */
        double rel_x, rel_y;
        long objects_created = 0;
        long cw_object = 0;             /* Current object being worked on. */
        
        
        /* Owner must be valid. */
        if(owner < 0)
                return(-1);
        
        /* *********************************************** */
        /* ***      Create Weapon Fire Object(s)       *** */
        
        /* Object 1 of 1. */
        cw_object = DBCreateObject(200, 150);
        if(cw_object < 0)
                return(-1);
        else
                objects_created++;

        /* Get relative position. */
        rel_x = MuPolarRotX(birth_heading, 0.020);
        rel_y = MuPolarRotY(birth_heading, 0.020);
 
        sprintf(xsw_object[cw_object].name, "");
        sprintf(xsw_object[cw_object].empire, xsw_object[owner].empire);
        xsw_object[cw_object].owner = owner;
        xsw_object[cw_object].type = XSW_OBJ_TYPE_WEAPON;
        xsw_object[cw_object].imageset = IMAGESET_CODE_WEP_PT_R;
        xsw_object[cw_object].size = 6;
	xsw_object[cw_object].intercepting_object = xsw_object[owner].locked_on;
        xsw_object[cw_object].window_width = 200;
        xsw_object[cw_object].window_height = 150;
        xsw_object[cw_object].heading = birth_heading;
        xsw_object[cw_object].x = birth_x + rel_x;
        xsw_object[cw_object].y = birth_y + rel_y;
        xsw_object[cw_object].z = 0;
        xsw_object[cw_object].velocity_heading = xsw_object[owner].velocity_heading;
        xsw_object[cw_object].velocity = xsw_object[owner].velocity;
        xsw_object[cw_object].velocity_max = 0.07;
        xsw_object[cw_object].thrust_rev_state = 0;
        xsw_object[cw_object].thrust_dir = 3.1415927;
        xsw_object[cw_object].thrust_power = 0.00075;
        xsw_object[cw_object].thrust = xsw_object[owner].thrust;
        xsw_object[cw_object].throttle = 100;
        xsw_object[cw_object].turnrate = 0.0004;
        xsw_object[cw_object].power = power;
        xsw_object[cw_object].birth_time = cur_millitime;  
        xsw_object[cw_object].age = 0;
        xsw_object[cw_object].lifespan = 8000;
        xsw_object[cw_object].antimatter = 5;
        xsw_object[cw_object].antimatter_max = 5;  

        
        return(objects_created);
}



int WepCreate
(
	long weapon_type,
        long owner,       /* Must not be garbage or error. */   
        double birth_x,
        double birth_y,
        double birth_heading,
        double power,
        double range      /* Disgarded for projectile weapons */
)
{
	/* Local Variables. */
	int objects_created;

	switch(weapon_type)
	{
	   case WEPTYPE_PHAZER_1:
                objects_created = WepCreatePhazer1(
                   owner,
                   birth_x,
                   birth_y,
                   birth_heading,
                   power,
                   range
                );         
                break;

	   case WEPTYPE_DISRUPTOR_3:
                objects_created = WepCreateDisruptor3(
                   owner,
                   birth_x,
                   birth_y,
                   birth_heading,
                   power,
                   range 
                );
                break;

           case WEPTYPE_PULSE_PHAZER_1:
                objects_created = WepCreatePulsePhazer1(
                   owner,
                   birth_x,
                   birth_y,
                   birth_heading,
                   power,
                   range
                );
                break;

           case WEPTYPE_PULSE_PHAZER_2:
                objects_created = WepCreatePulsePhazer2(
                   owner,
                   birth_x,
                   birth_y,
                   birth_heading,
                   power,
                   range
                );
                break;


           case WEPTYPE_PHOTON_TORP_1:
                objects_created = WepCreatePhotonTorp1(
                   owner,
                   birth_x,
                   birth_y,
                   birth_heading,
                   power,
                   range
                );
                break;
        


	   default:
		objects_created = WepCreatePulsePhazer1(
                   owner,
                   birth_x,
                   birth_y,
                   birth_heading,
                   power,
                   range
		);
		break;
	}


	return(objects_created);
}
