#include "../include/swserv.h"



long LogAppendLineFormatted(char *filename, char *str)
{
	/* Local variables. */
        FILE *fp;
        off_t filesize;
        struct stat statbuf;
	char writebuf[1024];

	long bytes_written = 0;


        /* Open or create file for appending. */
        fp = fopen(filename, "a");
        if(fp == NULL)
        {
            fprintf(stderr,
		"Warning: Unable to open or create log file: \"%s\"\n",
                filename
            );
            return(-1);
        }


	/* Format writebuf. */
	sprintf(writebuf, "%s: %s\n",
	     StringCurrentTimeFormat("%m/%d/%y %H:%M:%S"),
	     str
	);


	/* Append the line. */
        bytes_written += fwrite(writebuf, sizeof(char), strlen(writebuf),fp);

	/* Close the file. */
	fclose(fp);


	/* Return the number of bytes written. */
	return(bytes_written);
}
