/* ************************************************************************
 *
 *	execset.c	Set Function for Remote Execution
 *	-------------------------------------------------
 *	Functions:
 *
 *	int ExecDoSet(long condescriptor, char *arg)
 *
 *	---
 *
 *	ExecDoSet() is a long function, so its being put in its own file.
 *
 *
 */

#include "../include/swserv.h"



int ExecDoSet(long condescriptor, char *arg)
{
        /* Local variables. */
	long x;
	char stringa[MAX_NET_CMD_SIZE];
        char stringb[MAX_NET_CMD_SIZE];
        char stringc[MAX_NET_CMD_SIZE];
        char stringd[MAX_NET_CMD_SIZE];
	char sndbuf[MAX_NET_CMD_SIZE];
	char prop[MAX_NET_CMD_SIZE];
	char val[MAX_NET_CMD_SIZE];
	long object_num;
	char *strptr;


	/* Copy arg to stringa. */
	strncpy(stringa, arg, MAX_NET_CMD_SIZE);
	stringa[MAX_NET_CMD_SIZE - 1] = '\0';


        /* Print usage? */
        if( (strlen(stringa) < 1) ||
	    ((strchr(stringa, '=')) == NULL) ||
	    ((strchr(stringa, ':')) == NULL)
	)
	{
            sprintf(sndbuf, "%i set: Usage: `set <object>=<property>:<value>'\n%c",
                NET_CMD_GLOBALMESG, '\0');
            NetSendDataToConnection(condescriptor, sndbuf, 1);
	    return(-1);
	}


	/* Begin parsing. */
	strptr = strchr(stringa, '=');
	strncpy(stringc, (strptr + 1), MAX_NET_CMD_SIZE);

	*strptr = '\0';
	strncpy(stringb, stringa, MAX_NET_CMD_SIZE);

	strncpy(stringa, stringc, MAX_NET_CMD_SIZE);
	strptr = strchr(stringa, ':');

	strncpy(stringd, (strptr + 1), MAX_NET_CMD_SIZE);
	
	*strptr = '\0';
	strncpy(stringc, stringa, MAX_NET_CMD_SIZE);


	strncpy(val, StringStripSpaces(stringd), MAX_NET_CMD_SIZE);
	strncpy(prop, StringStripSpaces(stringc), MAX_NET_CMD_SIZE);
	object_num = MatchObjectByName(StringStripSpaces(stringb), -1);


	/* Make sure object_num is valid. */
	if( (object_num < 0) || (object_num >= MAX_OBJECTS) )
	{
            sprintf(sndbuf, "%i set: Invalid object %i.\n%c",
                NET_CMD_GLOBALMESG, object_num, '\0');
            NetSendDataToConnection(condescriptor, sndbuf, 1);
            return(-1);
	}


	/* Permission checks for setting other objects that you */
	/* do not own.                                          */
	if(xsw_object[object_num].owner !=
		 connection[condescriptor].object_num)
	{
	    /* Allowed to set other objects? */
	    if(ACCESS_UID_SET_OTHER < 
    xsw_object[connection[condescriptor].object_num].permission.uid
	    )
	    {
                sprintf(sndbuf,
    "%i set: Access level %i: Permission denied: You do not own that.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET_OTHER,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
	    }
	    /* Is the other objects's UID greater than ours? */
	    else if( xsw_object[object_num].permission.uid <
                 xsw_object[connection[condescriptor].object_num].permission.uid
	    )
	    {
                sprintf(sndbuf,
    "%i set: Access level %i: Permission denied: %s(#%i) UID higher than yours.\n%c",
                    NET_CMD_GLOBALMESG,
		    xsw_object[object_num].permission.uid,
                    xsw_object[object_num].name,
		    object_num,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
	    }
	}



	/* **************************************************** */
	/*                      Handle Set                      */

	/* Name. */
        if(0 == strcmp(prop, "name"))
        {
            /* Check if object's permission allows set. */
	    if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
		ACCESS_UID_SET
	    )
	    {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
	    }

	    /* Set name. */
	    strncpy(xsw_object[object_num].name, val, MAX_NAME_LENGTH);
	    xsw_object[object_num].name[MAX_NAME_LENGTH - 1] = '\0';

            /* Validility check. */



	    /* Send name update to all connections. */
	    for(x = 0; x < total_connections; x++)
	    {
		if(connection[x].socket < 0)
		    continue;
		if(connection[x].object_num < 0)
		    continue;

		NetSendSetName(x, object_num);
	    }

        }
	/* Password. */
        else if(0 == strcmp(prop, "password"))
        {
            /* Check if object's permission allows password change. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SETPASS
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SETPASS,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set password. */
            strncpy(xsw_object[object_num].password, val, MAX_PASSWORD_LENGTH);
            xsw_object[object_num].password[MAX_PASSWORD_LENGTH - 1] = '\0';

            /* Validility check. */

        }
        /* Empire. */
        else if(0 == strcmp(prop, "empire"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )  
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);  
                return(-1);
            }

	    /* Set empire. */
            strncpy(xsw_object[object_num].empire, val, MAX_EMPIRE_LENGTH);
            xsw_object[object_num].empire[MAX_EMPIRE_LENGTH - 1] = '\0';

            /* Validility check. */

        }
        /* Type. */
        else if(0 == strcmp(prop, "type"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }   

	    /* Set type. */
            xsw_object[object_num].type = atol(val);

            /* Validility check. */
            if(xsw_object[object_num].type < XSW_OBJ_TYPE_STATIC)
                xsw_object[object_num].type = XSW_OBJ_TYPE_STATIC;
        }
        /* Imageset. */
        else if(0 == strcmp(prop, "imageset"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

	    /* Set imageset. */
            xsw_object[object_num].imageset = atol(val);

	    /* Validility check. */
            if(xsw_object[object_num].imageset < 0)
                xsw_object[object_num].imageset = 0;
        }
        /* Owner. */
        else if(0 == strcmp(prop, "owner"))
        {
	    /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {     
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }


	    /* Set owner. */
            xsw_object[object_num].owner = atol(val);

            /* Validility check. */
            if(xsw_object[object_num].owner < 0)   
                xsw_object[object_num].owner = 0;
	    else if(xsw_object[object_num].owner >= MAX_OBJECTS)
		xsw_object[object_num].owner = 0;

	    /* Players always own themselves. */
	    if(xsw_object[object_num].type == XSW_OBJ_TYPE_PLAYER)
		xsw_object[object_num].owner = object_num;
        }
        /* Size. */
        else if(0 == strcmp(prop, "size"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }


            /* Set size, in XSW Screen (Pixels) units. */
            xsw_object[object_num].size = atol(val);

            /* Validility check. */
            if(xsw_object[object_num].size < 0)
                xsw_object[object_num].size = 0;        
	} 

        /* Locked on. */
        else if(0 == strcmp(prop, "locked_on"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }


            /* Set locked_on. */
            xsw_object[object_num].locked_on = atol(val);

            /* Validility check. */
            if(xsw_object[object_num].locked_on < -1)
                xsw_object[object_num].locked_on = -1;
	    else if(xsw_object[object_num].locked_on >= MAX_OBJECTS)
		xsw_object[object_num].locked_on = -1;
        }

        /* Intercepting object. */
        else if(0 == strcmp(prop, "intercepting_object"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }


            /* Set intercepting_object. */
            xsw_object[object_num].intercepting_object = atol(val);

            /* Validility check. */
            if(xsw_object[object_num].intercepting_object < -1) 
                xsw_object[object_num].intercepting_object = -1;
            else if(xsw_object[object_num].intercepting_object >= MAX_OBJECTS)
                xsw_object[object_num].intercepting_object = -1;
        }


        /* Scanner range. */
        else if(0 == strcmp(prop, "scanner_range"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);   
                return(-1);
            }


            /* Set scanner_range. */
            xsw_object[object_num].scanner_range = atof(val);

            /* Validility check. */
            if(xsw_object[object_num].scanner_range < 1) 
                xsw_object[object_num].scanner_range = 1;
        }

        /* x. */
        else if(0 == strcmp(prop, "x"))
        {
            /* Check if object's permission allows set. */   
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
                
            
            /* Set x. */
            xsw_object[object_num].x = atof(val);
        }

        /* y. */
        else if(0 == strcmp(prop, "y"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
    
                  
            /* Set y. */
            xsw_object[object_num].y = atof(val);
        }

        /* z. */
        else if(0 == strcmp(prop, "z"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
    
                  
            /* Set z. */
            xsw_object[object_num].z = atof(val);
        }             

	/* Heading. */
        else if(0 == strcmp(prop, "heading"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }   


            /* Set heading. */
            xsw_object[object_num].heading = atof(val);

	    /* Sanitize heading. */
	    while(xsw_object[object_num].heading < 0)
		xsw_object[object_num].heading += 6.2831853;
            while(xsw_object[object_num].heading >= 6.2831853)
                xsw_object[object_num].heading -= 6.2831853;
        }

        /* Pitch. */
        else if(0 == strcmp(prop, "pitch"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

        
            /* Set pitch. */
            xsw_object[object_num].pitch = atof(val);
            
            /* Sanitize pitch. */
            while(xsw_object[object_num].pitch < 0)
                xsw_object[object_num].pitch += 6.2831853;

            while(xsw_object[object_num].pitch >= 6.2831853)
                xsw_object[object_num].pitch -= 6.2831853;
        }

        /* Velocity. */
        else if(0 == strcmp(prop, "velocity"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
                
            
            /* Set velocity. */
            xsw_object[object_num].velocity = atof(val);
        
            /* Sanitize velocity. */
	    if(xsw_object[object_num].velocity < 0)
		xsw_object[object_num].velocity = 0;
        }

        /* Velocity maximum. */
        else if(0 == strcmp(prop, "velocity_max"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
         
         
            /* Set velocity_max. */
            xsw_object[object_num].velocity_max = atof(val);

            /* Sanitize velocity_max. */
            if(xsw_object[object_num].velocity_max < 0)
                xsw_object[object_num].velocity_max = 0;
        }

        /* Velocity heading. */
        else if(0 == strcmp(prop, "velocity_heading"))
        {           
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
               
            /* Set velocity_heading. */
            xsw_object[object_num].velocity_heading = atof(val);

            /* Sanitize velocity_heading. */
            while(xsw_object[object_num].velocity_heading < 0)
                xsw_object[object_num].velocity_heading += 6.2831853;
            while(xsw_object[object_num].velocity_heading >= 6.2831853)
                xsw_object[object_num].velocity_heading -= 6.2831853;
        }

        /* Thrust reverse state. */
        else if(0 == strcmp(prop, "thrust_rev_state"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )       
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }   


            /* Set thrust_rev_state. */
            xsw_object[object_num].thrust_rev_state = atoi(val);

	    /* Sanitize thrust_rev_state. */
	    if( (xsw_object[object_num].thrust_rev_state != 1) &&
	        (xsw_object[object_num].thrust_rev_state != 0)
	    )
	    {
		xsw_object[object_num].thrust_rev_state = 0;
	    }
        }

        /* Thrust direction. */
        else if(0 == strcmp(prop, "thrust_dir"))
        {
            /* Check if object's permission allows set. */
            if(   
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {  
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }


            /* Set thrust_dir. */
            xsw_object[object_num].thrust_dir = atof(val);

            /* Sanitize thrust_dir. */
            while(xsw_object[object_num].thrust_dir < 0)
                xsw_object[object_num].thrust_dir += 6.2831853; 
            while(xsw_object[object_num].thrust_dir >= 6.2831853)
                xsw_object[object_num].thrust_dir -= 6.2831853;
        }

        /* Thrust. */
        else if(0 == strcmp(prop, "thrust"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {       
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set thrust. */
            xsw_object[object_num].thrust = atof(val);

            /* Sanitize thrust. */
            if(xsw_object[object_num].thrust < 0)
		xsw_object[object_num].thrust = 0;
	}

        /* Thrust power. */
        else if(0 == strcmp(prop, "thrust_power"))
        {         
            /* Check if object's permission allows set. */
            if( 
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
        
            /* Set thrust_power. */
            xsw_object[object_num].thrust_power = atof(val);
            
            /* Sanitize thrust_power. */
            if(xsw_object[object_num].thrust_power < 0)
                xsw_object[object_num].thrust_power = 0;
        }

        /* Throttle. */
        else if(0 == strcmp(prop, "throttle"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )     
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );  
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set throttle. */
            xsw_object[object_num].throttle = atoi(val);

            /* Sanitize throttle. */
            if(xsw_object[object_num].throttle < 0)
                xsw_object[object_num].throttle = 0;
        }

        /* Turn rate. */
        else if(0 == strcmp(prop, "turnrate"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid > 
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set turnrate. */
            xsw_object[object_num].turnrate = atof(val);
        
            /* Sanitize turnrate. */
            if(xsw_object[object_num].turnrate < 0) 
                xsw_object[object_num].turnrate = 0;
        }

        /* Hit points. */
        else if(0 == strcmp(prop, "hp"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid > 
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set hp. */
            xsw_object[object_num].hp = atof(val);

            /* Sanitize hp. */
            if(xsw_object[object_num].hp < 0)
                xsw_object[object_num].hp = 0;
            if(xsw_object[object_num].hp > xsw_object[object_num].hp_max)
                xsw_object[object_num].hp = xsw_object[object_num].hp_max;
        }

        /* Hit points maximum. */
        else if(0 == strcmp(prop, "hp_max"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set hp_max. */
            xsw_object[object_num].hp_max = atof(val);

            /* Sanitize hp_max. */
            if(xsw_object[object_num].hp_max < 0)
                xsw_object[object_num].hp_max = 0;
        }

        /* Power. */
        else if(0 == strcmp(prop, "power"))
        {         
            /* Check if object's permission allows set. */
            if( 
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set power. */
            xsw_object[object_num].power = atof(val);
        
            /* Sanitize power. */
            if(xsw_object[object_num].power < 0)
                xsw_object[object_num].power = 0;
            if(xsw_object[object_num].power > xsw_object[object_num].power_max)
                xsw_object[object_num].power = xsw_object[object_num].power_max;
        }

        /* Power maximum. */
        else if(0 == strcmp(prop, "power_max"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid > 
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set power_max. */
            xsw_object[object_num].power_max = atof(val);

            /* Sanitize power_max. */
            if(xsw_object[object_num].power_max < 0)
                xsw_object[object_num].power_max = 0;
        }

        /* Power purity. */
        else if(0 == strcmp(prop, "power_purity"))
        {
            /* Check if object's permission allows set. */
            if(   
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
                    
            /* Set power_purity. */
            xsw_object[object_num].power_purity = atof(val);

            /* Sanitize power_purity into range 0.00 to 0.99. */
            if(xsw_object[object_num].power_purity < 0)
                xsw_object[object_num].power_purity = 0;
            if(xsw_object[object_num].power_purity > 0.99) 
                xsw_object[object_num].power_purity = 0.99;
        }

        /* Core efficency. */
        else if(0 == strcmp(prop, "core_efficency"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid > 
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set core_efficency. */
            xsw_object[object_num].core_efficency = atof(val);
            
            /* Sanitize core_efficency. */
            if(xsw_object[object_num].core_efficency < 0) 
                xsw_object[object_num].core_efficency = 0;
        }

        /* Antimatter. */
        else if(0 == strcmp(prop, "antimatter"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
         
            /* Set antimatter. */
            xsw_object[object_num].antimatter = atof(val);
        
            /* Sanitize antimatter. */
            if(xsw_object[object_num].antimatter < 0) 
                xsw_object[object_num].antimatter = 0;
            if(xsw_object[object_num].antimatter > xsw_object[object_num].antimatter_max)
                xsw_object[object_num].antimatter = xsw_object[object_num].antimatter_max;
        }

        /* Antimatter maximum. */
        else if(0 == strcmp(prop, "antimatter_max"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid > 
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
		    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
            
            /* Set antimatter_max. */
            xsw_object[object_num].antimatter_max = atof(val);
               
            /* Sanitize antimatter_max. */
            if(xsw_object[object_num].antimatter_max < 0)
                xsw_object[object_num].antimatter_max = 0;
        }

	/* Shield state. */
        else if(0 == strcmp(prop, "shield_state"))
        {
            /* Check if object's permission allows set. */
            if( 
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )       
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
         
            /* Set shield_state. */
            xsw_object[object_num].shield_state = atoi(val);

            /* Sanitize shield_state. */
	    if( (xsw_object[object_num].shield_state != 0) &&
		(xsw_object[object_num].shield_state != 1) &&
		(xsw_object[object_num].shield_state != -1)
	    )
	    {
                xsw_object[object_num].shield_state = 0;
	    }
        }    

        /* Shield frequency. */ 
        else if(0 == strcmp(prop, "shield_frequency"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }  

            /* Set shield_frequency. */
            xsw_object[object_num].shield_frequency = atof(val);
        
            /* Sanitize shield_frequency. */
            if(xsw_object[object_num].shield_frequency < 0)
                xsw_object[object_num].shield_frequency = 0;
        }    

        /* Selected weapon. */
        else if(0 == strcmp(prop, "selected_weapon"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )      
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set selected_weapon. */
            xsw_object[object_num].selected_weapon = atoi(val);

            /* Sanitize selected_weapon. */
            if(xsw_object[object_num].selected_weapon >=
		xsw_object[object_num].total_weapons
	    )
                xsw_object[object_num].selected_weapon = 0;
        }

        /* Total weapons. */
        else if(0 == strcmp(prop, "total_weapons"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
            
            /* Set total_weapons. */
            xsw_object[object_num].total_weapons = atoi(val);

            /* Sanitize total_weapons. */
            if(xsw_object[object_num].total_weapons > MAX_WEAPONS)
                xsw_object[object_num].total_weapons = MAX_WEAPONS;
        }

        /* Birth time. */
        else if(0 == strcmp(prop, "birth_time"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);   
                return(-1);
            }

            /* Set birth_time. */
            xsw_object[object_num].birth_time = atol(val);

            /* Sanitize birth_time. */
            if(xsw_object[object_num].birth_time < 0)
                xsw_object[object_num].birth_time = 0;
        }

        /* Age. */
        else if(0 == strcmp(prop, "age"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }  

            /* Set age. */
            xsw_object[object_num].age = atol(val);
        
            /* Sanitize age. */
            if(xsw_object[object_num].age < 0) 
                xsw_object[object_num].age = 0;
        }   

        /* Life span. */
        else if(0 == strcmp(prop, "lifespan"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )       
            {     
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set lifespan. */
            xsw_object[object_num].lifespan = atol(val);

            /* Sanitize lifespan. */
            if(xsw_object[object_num].lifespan < -1)
                xsw_object[object_num].lifespan = -1;
        }

        /* Cloak state. */
        else if(0 == strcmp(prop, "cloak_state"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'  
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set cloak_state. */
            xsw_object[object_num].lifespan = atoi(val);

            /* Sanitize cloak_state. */
            if( (xsw_object[object_num].cloak_state != -1) &&
		(xsw_object[object_num].cloak_state != 0) &&
		(xsw_object[object_num].cloak_state != 1)
	    )
                xsw_object[object_num].cloak_state = -1;
        }

        /* Cloak strength. */
        else if(0 == strcmp(prop, "cloak_strength"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set cloak_strength. */
            xsw_object[object_num].cloak_strength = atof(val);
            
            /* Sanitize cloak_strength. */
            if(xsw_object[object_num].cloak_strength < 0)
                xsw_object[object_num].cloak_strength = 0;
	    else if(xsw_object[object_num].cloak_strength > 1)
		xsw_object[object_num].cloak_strength = 1;
        }

        /* Visibility. */
        else if(0 == strcmp(prop, "visibility"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set visibility. */
            xsw_object[object_num].visibility = atof(val);

            /* Sanitize visibility. */
            if(xsw_object[object_num].visibility < 0)
                xsw_object[object_num].visibility = 0;
            else if(xsw_object[object_num].visibility > 1) 
                xsw_object[object_num].visibility = 1;
	}

        /* Shield visibility. */
        else if(0 == strcmp(prop, "shield_visibility"))
        {           
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )   
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
    
            /* Set shield_visibility. */
            xsw_object[object_num].shield_visibility = atof(val);

            /* Sanitize shield_visibility. */
            if(xsw_object[object_num].shield_visibility < 0) 
                xsw_object[object_num].shield_visibility = 0;
            else if(xsw_object[object_num].shield_visibility > 1)
                xsw_object[object_num].shield_visibility = 1;
        }

        /* Damage control. */
        else if(0 == strcmp(prop, "damage_control"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set damage_control. */
            xsw_object[object_num].damage_control = atoi(val);
        
            /* Sanitize damage_control. */
            if( (xsw_object[object_num].damage_control != 0) &&
		(xsw_object[object_num].damage_control != 1)
	    )
	    {
                xsw_object[object_num].damage_control = 0;
	    }
	}

	/* ************************************************************* */
	/* ***                       Score                           *** */
        /* GPL. */
        else if(0 == strcmp(prop, "score.gpl"))
        {   
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
        
            /* Set score.gpl. */
            xsw_object[object_num].score.gpl = atof(val);

            /* Sanitize score.gpl. */
            if(xsw_object[object_num].score.gpl < 0)
                xsw_object[object_num].score.gpl = 0;
        }

        /* RMU. */
        else if(0 == strcmp(prop, "score.rmu"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
         
            /* Set score.rmu. */
            xsw_object[object_num].score.rmu = atof(val);
         
            /* Sanitize score.rmu. */
            if(xsw_object[object_num].score.rmu < 0)
                xsw_object[object_num].score.rmu = 0;
        }

        /* RMU Maximum. */
        else if(0 == strcmp(prop, "score.rmu_max"))
        {   
            /* Check if object's permission allows set. */
            if( 
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set score.rmu_max. */
            xsw_object[object_num].score.rmu_max = atof(val);

            /* Sanitize score.rmu_max. */
            if(xsw_object[object_num].score.rmu_max < 0)
                xsw_object[object_num].score.rmu_max = 0;
        }

        /* Damage givin. */
        else if(0 == strcmp(prop, "score.damage_givin"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
        
            /* Set score.damage_givin. */
            xsw_object[object_num].score.damage_givin = atof(val);
        
            /* Sanitize score.damage_givin. */
            if(xsw_object[object_num].score.damage_givin < 0) 
                xsw_object[object_num].score.damage_givin = 0;
        }

        /* Damage recieved. */
        else if(0 == strcmp(prop, "score.damage_recieved"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
         
            /* Set score.damage_recieved. */
            xsw_object[object_num].score.damage_recieved = atof(val);

            /* Sanitize score.damage_recieved. */
            if(xsw_object[object_num].score.damage_recieved < 0)
                xsw_object[object_num].score.damage_recieved = 0;
        }

        /* Kills. */
        else if(0 == strcmp(prop, "score.kills"))
        {       
            /* Check if object's permission allows set. */
            if(     
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )   
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }
        
            /* Set score.kills. */
            xsw_object[object_num].score.kills = atol(val);
        
            /* Sanitize score.kills. */
            if(xsw_object[object_num].score.kills < 0)
                xsw_object[object_num].score.kills = 0;
        }

	/* ******************************************************* */
	/* ***                   Permissions                   *** */

        /* UID. */
        else if(0 == strcmp(prop, "permission.uid"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )     
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

	    /* Cannot set UID permissions on yourself. */
            if(connection[condescriptor].object_num == object_num)
            {
                sprintf(sndbuf,
                    "%i set: Cannot set UID permissions on yourself.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

	    /* Check if permission is equal or lower than yours. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
		atoi(val)
	    )
	    {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    atoi(val),
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
	    }

            /* Set permission.uid. */
            xsw_object[object_num].permission.uid = atoi(val);

            /* Sanitize permission.uid. */
            if(xsw_object[object_num].permission.uid < 0)
                xsw_object[object_num].permission.uid = 0;
        }

        /* GID. */
        else if(0 == strcmp(prop, "permission.gid"))
        {
            /* Check if object's permission allows set. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                ACCESS_UID_SET
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    ACCESS_UID_SET,
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Check if permission is equal or lower than yours. */
            if(
    xsw_object[connection[condescriptor].object_num].permission.uid >
                atoi(val)
            )
            {
                sprintf(sndbuf,
                    "%i set: Access level %i: Permission denied.\n%c",
                    NET_CMD_GLOBALMESG,
                    atoi(val),     
                    '\0'
                );
                NetSendDataToConnection(condescriptor, sndbuf, 1);
                return(-1);
            }

            /* Set permission.gid. */
            xsw_object[object_num].permission.gid = atoi(val);

            /* Sanitize permission.gid. */
            if(xsw_object[object_num].permission.gid < 0)
                xsw_object[object_num].permission.gid = 0;
        }         










	/* Unknown property. */
	else
	{
            sprintf(sndbuf, "%i set: Unsupported property: `%s'\n%c",
                NET_CMD_GLOBALMESG, prop, '\0');
            NetSendDataToConnection(condescriptor, sndbuf, 1);
	    return(-1);
	}



	/* Print set response to connection. */
        sprintf(sndbuf, "%i set: %s(#%i): Property `%s' to value `%s'.\n%c",
            NET_CMD_GLOBALMESG,
            xsw_object[object_num].name,
            object_num,
            prop,
            val,
            '\0'
        );
        NetSendDataToConnection(condescriptor, sndbuf, 1);


        /* Log property setting. */
        sprintf(stringa, "%s(#%i): Set %s(#%i): Property: `%s'  Value: `%s'",
                xsw_object[connection[condescriptor].object_num].name,
                connection[condescriptor].object_num,
		xsw_object[object_num].name,
		object_num,
                prop,
                val
        );
        LogAppendLineFormatted(primary_log_fullname, stringa);


fprintf(stderr, "%s(#%i): Set %s(#%i): Property: `%s'  Value: `%s'\n",
 xsw_object[connection[condescriptor].object_num].name,
 connection[condescriptor].object_num,
 xsw_object[object_num].name,
 object_num,
 prop,   
 val
);      


	return(0);
}
