/* ****************************************************************************
 *
 *	messagewin.c	Functions to Handle the Message Window
 *	------------------------------------------------------
 *	Functions:
 *
 *	int MesgWinAddMessage(char *new_mesg, unsigned long mesg_color)
 *	int MesgWinReplaceMessage(char *new_mesg,
 *		unsigned long mesg_color, long mesg_num)
 *	int DrawMessageWin()
 *
 *	---
 *
 *	MesgWinAddMessage() adds a new message line to the message_win,
 *	with the color of mesg_color.
 *	Returns non-zero on error.
 *
 *	MesgWinReplaceMessage() replaces mesg_num line on message_win
 *	with new message new_mesg and color mesg_color.   Does not shift the
 *	messages. mesg_num must be a number between 0 and
 *	MESSAGE_WIN_TOTAL_MESSAGES.
 *	Returns non-zero on error; if mesg_num is out of range, nothing will
 *	be done and -1 will be returned.
 *
 *	DrawMessageWin() redraws the message_win.
 *	Returns non-zero on error.
 *
 */


#include "../include/xsw.h"  



int MesgWinAddMessage(char *new_mesg, unsigned long mesg_color)
{
	/* Local variables. */
        long x;


        /* Note: Message lines are numbered from bottom to top, */
        /* Message 0 would be the bottom most line.             */
 
        /* Shift messages 'up' */
        for(x = MESSAGE_WIN_TOTAL_MESSAGES - 1; x > 0; x--)
        {
                sprintf(message_win_message[x].message,
                        message_win_message[x - 1].message
                );
                message_win_message[x].pixel =
                        message_win_message[x - 1].pixel;
        }
  
        /* Assign line 0 to contain new_mesg. */
        message_win_message[0].pixel = mesg_color;
        sprintf(message_win_message[0].message, new_mesg);
        
        /* Redraw the message_win. */  
        DrawMessageWin();
           
        
        return(0);
}        



int MesgWinReplaceMessage(char *new_mesg, unsigned long mesg_color,
	long mesg_num)
{
	/* Local variables. */
        long x;


        /* Note: Message lines are numbered from bottom to top, */
  	/* Message 0 would be the bottom most line.             */


	/* Make sure mesg_num is within range. */
	if( (mesg_num < 0) || ( mesg_num >= MESSAGE_WIN_TOTAL_MESSAGES) )
		return(-1);


	/* Set the new message and color. */
	sprintf(message_win_message[mesg_num].message, new_mesg);
	message_win_message[mesg_num].pixel = mesg_color;

        /* Redraw the message_win. */
        DrawMessageWin();


        return(0);
}



int DrawMessageWin()
{
        /* Local variables. */
        long x;         /* Line counter. */
        char stringa[512];
        int lines_drawn;
        int line_x = 8;
        int line_y = 50;
        
        
        /* Clear the window. */
        XClearWindow(display, message_win);
        
	/* Get global variable message_win_curline. */
	if(message_win_curline < 0)
		message_win_curline = 0;
	else if(message_win_curline >= MESSAGE_WIN_TOTAL_MESSAGES)
		message_win_curline = MESSAGE_WIN_TOTAL_MESSAGES - 1;
        x = message_win_curline;


        /* Redraw the lines. */
        lines_drawn = 0;
        while(lines_drawn < 3)
        {
           if(x >= MESSAGE_WIN_TOTAL_MESSAGES)
              break;  
 
           XSetForeground(display, the_GC, message_win_message[x].pixel);
           sprintf(stringa, message_win_message[x].message);
           XDrawString(display, message_win, the_GC,
                line_x,line_y,stringa,strlen(stringa));
           line_y -= 17;  
           x++;
           lines_drawn++;
        }
          
        return(lines_drawn);
}
