/* example of how to use the 32bpp display routines
   2/12/98 PQP, pascal@acm.org

   notes:
	this has a VERY simple event-handling loop.  it'll just check to
	see if the mouse button has been clicked inside the window, and
	if so, quit.  basically it's just to show you how to grab the
	display and window params off of the Graph structure.

	the library itself is really nasty.  it's probably a good idea if
	you didn't mess with it, except to remove the (somewhat 
	interesting) debug messages, and even then you should only comment
	the various [f]printf()s out.  just take the following for
	granted:

	- you allocate the image buffer separately... allocate it like:
		int *scr = (int *)malloc(width*height*sizeof(int));
	- the window's disp, win, vis, gc, and scr params are all
	  g->xg->(whatever)
	- you won't have to even bother with anything else, in theory

	hopefully i'll have gotten around to rewriting this in C++ soon.
	anyway, to write a color to the image buffer, it's pretty simple,
	just:

		g->xg->im[pos] = PACKxx(r, g, b);

	where pos is the position in the buffer, given by y*width + x, and
	PACKxx is replaced with one of PACK8, PACK16, or PACK24, depending
	on whether your individual r, g and b are 8, 16 or 24 bit.
	chances are you'll use PACK8 most of the time (i.e. your r/g/b
	values will be from 0..255)

	anyway, then to update a window "g" with a buffer "scr" it's just

		BlitBuffer (g, scr);

	i.e. see the code for more details :)
*/

#include <math.h>
#include "graph32.h"

#ifndef PI
# define PI 3.1415926535897932384626433
#endif

#define XRES	320
#define YRES	200

volatile int quit = 0;	// Has the user clicked the mouse button yet?
int stab[1024];	// Sine lookup table
char txt[65536];	// a texture

void HandleEvents(Graph *window)
{
	Display *disp = window->xg->disp;
	Window win = window->xg->win;
	XEvent EventReport;

	while (XQLength(disp))
	{
		XNextEvent (disp, &EventReport);

		switch (EventReport.type)
		{
		case ButtonPress:
			quit = 1;
		}
	}
}

/* note: i seriously doubt you'll manage to understand this code.  just
   enjoy the ride. :) */
void DoEffect (int *scr, int f)
{
	int *s = scr;
	unsigned char *t = txt;
	int i, j;
	int x, y;
	int r, g, b;
	int xr, xg, xb, yr, yg, yb;
	int xr0, xg0, xb0, yr0, yg0, yb0;
	int dxr, dxg, dxb, dyr, dyg, dyb;

	for (y = 0; y < 256; y++)
		for (x = 0; x < 256; x++)
		{
			r = stab[(f*5 + x*4)&1023] + stab[(f*6 +
			    x*8)&1023];
			g = stab[(-f*4 - y*8)&1023] + stab[(y*4)&1023];
			b = stab[(f*7 + x*4)&1023] + stab[(f*3 +
			    y*4)&1023];

			*t++ = (r + g + g + b)>>3;
		}

	xr0 = stab[(f*5)&1023]<<16;
	xg0 = stab[(f*6)&1023]<<16;
	xb0 = stab[(f*7)&1023]<<16;

	yr0 = stab[(f*2)&1023]<<16;
	yg0 = stab[(f*3)&1023]<<16;
	yb0 = stab[(f*4)&1023]<<16;

	dxr = stab[(f*10)&1023]<<8;
	dyr = stab[(f*-11)&1023]<<8;

	dxg = stab[(f*-12)&1023]<<8;
	dyg = stab[(f*13)&1023]<<8;

	dxb = stab[(f*14)&1023]<<8;
	dyb = stab[(f*10)&1023]<<8;

	for (j = 0; j < YRES; j++)
	{
		xr = xr0;
		xg = xg0;
		xb = xb0;

		yr = yr0;
		yg = yg0;
		yb = yb0;

		xr0 += dxr;
		xg0 += dxg;
		xb0 += dxb;

		yr0 += dyr;
		yg0 += dyg;
		yb0 += dyb;

		for (i = 0; i < XRES; i++)
		{
			r = txt[(((yr>>8)&65280) + (xr>>16))&65535];
			g = txt[(((yg>>8)&65280) + (xg>>16))&65535];
			b = txt[(((yb>>8)&65280) + (xb>>16))&65535];

			*s++ = ((*s>>2)&0x3F3F3F) + PACK8(r, g, b);

			yr -= dxr;
			xr += dyr;

			yg -= dxg;
			xg += dyg;

			yb -= dxb;
			xb += dyb;
		}
	}
}

void main(int argc, char *argv[])
{
	Graph *g;	// our custom window structure
	int *scr;	// image buffer to use
	int i;

	/* Initialize a window at XRESxYRES.  Note that I never got
	   around to implementing the window title */
	g = SetupGraphics(argc, argv, XRES, YRES, "32bpp Test");
	scr = (int *)malloc(XRES*YRES*sizeof(int));

	// Setup the sine table
	for (i = 0; i < 1024; i++)
		stab[i] = (int)(127.5 + 127.5*sin(i*PI/512));

	// Main execution loop
	i = 0;	// frame counter
	while (!quit)
	{
		DoEffect (scr, i++);

		BlitBuffer (g, scr);
		HandleEvents (g);
	}

	/* Haven't gotten around to writing a ShutdownGraphics() yet,
	   just assume X will play nice */
}
