/* messages.hh 1.13 95/12/28 23:24:14 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// ------------------ INTERNATIONALIZATION ------------------
//
// For persons wanting to translate xspacewarp into a different language,
// messages.hh and orientation.hh contain all the text used in xspacewarp.


#ifndef _MESSAGES_
#define _MESSAGES_

// messages.hh: essentially, all the text used in xspacewarp other than the
// orientation.


// The next four strings are referenced in draw_intro.cc and are used to make
// the introductory message for xspacewarp.

static const char intro_title_str[] =
"XSPACEWARP 1.2";

static const char intro_originator_str[] =
"ORIGINAL TRS-80 PROGRAM BY JOSHUA LAVINSKY (1977)";

static const char intro_port_str[] =
"PORTED TO X11 BY GREG WALKER (12/22/95)";

static const char intro_skill_str[] =
"ENTER DIFFICULTY LEVEL (1-10): ";



// The next six strings are referenced in draw_mission.cc and are used to
// announce the Endever mission.

static const char mission_header_str[] =
"YOUR MISSION:";

// The next four strings are used to form a statement like this:
//
//  DESTROY ALL 24 JOVIAN SHIPS BEFORE
// THEY DESTROY THE 17 FEDERATION BASES.
//
// Note that the first two strings form the first line of the statement and
// the next two strings form the second line.

static const char mission_statement_1[] =
"DESTROY ALL ";

static const char mission_statement_2[] =
" JOVIAN SHIPS BEFORE";

static const char mission_statement_3[] =
"THEY DESTROY THE ";

static const char mission_statement_4[] =
" FEDERATION BASES.";

static const char mission_start_str[] =
"(SPACEBAR) START GAME, (O) ORIENTATION";



// The next seven strings are referenced in draw_summary.cc and are used
// for summarizing the status of the game and Endever energy levels.

static const char summary_ion_str[] =
"ION THRUSTERS";

static const char summary_warp_str[] =
"WARP DRIVE";

static const char summary_faser_str[] =
"FASERS";

static const char summary_torpedo_str[] =
"PHOTON TORPEDOES";

static const char summary_shield_str[] =
"SHIELDS";

static const char summary_jovian_str[] =
"JOVIANS REMAINING";

static const char summary_base_str[] =
"BASES REMAINING";



// The next three characters are referenced in draw_scanner.cc and are used
// as symbols in the Endever scanner display.

static const char sector_endever_symbol = 'E';
static const char sector_base_symbol = 'B';
static const char sector_bh_symbol = '?';             // blackhole symbol



// The next four strings are referenced in c_endever.cc in the Endever::die
// method and are used to explain why the Endever got destroyed.

static const char die_blackhole_str[] =
"ENDEVER FALLS INTO BLACKHOLE!";

static const char die_destruct_str[] =
"ENDEVER SELF-DESTRUCTS!";

static const char die_jovian_str[] =
"ENDEVER DESTROYED BY JOVIAN!";

static const char die_star_str[] =
"ENDEVER COLLIDES WITH STAR!";



// The next three strings are referenced in winlose.cc and are used
// when the game is over.

static const char win_str[] =
"MISSION SUCCESSFUL!";

static const char lose_str[] =
"THE FEDERATION HAS FALLEN TO JOVIAN FORCES!";

static const char replay_str[] =
"PLAY AGAIN?";



// The next five strings are prompts for keyboard input.

static const char warpdrive_prompt_str[] = "SECTOR (ROW,COL): ";
static const char shields_prompt_str[] = "SHIELDS (%): ";
static const char fasers_prompt_str[] = "ANGLE (DEG): ";
static const char torpedo_prompt_str[] = "ANGLE (DEG): ";
static const char selfdestruct_prompt_str[] = "ACTIVATION CODE: ";



// This string is referenced in echoarea.cc: endinput(). Blackhole warning.

static const char bh_warning_str[] =
"SENSORS DETECT A BLACKHOLE IN THIS SECTOR!";



// A couple miscellaneous messages

// Endever docked message

static const char docked_str[] =
"ENDEVER DOCKED.";

// Game is paused

static const char paused_str[] =
"PAUSE.";



// The next two strings are referenced in timeouts.cc: flash_to()
// and in c_sector.cc: Sector::detect_hit(). They are used to construct
// a warning message such as this:
//
// FEDERATION BASE AT (3,1) IS UNDER ATTACK!

static const char attack_warning_str_1[] =
"FEDERATION BASE AT ";

static const char attack_warning_str_2[] =
" IS UNDER ATTACK!";


// The next two strings are used to construct an announcement
// such as this:
//
// FEDERATION BASE AT (3,1) HAS BEEN DESTROYED!

static const char dead_base_str_1[] =
"FEDERATION BASE AT ";

static const char dead_base_str_2[] =
" HAS BEEN DESTROYED!";


// Display this string when the game is over because all the
// bases got destroyed.

static const char last_base_str[] =
"THE LAST FEDERATION BASE HAS BEEN DESTROYED!";


#endif				// _MESSAGES_

// end
