/* c_star.hh 1.9 95/12/23 03:11:31 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// class for describing stars.

#ifndef _STAR_
#define _STAR_

#include "c_celestial.hh"
#include <X11/Xlib.h>
#include "space_objects.hh"

class Star: public Celestial
{
public:
  Star(): Celestial() {}
  Identity what() const {return (STAR);}
  void draw(Drawable drawable, GC gc) const;
  static void seticon(const char *str);
  static int geticon_len();
private:
  static char icon[];	// visual representation of a star
  static const int icon_len;
};


// for singly linked lists of stars

struct Star_rec
{
  Star_rec *next;		// next in list
  Star *star_pt;
};


#endif				// _STAR_

// end
