/* c_endever.hh 1.15 95/12/23 03:11:30 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// class for describing the endever

#ifndef _ENDEVER_
#define _ENDEVER_

#include "c_combatant.hh"
#include "common.hh"
#include "space_objects.hh"

class Endever: public Combatant
{
public:
  Endever();
  void erase();
  Identity what() const {return (ENDEVER);}
  int gettorpedoes() const {return (torpedoes);}
  void setshields(int s);
  void settorpedoes(int t){torpedoes = (t >= 0)? t:0;}
  void draw(Drawable drawable, GC gc) const;
  void move(Direction dir);
  void leap(int ur, int uc);		// warp speed leap to new sector
  void shoot(Weapon weapon, double angle);
  void selfdestruct();
  void energize();
  int getmaxerg() const {return (maxerg);}
  bool nomove() const {return (nomoveflag);}
  void setnomove(bool nm) {nomoveflag = nm;}
  static void seticon(const char *str);
  static geticon_len();
private:
  int torpedoes;
  bool docked;			// whether docked to a base
  bool nomoveflag;		// whether move delay enabled (slows ion thrust)
  void dock_check();
  void die(Identity cause);
  static char icon[];
  static const int icon_len;
  static const int maxerg;  // max energy for shields, thrust, warp, or fasers
};


#endif				// _ENDEVER_

// end
