/* c_blackhole.cc 1.4 95/12/23 03:11:27 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// define blackhole methods and data

#include "c_blackhole.hh"
#include "c_body.hh"
#include <iostream.h>


void Blackhole::draw(Drawable drawable, GC gc) const
{
  Body *bdy = (Body *)this;

  bdy->draw(drawable, gc, icon, icon_len);
}


/********************* static members ********************/

const int Blackhole::icon_len = 1;
char Blackhole::icon[icon_len+1];

void Blackhole::seticon(const char *str)
{
  if (strlen(str) != icon_len)
  {
    cerr << "xspacewarp: bad blackhole icon in X resources." << endl;
    exit(1);
  }
  (void) strcpy(icon, str);
}

int Blackhole::geticon_len()
{
  return (icon_len);
}






// end
