/* app_data.hh 1.6 95/12/23 03:11:20 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// define the application data struct. the app resource array is
// defined in xprep.hh


#ifndef _APPDATA_
#define _APPDATA_

#include <X11/StringDefs.h>

typedef struct
{
  Boolean nomouse;		// whether to use mouse pointer
  int rows;   // number rows of 9x15 blocks in a sector of the universe
  int columns;  // number columns of 9x15 blocks in a sector of the universe

  // average numbers of bases, jovians, stars, and blackholes in universe.
  // "min" average refers to the lowest skill level and "max" refers to
  // the highest skill level.

  int min_average_base_pop;	
  int max_average_base_pop;	
  int min_average_jovian_pop;	
  int max_average_jovian_pop;	
  int min_average_star_pop;	
  int max_average_star_pop;	
  int min_average_blackhole_pop;
  int max_average_blackhole_pop;

  // variation in the number of bases, jovians, stars, and
  // blackholes in universe. "min" average refers to the lowest
  // skill level and "max" refers to the highest skill level.

  int min_variation_base_pop;	
  int max_variation_base_pop;	
  int min_variation_jovian_pop;	
  int max_variation_jovian_pop;	
  int min_variation_star_pop;	
  int max_variation_star_pop;	
  int min_variation_blackhole_pop;
  int max_variation_blackhole_pop;

  Pixel foreground;		// color for text and graphical borders
  Pixel background;		// background color for everything

  Pixel endever_color;
  String endever_icon;		// visual symbol for the endever

  Pixel jovian_color;
  String jovian_icon;		// visual symbol for the jovians

  Pixel base_color;
  String base_icon;		// visual symbol for the bases

  Pixel star_color;
  String star_icon;		// visual symbol for the stars

  Pixel blackhole_color;
  String blackhole_icon;	// visual symbol for the blackholes

  Pixel faser_color;
  int faser_width;		// width in pixels
  int faser_dash_offset; // dash pattern, in pixels, of faser dashes
  char *faser_dash_list; // dash pattern, in pixels, of faser dashes
  long faser_speed;	    // millisec interval for faser movement

  Pixel torpedo_color;
  int torpedo_width;		// width in pixels
  int torpedo_length;		// length of torpedo in pixels
  long torpedo_speed;	    // millisec interval for torpedo movement

  Pixel explosion_color;
  long explosion_speed;  // millisec interval for rate of explosion growth
  int explosion_radius_small; // radius to use for most ship explosions
  int explosion_radius_big;   // radius to use for self-destruct explosion

  long endever_thrust_speed;  // millisec interval for endever movement
  long ship_energize_speed; // millisec interval for ship re-energizing
  long jovian_action_speed; // millisec interval between jovian actions
  
  char *self_destruct_code;	// endever self-destruct
  float default_firing_angle;	// endever default faser/torpedo angle (radians)
  int max_torpedoes;		// starting number of torpedoes for endever
 
  int max_jovians_per_sector;
  int max_stars_per_sector;
  int mask_probability;	// probability a sector is masked (percent)

  int min_jovian_distance; // min dist to place endv/bases to jovs in sector

  int endever_min_faser_energy;  // min percent energy needed for faser to work
  int endever_min_warp_energy; // min percent energy for warpdrive to work
  int endever_min_thrust_energy; // min percent energy for thrusters to work
  int jovian_min_faser_energy;  // min percent energy needed for faser to work
  int jovian_min_warp_energy; // min percent energy for warpdrive to work
  int jovian_min_thrust_energy; // min percent energy for thrusters to work

  // If the thrust, warp, faser and shield percent-energies (ie,
  // percent of max energy) of a jovian are
  // less than the respective "retreat" percent-energies, then the
  // jovian exits the battle scene with probability (ie, percent)
  // jovian_retreat_probability. jovian_retreat_speed is the
  // rate at which the jovian flees toward the sector edge.

  int jovian_thrust_retreat_energy;
  int jovian_warp_retreat_energy;
  int jovian_faser_retreat_energy;
  int jovian_shield_retreat_energy;
  int jovian_retreat_probability;
  float jovian_retreat_speed;

  float jovian_min_fight_frequency; // rate at which jovians fight back
  float jovian_max_fight_frequency; // max rate is for highest skill level
  float jovian_min_raid_frequency; // rate at which jovians raid bases
  float jovian_max_raid_frequency; // max rate is for highest skill level
  float jovian_min_leap_frequency; // rate at which jovians leap to new sectors
  float jovian_max_leap_frequency; // max rate is for highest skill level
} AppData;


// string constant definitions

#define XtNnomouse "nomouse"
#define XtCNomouse "Nomouse"
#define XtNrows "rows"
#define XtCRows "Rows"
#define XtNcolumns "columns"
#define XtCColumns "Columns"

#define XtNminAverageBasePop "minAverageBasePop"
#define XtCMinAverageBasePop "MinAverageBasePop"

#define XtNmaxAverageBasePop "maxAverageBasePop"
#define XtCMaxAverageBasePop "MaxAverageBasePop"

#define XtNminAverageJovianPop "minAverageJovianPop"
#define XtCMinAverageJovianPop "MinAverageJovianPop"

#define XtNmaxAverageJovianPop "maxAverageJovianPop"
#define XtCMaxAverageJovianPop "MaxAverageJovianPop"

#define XtNminAverageStarPop "minAverageStarPop"
#define XtCMinAverageStarPop "MinAverageStarPop"

#define XtNmaxAverageStarPop "maxAverageStarPop"
#define XtCMaxAverageStarPop "MaxAverageStarPop"

#define XtNminAverageBlackholePop "minAverageBlackholePop"
#define XtCMinAverageBlackholePop "MinAverageBlackholePop"

#define XtNmaxAverageBlackholePop "maxAverageBlackholePop"
#define XtCMaxAverageBlackholePop "MaxAverageBlackholePop"

#define XtNminVariationBasePop "minVariationBasePop"
#define XtCMinVariationBasePop "MinVariationBasePop"

#define XtNmaxVariationBasePop "maxVariationBasePop"
#define XtCMaxVariationBasePop "MaxVariationBasePop"

#define XtNminVariationJovianPop "minVariationJovianPop"
#define XtCMinVariationJovianPop "MinVariationJovianPop"

#define XtNmaxVariationJovianPop "maxVariationJovianPop"
#define XtCMaxVariationJovianPop "MaxVariationJovianPop"

#define XtNminVariationStarPop "minVariationStarPop"
#define XtCMinVariationStarPop "MinVariationStarPop"

#define XtNmaxVariationStarPop "maxVariationStarPop"
#define XtCMaxVariationStarPop "MaxVariationStarPop"

#define XtNminVariationBlackholePop "minVariationBlackholePop"
#define XtCMinVariationBlackholePop "MinVariationBlackholePop"

#define XtNmaxVariationBlackholePop "maxVariationBlackholePop"
#define XtCMaxVariationBlackholePop "MaxVariationBlackholePop"

#define XtNendeverColor "endeverColor"
#define XtCEndeverColor "EndeverColor"
#define XtNendeverIcon "endeverIcon"
#define XtCEndeverIcon "EndeverIcon"

#define XtNjovianColor "jovianColor"
#define XtCJovianColor "JovianColor"
#define XtNjovianIcon "jovianIcon"
#define XtCJovianIcon "JovianIcon"

#define XtNbaseColor "baseColor"
#define XtCBaseColor "BaseColor"
#define XtNbaseIcon "baseIcon"
#define XtCBaseIcon "BaseIcon"

#define XtNstarColor "starColor"
#define XtCStarColor "StarColor"
#define XtNstarIcon "starIcon"
#define XtCStarIcon "StarIcon"

#define XtNblackholeColor "blackholeColor"
#define XtCBlackholeColor "BlackholeColor"
#define XtNblackholeIcon "blackholeIcon"
#define XtCBlackholeIcon "BlackholeIcon"

#define XtNfaserColor "faserColor"
#define XtCFaserColor "FaserColor"
#define XtNfaserWidth "faserWidth"
#define XtCFaserWidth "FaserWidth"
#define XtNfaserDashOffset "faserDashOffset"
#define XtCFaserDashOffset "FaserDashOffset"
#define XtNfaserDashList "faserDashList"
#define XtCFaserDashList "FaserDashList"
#define XtNfaserSpeed "faserSpeed"
#define XtCFaserSpeed "FaserSpeed"

#define XtNtorpedoColor "torpedoColor"
#define XtCTorpedoColor "TorpedoColor"
#define XtNtorpedoWidth "torpedoWidth"
#define XtCTorpedoWidth "TorpedoWidth"
#define XtNtorpedoSpeed "torpedoSpeed"
#define XtCTorpedoSpeed "TorpedoSpeed"
#define XtNtorpedoLength "torpedoLength"
#define XtCTorpedoLength "TorpedoLength"

#define XtNexplosionColor "explosionColor"
#define XtCExplosionColor "ExplosionColor"
#define XtNexplosionSpeed "explosionSpeed"
#define XtCExplosionSpeed "ExplosionSpeed"
#define XtNexplosionRadiusSmall "explosionRadiusSmall"
#define XtCExplosionRadiusSmall "ExplosionRadiusSmall"
#define XtNexplosionRadiusBig "explosionRadiusBig"
#define XtCExplosionRadiusBig "ExplosionRadiusBig"

#define XtNendeverThrustSpeed "endeverThrustSpeed"
#define XtCEndeverThrustSpeed "EndeverThrustSpeed"
#define XtNshipEnergizeSpeed "shipEnergizeSpeed"
#define XtCShipEnergizeSpeed "ShipEnergizeSpeed"
#define XtNjovianActionSpeed "jovianActionSpeed"
#define XtCJovianActionSpeed "JovianActionSpeed"

#define XtNselfDestructCode "selfDestructCode"
#define XtCSelfDestructCode "SelfDestructCode"
#define XtNdefaultFiringAngle "defaultFiringAngle"
#define XtCDefaultFiringAngle "DefaultFiringAngle"
#define XtNmaxTorpedoes "maxTorpedoes"
#define XtCMaxTorpedoes "MaxTorpedoes"

#define XtNmaxJoviansPerSector "maxJoviansPerSector"
#define XtCMaxJoviansPerSector "MaxJoviansPerSector"
#define XtNmaxStarsPerSector "maxStarsPerSector"
#define XtCMaxStarsPerSector "MaxStarsPerSector"
#define XtNmaskProbability "maskProbability"
#define XtCMaskProbability "MaskProbability"
#define XtNminJovianDistance "minJovianDistance"
#define XtCMinJovianDistance "MinJovianDistance"

#define XtNendeverMinFaserEnergy "endeverMinFaserEnergy"
#define XtCEndeverMinFaserEnergy "EndeverMinFaserEnergy"
#define XtNendeverMinWarpEnergy "endeverMinWarpEnergy"
#define XtCEndeverMinWarpEnergy "EndeverMinWarpEnergy"
#define XtNendeverMinThrustEnergy "endeverMinThrustEnergy"
#define XtCEndeverMinThrustEnergy "EndeverMinThrustEnergy"
#define XtNjovianMinFaserEnergy "jovianMinFaserEnergy"
#define XtCJovianMinFaserEnergy "JovianMinFaserEnergy"
#define XtNjovianMinWarpEnergy "jovianMinWarpEnergy"
#define XtCJovianMinWarpEnergy "JovianMinWarpEnergy"
#define XtNjovianMinThrustEnergy "jovianMinThrustEnergy"
#define XtCJovianMinThrustEnergy "JovianMinThrustEnergy"

#define XtNjovianThrustRetreatEnergy "jovianThrustRetreatEnergy"
#define XtCJovianThrustRetreatEnergy "JovianThrustRetreatEnergy"
#define XtNjovianWarpRetreatEnergy "jovianWarpRetreatEnergy"
#define XtCJovianWarpRetreatEnergy "JovianWarpRetreatEnergy"
#define XtNjovianFaserRetreatEnergy "jovianFaserRetreatEnergy"
#define XtCJovianFaserRetreatEnergy "JovianFaserRetreatEnergy"
#define XtNjovianShieldRetreatEnergy "jovianShieldRetreatEnergy"
#define XtCJovianShieldRetreatEnergy "JovianShieldRetreatEnergy"
#define XtNjovianRetreatProbability "jovianRetreatProbability"
#define XtCJovianRetreatProbability "JovianRetreatProbability"
#define XtNjovianRetreatSpeed "jovianRetreatSpeed"
#define XtCJovianRetreatSpeed "JovianRetreatSpeed"


#define XtNjovianMinFightFrequency "jovianMinFightFrequency"
#define XtCJovianMinFightFrequency "JovianMinFightFrequency"
#define XtNjovianMaxFightFrequency "jovianMaxFightFrequency"
#define XtCJovianMaxFightFrequency "JovianMaxFightFrequency"
#define XtNjovianMinRaidFrequency "jovianMinRaidFrequency"
#define XtCJovianMinRaidFrequency "JovianMinRaidFrequency"
#define XtNjovianMaxRaidFrequency "jovianMaxRaidFrequency"
#define XtCJovianMaxRaidFrequency "JovianMaxRaidFrequency"
#define XtNjovianMinLeapFrequency "jovianMinLeapFrequency"
#define XtCJovianMinLeapFrequency "JovianMinLeapFrequency"
#define XtNjovianMaxLeapFrequency "jovianMaxLeapFrequency"
#define XtCJovianMaxLeapFrequency "JovianMaxLeapFrequency"


#endif				// _APPDATA_

// end
