/******************************************************************************
Copyright (c) 1994, 1997 by Jin Yu.
All rights reserved.

The software provided hereunder is on an "AS IS" basis. Permission to
use, copy, modify, and distribute this software and its documentation
for any non-commercial purpose, without fee, and without written
agreement is hereby granted, provided that the above copyright notice
appears in all copies of this software.
******************************************************************************/

#include "xminehunter.h"


void mine_hunter_T::init_app(void)
{
  int i, j, position, num;

  // allocating memory
  app_part->state = new app_T::state_T* [app_part->field_height];
  for (i=0; i<app_part->field_height; i++)
    app_part->state[i] = new app_T::state_T[app_part->field_width];

  for (i=0; i<app_part->field_height; i++)
    for (j=0; j<app_part->field_width; j++) {
      app_part->state[i][j].open = False;
      app_part->state[i][j].surface = Unknown;
      app_part->state[i][j].bottom = Empty;
    }

  for (i=0; i<10; i++) {
    app_part->high_score[i].name[0] = '\0';
    app_part->high_score[i].score = INT_MAX;
  }

  // randomly distribute mines
  for (i=0; i<app_part->num_of_mines; i++) {
    position = rand() % (app_part->field_width * app_part->field_height);
    while (app_part->state[position / app_part->field_width]
			  [position % app_part->field_width].bottom
		     == Bomb)
      position = rand() % (app_part->field_width * app_part->field_height);
    app_part->state[position / app_part->field_width]
		   [position % app_part->field_width].bottom
	      = Bomb;
  }

  // calculating the color numbers
  for (i=0; i<app_part->field_height; i++)
    for (j=0; j<app_part->field_width; j++)
      if (app_part->state[i][j].bottom != Bomb) {
	num = 0;
	/* upper left */
	if (i>0 && j>0)
	  if (app_part->state[i-1][j-1].bottom == Bomb)
	    num++;
	/* upper right */
        if (i>0 && j<app_part->field_width-1)
	  if (app_part->state[i-1][j+1].bottom == Bomb)
            num++;
	/* lower left */
	if (i<app_part->field_height-1 && j>0)
          if (app_part->state[i+1][j-1].bottom == Bomb)
	    num++;
	/* lower right */
	if (i<app_part->field_height-1 && j<app_part->field_width-1)
	  if (app_part->state[i+1][j+1].bottom == Bomb)
            num++;
	/* top */
	if (i>0)
	  if (app_part->state[i-1][j].bottom == Bomb)
            num++;
	/* bottom */
	if (i<app_part->field_height-1)
	  if (app_part->state[i+1][j].bottom == Bomb)
            num++;
	/* left */
	if (j>0)
	  if (app_part->state[i][j-1].bottom == Bomb)
            num++;
	/* right */
	if (j<app_part->field_width-1)
	  if (app_part->state[i][j+1].bottom == Bomb)
            num++;

	switch (num) {
	  case 1:
		app_part->state[i][j].bottom = Near1;
		break;
	  case 2:
		app_part->state[i][j].bottom = Near2;
                break;
	  case 3:
                app_part->state[i][j].bottom = Near3;
                break;
	  case 4:
                app_part->state[i][j].bottom = Near4;
                break;
	  case 5:
                app_part->state[i][j].bottom = Near5;
                break;
	  case 6:
                app_part->state[i][j].bottom = Near6;
                break;
	  case 7:
                app_part->state[i][j].bottom = Near7;
                break;
	  case 8:
                app_part->state[i][j].bottom = Near8;
                break;
	  default:
                app_part->state[i][j].bottom = Empty;
	}
      }
}


void mine_hunter_T::widen(int i, int j)
{
  /* upper left */
  if (i>0 && j>0)
    if (!app_part->state[i-1][j-1].open && app_part->state[i-1][j-1].surface != Flag) {
      show_bottom(i-1, j-1);
      app_part->open_counter++;
      if ( app_part->state[i-1][j-1].bottom == Empty )
        widen(i-1, j-1);
    }
  /* upper right */
  if (i>0 && j<app_part->field_width-1)
    if (!app_part->state[i-1][j+1].open && app_part->state[i-1][j+1].surface != Flag) {
      show_bottom(i-1, j+1);
      app_part->open_counter++;
      if (app_part->state[i-1][j+1].bottom == Empty)
        widen(i-1, j+1);
    }
  /* lower left */
  if (i<app_part->field_height-1 && j>0)
    if (!app_part->state[i+1][j-1].open && app_part->state[i+1][j-1].surface != Flag) {
      show_bottom(i+1, j-1);
      app_part->open_counter++;
      if (app_part->state[i+1][j-1].bottom == Empty)
        widen(i+1, j-1);
    }
  /* lower right */
  if (i<app_part->field_height-1 && j<app_part->field_width-1)
    if (!app_part->state[i+1][j+1].open && app_part->state[i+1][j+1].surface != Flag) {
      show_bottom(i+1, j+1);
      app_part->open_counter++;
      if (app_part->state[i+1][j+1].bottom == Empty)
        widen(i+1, j+1);
    }
  /* top */
  if (i>0)
    if (!app_part->state[i-1][j].open && app_part->state[i-1][j].surface != Flag) {
      show_bottom(i-1, j);
      app_part->open_counter++;
      if (app_part->state[i-1][j].bottom == Empty)
        widen(i-1, j);
    }
  /* bottom */
  if (i<app_part->field_height-1)
    if (!app_part->state[i+1][j].open && app_part->state[i+1][j].surface != Flag) {
      show_bottom(i+1, j);
      app_part->open_counter++;
      if (app_part->state[i+1][j].bottom == Empty)
        widen(i+1, j);
    }
  /* left */
  if (j>0)
    if (!app_part->state[i][j-1].open && app_part->state[i][j-1].surface != Flag) {
      show_bottom(i, j-1);
      app_part->open_counter++;
      if (app_part->state[i][j-1].bottom == Empty)
        widen(i, j-1);
    }
  /* right */
  if (j<app_part->field_width-1)
    if (!app_part->state[i][j+1].open && app_part->state[i][j+1].surface != Flag) {
      show_bottom(i, j+1);
      app_part->open_counter++;
      if (app_part->state[i][j+1].bottom == Empty)
        widen(i, j+1);
    }

}


void mine_hunter_T::quick(int i, int j)
{
  int num_bomb, bomb_marked = 0;
  Bool lose_flag = False;

  switch (app_part->state[i][j].bottom) {
  case Empty:
    XBell(XtDisplay(gui_part->MainShellW), 0);
    return;
  case Near1:
    num_bomb = 1;
    break;
  case Near2:
    num_bomb = 2;
    break;
  case Near3:
    num_bomb = 3;
    break;
  case Near4:
    num_bomb = 4;
    break;
  case Near5:
    num_bomb = 5;
    break;
  case Near6:
    num_bomb = 6;
    break;
  case Near7:
    num_bomb = 7;
    break;
  case Near8:
    num_bomb = 8;
    break;
  case Bomb:
    // this cannot happen
    return;
  }

  /* upper left */
  if (i>0 && j>0)
    if (!app_part->state[i-1][j-1].open && app_part->state[i-1][j-1].surface == Flag)
      bomb_marked++;
  /* upper right */
  if (i>0 && j<app_part->field_width-1)
    if (!app_part->state[i-1][j+1].open && app_part->state[i-1][j+1].surface == Flag)
      bomb_marked++;
  /* lower left */
  if (i<app_part->field_height-1 && j>0)
    if (!app_part->state[i+1][j-1].open && app_part->state[i+1][j-1].surface == Flag)
      bomb_marked++;
  /* lower right */
  if (i<app_part->field_height-1 && j<app_part->field_width-1)
    if (!app_part->state[i+1][j+1].open && app_part->state[i+1][j+1].surface == Flag)
      bomb_marked++;
  /* top */
  if (i>0)
    if (!app_part->state[i-1][j].open && app_part->state[i-1][j].surface == Flag)
      bomb_marked++;
  /* bottom */
  if (i<app_part->field_height-1)
    if (!app_part->state[i+1][j].open && app_part->state[i+1][j].surface == Flag)
      bomb_marked++;
  /* left */
  if (j>0)
    if (!app_part->state[i][j-1].open && app_part->state[i][j-1].surface == Flag)
      bomb_marked++;
  /* right */
  if (j<app_part->field_width-1)
    if (!app_part->state[i][j+1].open && app_part->state[i][j+1].surface == Flag)
      bomb_marked++;

  if (bomb_marked != num_bomb) {
    XBell(XtDisplay(gui_part->MainShellW), 0);
    return;
  }

  /* upper left */
  if (i>0 && j>0)
  if (!app_part->state[i-1][j-1].open)
    if (app_part->state[i-1][j-1].surface != Flag) {
      if (app_part->state[i-1][j-1].bottom == Bomb) {
	lose_flag = True;
        XtVaSetValues(gui_part->BlockW[i-1][j-1],
		      XmNshadowThickness, 0,
		      XmNlabelPixmap, gui_part->openbomb_bmap,
		      NULL);
	app_part->state[i-1][j-1].open = True;
      }
      else {
        show_bottom(i-1, j-1);
	app_part->open_counter++;
        if (app_part->state[i-1][j-1].bottom == Empty)
	  widen(i-1, j-1);
      }
    }
      
  /* upper right */
  if (i>0 && j<app_part->field_width-1)
  if (!app_part->state[i-1][j+1].open)
    if (app_part->state[i-1][j+1].surface != Flag) {
      if (app_part->state[i-1][j+1].bottom == Bomb) {
	lose_flag = True;
        XtVaSetValues(gui_part->BlockW[i-1][j+1],
		      XmNshadowThickness, 0,
		      XmNlabelPixmap, gui_part->openbomb_bmap,
		      NULL);
	app_part->state[i-1][j+1].open = True;
      }
      else {
        show_bottom(i-1, j+1);
	app_part->open_counter++;
        if (app_part->state[i-1][j+1].bottom == Empty)
	  widen(i-1, j+1);
      }
    }

  /* lower left */
  if (i<app_part->field_height-1 && j>0)
  if (!app_part->state[i+1][j-1].open)
    if (app_part->state[i+1][j-1].surface != Flag) {
      if (app_part->state[i+1][j-1].bottom == Bomb) {
	lose_flag = True;
        XtVaSetValues(gui_part->BlockW[i+1][j-1],
		      XmNshadowThickness, 0,
		      XmNlabelPixmap, gui_part->openbomb_bmap,
		      NULL);
	app_part->state[i+1][j-1].open = True;
      }
      else {
        show_bottom(i+1, j-1);
	app_part->open_counter++;
        if (app_part->state[i+1][j-1].bottom == Empty)
	  widen(i+1, j-1);
      }
    }

  /* lower right */
  if (i<app_part->field_height-1 && j<app_part->field_width-1)
  if (!app_part->state[i+1][j+1].open)
    if (app_part->state[i+1][j+1].surface != Flag) {
      if (app_part->state[i+1][j+1].bottom == Bomb) {
	lose_flag = True;
        XtVaSetValues(gui_part->BlockW[i+1][j+1],
		      XmNshadowThickness, 0,
		      XmNlabelPixmap, gui_part->openbomb_bmap,
		      NULL);
	app_part->state[i+1][j+1].open = True;
      }
      else {
        show_bottom(i+1, j+1);
	app_part->open_counter++;
        if (app_part->state[i+1][j+1].bottom == Empty)
	  widen(i+1, j+1);
      }
    }

  /* top */
  if (i>0)
  if (!app_part->state[i-1][j].open)
    if (app_part->state[i-1][j].surface != Flag) {
      if (app_part->state[i-1][j].bottom == Bomb) {
	lose_flag = True;
        XtVaSetValues(gui_part->BlockW[i-1][j],
		      XmNshadowThickness, 0,
		      XmNlabelPixmap, gui_part->openbomb_bmap,
		      NULL);
	app_part->state[i-1][j].open = True;
      }
      else {
        show_bottom(i-1, j);
	app_part->open_counter++;
        if (app_part->state[i-1][j].bottom == Empty)
	  widen(i-1, j);
      }
    }

  /* bottom */
  if (i<app_part->field_height-1)
  if (!app_part->state[i+1][j].open)
    if (app_part->state[i+1][j].surface != Flag) {
      if (app_part->state[i+1][j].bottom == Bomb) {
	lose_flag = True;
        XtVaSetValues(gui_part->BlockW[i+1][j],
		      XmNshadowThickness, 0,
		      XmNlabelPixmap, gui_part->openbomb_bmap,
		      NULL);
	app_part->state[i+1][j].open = True;
      }
      else {
        show_bottom(i+1, j);
	app_part->open_counter++;
        if (app_part->state[i+1][j].bottom == Empty)
	  widen(i+1, j);
      }
    }

  /* left */
  if (j>0)
  if (!app_part->state[i][j-1].open)
    if (app_part->state[i][j-1].surface != Flag) {
      if (app_part->state[i][j-1].bottom == Bomb) {
	lose_flag = True;
        XtVaSetValues(gui_part->BlockW[i][j-1],
		      XmNshadowThickness, 0,
		      XmNlabelPixmap, gui_part->openbomb_bmap,
		      NULL);
	app_part->state[i][j-1].open = True;
      }
      else {
        show_bottom(i, j-1);
	app_part->open_counter++;
        if (app_part->state[i][j-1].bottom == Empty)
	  widen(i, j-1);
      }
    }

  /* right */
  if (j<app_part->field_width-1)
  if (!app_part->state[i][j+1].open)
    if (app_part->state[i][j+1].surface != Flag) {
      if (app_part->state[i][j+1].bottom == Bomb) {
	lose_flag = True;
        XtVaSetValues(gui_part->BlockW[i][j+1],
		      XmNshadowThickness, 0,
		      XmNlabelPixmap, gui_part->openbomb_bmap,
		      NULL);
	app_part->state[i][j+1].open = True;
      }
      else {
        show_bottom(i, j+1);
	app_part->open_counter++;
        if (app_part->state[i][j+1].bottom == Empty)
	  widen(i, j+1);
      }
    }


  if (lose_flag) {
    lose();
    return;
  }

  if ( app_part->open_counter ==
         app_part->field_width * app_part->field_height -
           app_part->num_of_mines
       && app_part->flag_counter == app_part->num_of_mines )
    win();

}


void mine_hunter_T::new_game(int mine_num,
                             int width_of_field, int height_of_field)
{
  del();

  app_part->first_move = True;
  app_part->open_counter = app_part->flag_counter = 0;
  app_part->num_of_mines = mine_num;
  app_part->field_width = width_of_field;
  app_part->field_height = height_of_field;
  app_part->time = 0;

  setup_blocks();
  init_app();

  XmString xm_str = XmStringCreate("0", "TAG1");
  XtVaSetValues(gui_part->TimeW, XmNlabelString, xm_str, NULL);
  XmStringFree(xm_str);

  if (gui_part->normal_pmap != XtUnspecifiedPixmap)
    XtVaSetValues(gui_part->NewGameW,
		  XmNlabelPixmap, gui_part->normal_pmap,
		  NULL);

  Dimension cmd_form_width, game_button_width;
  XtVaGetValues(gui_part->CommandW, XmNwidth, &cmd_form_width, NULL);
  XtVaGetValues(gui_part->NewGameW, XmNwidth, &game_button_width, NULL);

  XtVaSetValues(gui_part->NewGameW,
		XmNleftAttachment, XmATTACH_NONE,
		XmNx, (cmd_form_width - game_button_width) / 2,
		NULL);

  char count_str[80];
  sprintf(count_str, "%d", app_part->num_of_mines);
  xm_str = XmStringCreate(count_str, "TAG1");
  XtVaSetValues(gui_part->MineCountW, XmNlabelString, xm_str, NULL);
  XmStringFree(xm_str);

  XtVaSetValues(gui_part->MessageW,
		XmNlabelString, gui_part->MessageString,
		NULL);

}


int mine_hunter_T::lock(void)
{
  char fname[80];
  int fd;
  struct flock fl;

  strcpy(fname, app_part->high_score_path);

  switch (app_part->game_mode) {
  case Customized:
    return -1;
  case Easy:
    strcat(fname, "/easy.lock");
    break;
  case Medium:
    strcat(fname, "/medium.lock");
    break;
  case Hard:
    strcat(fname, "/hard.lock");
    break;
  }

  if ( (fd = open(fname, O_WRONLY | O_CREAT, S_IWUSR|S_IWGRP|S_IWOTH)) == -1 )
    return -1;

  fl.l_type = F_WRLCK;
  fl.l_start = 0;
  fl.l_whence = SEEK_SET;
  fl.l_len = 0;

  if ( fcntl(fd, F_SETLKW, &fl) == -1 )
    return -1;

  return fd;
}


Bool mine_hunter_T::unlock(int fd)
{
  struct flock fl;

  fl.l_type = F_UNLCK;
  fl.l_start = 0;
  fl.l_whence = SEEK_SET;
  fl.l_len = 0;

  if ( fcntl(fd, F_SETLKW, &fl) == -1 )
    return False;

  close(fd);
  return True;
}


Bool mine_hunter_T::read(void)
{
  // assuming we have the lock
  // read file into data struct
  char fname[80];
  int fd;
  struct stat sbuf;
  signed char sc[1];
  unsigned char uc[1];
  int i, j;
  int score;

  strcpy(fname, app_part->high_score_path);

  switch (app_part->game_mode) {
  case Customized:
    return False;
  case Easy:
    strcat(fname, "/easy.hunter");
    break;
  case Medium:
    strcat(fname, "/medium.hunter");
    break;
  case Hard:
    strcat(fname, "/hard.hunter");
    break;
  }

  if ( stat(fname, &sbuf) == -1 )
    return True; // file doesn't exist => no high score recorded

  if (sbuf.st_size != (80 + sizeof(int)) * 10)
    return False; // file screwed up

  if ( (fd = open(fname, O_RDONLY)) == -1 )
    return False;

  for (i=0; i<10; i++) {
    for (j=0; j<80; j++) {
      if ( ::read(fd, sc, sizeof(signed char)) != sizeof(signed char) ) {
	close(fd);
	return False;
      }
      app_part->high_score[i].name[j] = -sc[0];
    }
    app_part->high_score[i].name[79] = '\0';

    app_part->high_score[i].score = 0;
    for (j=0; j<sizeof(int); j++) {
      if ( ::read(fd, uc, sizeof(unsigned char)) != sizeof(unsigned char) ) {
	close(fd);
	return False;
      }
      score = uc[0];
      app_part->high_score[i].score |=
	( score << ( (sizeof(int)-1-j) * CHAR_BIT ) );
    }
  }

  close(fd);
  return True;
}


Bool mine_hunter_T::write(void)
{
  // assuming we have the lock
  // write data struct into file
  char fname[80];
  int fd;
  signed char sc[1];
  unsigned char uc[1];
  int i, j;
  int score;

  strcpy(fname, app_part->high_score_path);

  switch (app_part->game_mode) {
  case Customized:
    return False;
  case Easy:
    strcat(fname, "/easy.hunter");
    break;
  case Medium:
    strcat(fname, "/medium.hunter");
    break;
  case Hard:
    strcat(fname, "/hard.hunter");
    break;
  }

  if ( (fd = open(fname, O_WRONLY | O_CREAT | O_TRUNC,
		  S_IRUSR|S_IWUSR | S_IRGRP|S_IWGRP | S_IROTH|S_IWOTH))
       == -1 )
    return False;

  for (i=0; i<10; i++) {
    for (j=0; j<80; j++) {
      sc[0] = - app_part->high_score[i].name[j];
      if ( ::write(fd, sc, sizeof(signed char)) != sizeof(signed char) ) {
	close(fd);
	return False;
      }
    }

    for (j=0; j<sizeof(int); j++) {
      score =
	app_part->high_score[i].score >> ( (sizeof(int)-1-j) * CHAR_BIT );
      uc[0] = score & 0xff;
      if ( ::write(fd, uc, sizeof(unsigned char)) != sizeof(unsigned char) ) {
	close(fd);
	return False;
      }
    }
  }

  close(fd);
  return True;

}


int mine_hunter_T::compare_score(void)
{
  // assuming we have the lock
  if ( ! read() ) return -1;

  for (int i=0; i<10; i++)
    if (app_part->time < app_part->high_score[i].score)
      return i;

  return -1;
}


Bool mine_hunter_T::update_score(char *name)
{
  // assuming we have the lock
  int place, i;

  if ( (place = compare_score()) == -1 ) return False;

  for (i=9; i>place; i--) {
    strcpy(app_part->high_score[i].name, app_part->high_score[i-1].name);
    app_part->high_score[i].score = app_part->high_score[i-1].score;
  }

  strcpy(app_part->high_score[place].name, name);
  app_part->high_score[place].score = app_part->time;

  return write();
}
