/* Copyright 1991, Torstein Hansen.
 *	     1995, Michael Quinn.
 * This program is freely distributable without licensing fees and
 * is provided without guarantee or warranty expressed or implied.
 */

#include <X11/cursorfont.h>
#include "xfibs.h"
#include "Fibw.h"  /* the Fabulously Impressive Backgammon board Widget :) */
#include "callbacks.h"
#include "config.h"
#include "popup.h"
#include "parse.h"
#include "bg.icon"
#include "text.icon"

Widget		xfibs, toplevel, form, pane, menu_bar, bgboard, 
		toptext, textform, textpane, textmenu, outscr, inpscr,
		outtext, intext;
XtAppContext	app;   
Cursor		cursor, textCursor;
int		columns = 80;
int		FIBSrows = 24;
int		typeRows = 5;

extern String	fallback_resources[];

char	AppId[] = "XFibs";
char	TextId[] = "XFibs Text";

#define BOARDWIDTH	640
#define BOARDHEIGHT	480

static XrmOptionDescRec options[] = {
    { "-nonumbers",	"*numbers",	XrmoptionNoArg, "False"},
    { "-numbers",	"*numbers",	XrmoptionNoArg, "True"},
    { "-onframe",	"*onboard",	XrmoptionNoArg, "True"},
    { "-debug",		"*debug",	XrmoptionNoArg, "True"},
};

static void bg_icon_create() 
{
    Pixmap icon_pixmap = (Pixmap)NULL;
    Arg arg;

    XtSetArg(arg, XtNiconPixmap, &icon_pixmap);
    XtGetValues(xfibs, &arg, 1);
    if (icon_pixmap == (Pixmap) NULL) {
        XtSetArg(arg, XtNiconPixmap,
                XCreateBitmapFromData(XtDisplay(xfibs),
                                    XtScreen(xfibs)->root,
                                    bg_bits, bg_width, bg_height));
        XtSetValues(xfibs, &arg, 1);
    }

    return;
}

static void text_icon_create() 
{
    Pixmap icon_pixmap = (Pixmap)NULL;
    Arg arg;

    XtSetArg(arg, XtNiconPixmap, &icon_pixmap);
    XtGetValues(toptext, &arg, 1);
    if (icon_pixmap == (Pixmap) NULL) {
        XtSetArg(arg, XtNiconPixmap,
                XCreateBitmapFromData(XtDisplay(xfibs),
                                    XtScreen(xfibs)->root,
                                    text_bits, text_width, text_height));
        XtSetValues(toptext, &arg, 1);
    }

    return;
}


static void Syntax(argc, argv)
int 	 argc;
char	*argv[];
{
    int	i;
    int errs = 0;

    for (i = 1; i < argc; i++) {
	if (!errs++)
	    fprintf(stderr, "%s: command line option unknown:\n", argv[0]);
	fprintf(stderr, "\t%s\n", argv[i]);
    }
}


void setTitle(title)
char *title;
{
char	string[80];

    strcpy(string, AppId);
    if (title)
	strncat(string, title, sizeof(string) - strlen(string));
    /* Set the window & icon titles */
    XStoreName(XtDisplay(xfibs), XtWindow(xfibs), string);
    XSetIconName(XtDisplay(xfibs), XtWindow(xfibs), AppId);

    /* Set the window & icon titles */
    XStoreName(XtDisplay(toptext), XtWindow(toptext), TextId);
    XSetIconName(XtDisplay(toptext), XtWindow(toptext), TextId);
}


main(argc, argv)
int 	 argc;
char	*argv[];
{
    Window	boardWindow;
    Window	textWindow;
    XEvent	event;

#ifdef RUNBACK		/* This makes xfibs run in the background! */
    pid_t i;
    i=fork();
    if (i)
        return 0;
#endif /* RUNBACK */

    /* This is our application, initialise everything.. */
    xfibs = XtVaAppInitialize(&app, AppId, options, XtNumber(options),
        (Cardinal *) &argc, argv, fallback_resources,
	NULL, NULL);

    if (argc > 1)
	Syntax(argc, argv);

    /* This one holds the menu bar & board */
    form = XtVaCreateManagedWidget("form", xmFormWidgetClass, xfibs, NULL);

    /* Flush pending command queue then buld menu_bar from startup file */
    initPendingList();
    parse_startup(form, &menu_bar, 0);

    pane = XtVaCreateManagedWidget("pane",
        xmPanedWindowWidgetClass, form,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNbottomAttachment, XmATTACH_FORM,
        XmNtopWidget, menu_bar,
        NULL);

    cursor = XCreateFontCursor(XtDisplay(form), XC_watch);

    bgboard = XtVaCreateManagedWidget("bgboard",
        fibwWidgetClass, pane,
	XmNpaneMinimum, 100,
	NULL);
	
    /* Can't set stuff until there's a bgboard widget, can't have bgboard
     * until we've parsed.. So need to set them in a seperate routine.
     */
    setUserFlags();
    /* Define the second window with the text screens */
    toptext = XtVaCreatePopupShell("toptext", topLevelShellWidgetClass, xfibs,
	XtNtitle, TextId,
	NULL);

    /* This one holds the input & output screens */
    textform = XtVaCreateManagedWidget("textform", xmFormWidgetClass,
			toptext, NULL);

    /* X has no way to clone widgets, so run through menu-build again */
    parse_startup(textform, &textmenu, 1);

    textpane = XtVaCreateManagedWidget("textpane",
        xmPanedWindowWidgetClass, textform,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNbottomAttachment, XmATTACH_FORM,
        XmNtopWidget, textmenu,
        NULL);

    textCursor = XCreateFontCursor(XtDisplay(textform), XC_watch);

    outscr = XtVaCreateManagedWidget("outscroll",xmScrolledWindowWidgetClass,
	textpane,NULL);

    inpscr = XtVaCreateManagedWidget("inscroll",xmScrolledWindowWidgetClass,
	textpane, NULL);
	
    outtext = XtVaCreateManagedWidget("outtext", xmTextWidgetClass, outscr,
        XmNrows,		FIBSrows,
        XmNcolumns,		columns,
	XmNpaneMinimum,		35,
	XmNeditable,		False,
	XmNwordWrap,		True,
        XmNscrollVertical,	True,
	XmNscrollHorizontal,	False,
	XmNautoShowCursorPosition,	True,
	XmNcursorPositionVisible,	False,
	XmNtraversalOn,		False,
	XmNmaxLength,		OUTBUFLENGTH, 
        XmNeditMode,		XmMULTI_LINE_EDIT,
        NULL);

    intext = XtVaCreateManagedWidget("intext", xmTextWidgetClass, inpscr,
        XmNrows,		typeRows,
        XmNcolumns,		columns,
	XmNpaneMinimum,		35,
	XmNwordWrap,		True,
	XmNscrollVertical,	True,
	XmNscrollHorizontal,	False,
	XmNverifyBell,		False,
	XmNeditMode,		XmMULTI_LINE_EDIT,
	NULL);

    /* Add a callback to the intext widget. Any input here will be
       sent to the FIBS-server. */
   
    XtAddCallback(intext, XmNmodifyVerifyCallback, 
	    (XtCallbackProc)added_text, NULL);

    bg_icon_create();
    text_icon_create();
    XtPopup(toptext, XtGrabNone);
    XtRealizeWidget(xfibs);

    createMovePopup(bgboard);
    createMoveBear(bgboard);
    createDoublePopup(bgboard);
    createRollPopup(bgboard);
    createRollBear(bgboard);
    createJoinPopup(bgboard);
    createResignPopup(bgboard);
    createNoPopup(bgboard);
    use_popup((FibwWidget)bgboard, no_popup_id);

    setTitle(NULL);

#ifdef FIREWALL
    SOCKSinit(argv[0]);
#endif

    if (autologin)
        add_to_pending_list("connect");

    /* We're looking for keyboard events from bgboard to send to intext */
    boardWindow = XtWindow(bgboard);
    textWindow = XtWindow(intext);

    /* Expand XtAppMainLoop(app) to look for keyboard events */
    for (; ;) {
	XtAppNextEvent(app, &event);
	/* If it's a keypress from the boardWindow, send it to the textWindow */
	if (event.type == KeyPress && event.xkey.window == boardWindow)
		event.xkey.window = textWindow;
	/* Send key releases too (just in case) */
	else if (event.type == KeyRelease && event.xkey.window == boardWindow)
		event.xkey.window = textWindow;
	XtDispatchEvent(&event);
    }
    return 0;
}
