/*
 * Now, this is something I really doesn't know a thing about...
 * In this file, some routines for opening and closing sockets resides.
 * Please report any silly mistakes.
*/


#include <string.h>
#include <errno.h>
#include "xfibs.h"
#include "comms.h"
#include "parse.h"

extern char *sys_errlist[];
extern int sys_nerr;

struct sockaddr_in	 server;
struct hostent		*hp; 
int			 s; 

void socketinit();
void socketclose();

#ifdef _NO_PROTO
char *Strerror();
#else
const char *Strerror(int errnum);
#endif

void socketinit()
{
    char *buf;
    
    buf=(char *)XtMalloc(sizeof(char)*LINELENGTH);
    if (!buf) {
        fprintf(stderr,"Memory allocation error!");
        exit(1);
    }

    /* Not everyone has bzero, so..
     * bzero((char *)&server, sizeof(server));
     */
    memset((char *)&server, 0, sizeof(server));
    
    hp = gethostbyname(host_name);
    if (hp == NULL) {
        fprintf(stderr, "gethostbyname couldn't find host '%s'\n", host_name);
        server.sin_addr.s_addr = inet_addr(host_name);
        if (!server.sin_addr.s_addr || (int)server.sin_addr.s_addr == -1){
            fprintf(stderr, "inet_addr problem with '%s'\n", host_name);
            exit(1);
        }
	server.sin_family = AF_INET;
    }
    else {
	/* Not everyone has bcopy, so..
         * bcopy(hp->h_addr, (char *)&server.sin_addr, hp->h_length);
	 */
        memcpy((char *)&server.sin_addr, hp->h_addr, hp->h_length);
        server.sin_family = hp->h_addrtype;
    }

    XmTextInsert(outtext, XmTextGetLastPosition(outtext),
	    "Connecting to server...\n");
    /* htons is called for the code to work with both big-endian and
       small-endian machines */
    server.sin_port = htons(port_number);
    s = socket(AF_INET, SOCK_STREAM, 0);
    if (s < 0) {
        strcpy(buf, Strerror(errno));
        buf[strlen(buf)] = '\n';
        buf[strlen(buf) + 1] = '\0';
        XmTextInsert(outtext, XmTextGetLastPosition(outtext),
                "Network problems...\n");
        XmTextInsert(outtext, XmTextGetLastPosition(outtext),buf);
        s = 0;
	return;
    }
#ifdef FIREWALL
    if (Rconnect(s,(struct sockaddr *)&server, sizeof(server)) <0) {
#else
    if (connect(s,(struct sockaddr *)&server, sizeof(server)) <0) {
#endif /* FIREWALL */

        strcpy(buf, Strerror(errno));
        buf[strlen(buf)] = '\n';
        buf[strlen(buf)+1] = '\0';
        XmTextInsert(outtext, XmTextGetLastPosition(outtext),
                "Network problems...\n");
        XmTextInsert(outtext, XmTextGetLastPosition(outtext), buf);
        s = 0;
        return;
    }
    XtFree((void *)buf);
    return;
}


void socketclose()
{
    close(s);
    s=0;
    return;
}

#ifdef _NO_PROTO
char *Strerror(errnum)
#else
const char *Strerror(errnum)
#endif
int errnum;
{
    if (errnum < 0 || errnum > sys_nerr)
        return ("unknown error");
    
    return(sys_errlist[errnum]);
}
