/*
 * Program XBLAST V2.5.15 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * October 18, 1998
 * started August 1993
 *
 * File: data.c
 * level data 
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: data.c,v 1.4 1999/08/07 20:46:17 xblast Exp $
 * $Log: data.c,v $
 * Revision 1.4  1999/08/07 20:46:17  xblast
 * purged
 *
 * Revision 1.3  1999/04/02 14:21:58  xblast
 * All extras block now rendered with PoVRay
 *
 * Revision 1.2  1998/10/18 12:30:04  xblast
 * Morphing Bomb extra
 *
 * Revision 1.1  1998/01/03 14:11:32  xblast
 * Initial revision
 *
 */

#define _DATA_C

#include <stdio.h>
#include <stdlib.h>

#include "include.h"
#include "mytypes.h"
#include "const.h"
#include "func.h"
#include "data.h"
#include "shrink.h"
#include "bomb.h"
#include "main.h"

/*
 * scramble macro
 */
#define SCRAMBLE_VOID {GAME_TIME+1, 0, NULL}

/*
 * macros for extras
 */
#define EXTRA_BOMB        { "bomb",          NULL, "Red",             "White" }
#define EXTRA_RANGE       { "range",         NULL, "Yellow",          "White" }
#define EXTRA_TRAP        { "trap",          NULL, "Cyan",            "White" }
#define EXTRA_KICK        { "kick_bomb",     NULL, "Blue",            "White" }
#define EXTRA_INVINC      { "invincible",    NULL, "Gold",            "White" }
#define EXTRA_BUTTON      { "ignite",        NULL, "DeepPink",        "White" }
#define EXTRA_CONSTR      { "construction",  NULL, "Firebrick1",      "White" }
#define EXTRA_RC          { "remote_control",NULL, "SpringGreen",     "White" }
#define EXTRA_BEAM        { "q3a_beam",      NULL, "Orchid",          "White" }
#define EXTRA_AIRPUMP     { "air_pump",      NULL, "SkyBlue",         "White" }
#define EXTRA_NAPALM      { "napalm",        NULL, "OrangeRed",       "White" }
#define EXTRA_FIRECRACKER { "firecracker",   NULL, "Orange",          "White" }
#define EXTRA_SYRINGE     { "syringe",       NULL, "YellowGreen",     "White" }
#define EXTRA_POISON      { "poison",        NULL, "SteelBlue",       "White" }
#define EXTRA_SPEED       { "speed",         NULL, "DeepSkyBlue",     "White" }
#define EXTRA_SLOW        { "slow",          NULL, "SeaGreen",        "White" }
#define EXTRA_MAYHEM      { "mayhem",        NULL, "NavyBlue",        "White" }
#define EXTRA_HOLYGRAIL   { "holygrail",     NULL, "Gold",            "White" }
#define EXTRA_MULTIPLE    { "multiple",      NULL, "DodgerBlue",      "White" }
#define EXTRA_LIFE        { "life",          NULL, "Tomato",          "White" }
#define EXTRA_CLOAK       { "cloak",         NULL, "BlueViolet",      "White" }
#define EXTRA_TRIANGLE    { "triangle_bomb", NULL, "MediumVioletRed", "White" }
#define EXTRA_POW         { "pow",           NULL, "BlueViolet",      "White" }
#define EXTRA_MORPH       { "morph",         NULL, "Green",           "White" }

#define _ BTFree
#define B BTBlock
#define R BTBlockRise
#define X BTExtra
#define b BTBomb
#define r BTRange
#define s BTSick
#define q BTSpecial
#define v BTVoid
#define e BTEvil 
#define V -1

/*
 * default void for scrambling blocks
 */

#include "level/Seek_N_Destroy.h"
#include "level/Treasure_Hunt.h"
#include "level/Shrinking_World.h"
#include "level/XBlast_2000.h"
#include "level/Full_Power.h"
#include "level/Hexagon_Excitation.h"
#include "level/Running_Man.h"
#include "level/Legoland.h"
#include "level/Paradise_City.h"
#include "level/Halloween.h"
#include "level/Gravitation.h"
#include "level/Duel_In_The_Sun.h"
#include "level/Beamania.h"
#include "level/Close_Quarters.h"
#include "level/Stunning.h"
#include "level/Blast_O_Morph.h"

#include "level/ChainReaction.h"
#include "level/Nowhere2run.h"
#include "level/Haunted_House.h"
#include "level/Four_Corners.h"
#include "level/Cave_In.h"
#include "level/Mind_Games.h"

#include "level/Suicide.h"
#include "level/Indiana_Jones.h"
#include "level/Hallways.h"

#include "level/Losange_Over_excitation.h"

#include "level/Mr_Beam.h"

#include "level/Shrinking_Arena.h"
  
#include "level/Gold_Rush.h"
#include "level/Survivor.h"
#include "level/Inv_X_Ible.h"
#include "level/Tic_Tac_Toe.h"
#include "level/Je_M_Appelle_Rico.h"
#include "level/Toutencarton.h"
#include "level/Born_To_Be_Kill.h"
  
#include "level/Peppercorn.h"
#include "level/Closet_Psycho.h"
#include "level/LaBoom.h"
#include "level/TwoBeTwo.h"
#include "level/Footwork.h"
#include "level/Hall_of_Snooker.h"
#include "level/Contact_Sports.h"
#include "level/Popcorn.h"
#include "level/NapalmJustice.h"
#include "level/FantasyLand.h"
#include "level/Survival.h"
#include "level/FryingPan.h"
#include "level/BricksFries.h"
#include "level/FireSurprise.h"
#include "level/Spindizzy.h"
#include "level/NothingShort.h"
#include "level/YourAge.h"
#include "level/SpaceHead.h"
#include "level/BeAJunkie.h"
#include "level/HotStuff.h"
#include "level/SkyShow.h"

#include "level/Bouncy.h"
#include "level/WatchBanana.h"

#include "level/Fungus_Fun.h"
#include "level/Open_Warfare.h"
#include "level/Get_Your_Kit_Out.h"
#include "level/Moonwalking.h"
#include "level/Pot_Luck.h"

#include "level/Pandemonium.h"
#include "level/All_Good_Things.h"
#include "level/SplitDecision.h"

#include "level/Gravitation_Is_Back.h"
#include "level/Judgement_Day.h"
#include "level/Asymmetrix.h"

#include "level/Bricklayer.h"
#include "level/Eraser.h"

#include "level/TotalControl.h"
#include "level/Stormy.h"
#include "level/Mazerunner.h"

#include "level/Crual_Rebounds.h"
#include "level/Esquive.h"
#include "level/Star_Hazzard.h"
#include "level/Tetris_Land.h"

#include "level/Arrgghh.h"
#include "level/Fundamental_Error.h"
#include "level/Temple_of_Doom.h"
#include "level/Full_Power_II.h"
#include "level/XBlast_3000.h"
#include "level/The_Great_Escape.h"
#include "level/Slow.h"
#include "level/Mayhem.h"
#include "level/HolyGrail.h"
#include "level/Gravity.h"
#include "level/Anti_Gravity.h"
#include "level/Hide_N_Seek.h"
#include "level/Trench_Warfare.h"
#include "level/Running_Man_II.h"
#include "level/Psychological_Warfare.h"
#include "level/What_The_F.h"
#include "level/Keep_Your_Eye_On_The_Bomb.h"
#include "level/Lives.h"
#include "level/Try_It_And_See.h"
/*
 * *EDIT* include your level file below
 */
#include "level/Bomb_Surprise.h"
#include "level/Chaos.h"
#include "level/Double_Crown.h"
#include "level/Gravitational_Rotation.h"
#include "level/Grenada.h"
#include "level/Nowhere2runII.h"
#include "level/Magic.h"
#include "level/Pyramid.h"
#include "level/Random.h"
#include "level/Snowflake.h"
#include "level/Spider_Web.h"

#include "level/ScrewHim.h"
#include "level/CreepingDeath.h"

/* 
 * No new levels beyond this point 
 */


BMLevelData *internal_maze_data[] = {
  &Seek_N_Destroy,
  &Treasure_Hunt,
  &Shrinking_World,
  &XBlast_2000,
  &Full_Power,
  &Hexagon_Excitation,
  &Running_Man,
  &Legoland,
  &Paradise_City,
  &Halloween,
  &Gravitation,
  &Duel_In_The_Sun,
  &BlastFree,
  &Close_Quarters,
  &Stunning,
  &Blast_O_Morph,
 
  /* contributed levels*/

  &ChainReaction,
  &Nowhere2run,
  &Haunted_House,
  &Four_Corners,
  &Cave_In,
  &Mind_Games,

  &Suicide,
  &Indiana_Jones,
  &Hallways,

  &Losange_Over_excitation,

  &Mr_Beam,

  &Shrinking_Arena,
  
  &Gold_Rush,
  &Survivor,
  &Inv_X_Ible,
  &Tic_Tac_Toe,
  &Je_M_Appelle_Rico,
  &Toutencarton,
  &Born_To_Be_Kill,
  
  &Peppercorn,
  &Closet_Psycho,
  &LaBoom,
  &TwoBeTwo,
  &Footwork,
  &Hall_of_Snooker,
  &Contact_Sports,
  &Popcorn,
  &NapalmJustice,
  &FantasyLand,
  &Survival,
  &FryingPan,
  &BricksFries,
  &FireSurprise,
  &Spindizzy,
  &NothingShort,
  &YourAge,
  &SpaceHead,
  &BeAJunkie,
  &HotStuff,
  &SkyShow,

  &BouncyBouncy,
  &WatchBanana,

  &Fungus_Fun,
  &Open_Warfare,
  &Get_Your_Kit_Out,
  &Moonwalking,
  &Pot_Luck,

  &All_Good_Things,
  &Pandemonium,
  &SplitDecision,

  &Gravitation_Is_Back, 
  &Judgement_Day,
  &Asymmetrix,
  &Bricklayer,
  &Eraser,

  &TotalControl,
  &Stormy,
  &MazeRunner,

  &CrualRebounds,
  &Esquive,
  &StarHazzard,
  &Tetris_Land,

  /* adelaide levels */
  &Arrgghh,
  &The_Fundamental_Error,
  &Temple_of_Doom,
  &Full_Power_Level_II,
  &XBlast_3000,
  &The_Great_Escape,
  &Slow,
  &Mayhem,
  &HolyGrail,
  &Gravity,
  &Anti_Gravity,
  &Hide_N_Seek,
  &Trench_Warfare,
  &Running_Man_II,
  &Psychological_Warfare,
  &What_The_F,
  &Keep_Your_Eye_On_The_Bomb,
  &Lives,
  &Try_It_And_See,
  /*
   * *EDIT* insert the reference to your level below.
   */
  &Bomb_Surprise,
  &Chaos,
  &Double_Crown,
  &Gravitational_Rotation,
  &Grenada,
  &Magic,
  &Nowhere2runII,
  &Pyramid,
  &Random,
  &Snowflake,
  &Spider_Web,

  &ScrewHim,
  &CreepingDeath,

  /* 
   * No new levels beyond this point 
   */
  NULL,
};

#include "level/ScoreBoard2.h"
#include "level/ScoreBoard3.h"
#include "level/ScoreBoard4.h"
#include "level/ScoreBoard5.h"
#include "level/ScoreBoard6.h"
#include "level/ScoreBoard2x2.h"
#include "level/ScoreBoard3x2.h"

BMLevelData *score_board_data[] = {
  &ScoreBoard2,
  &ScoreBoard3,
  &ScoreBoard4,
  &ScoreBoard5,
  &ScoreBoard6,
  &ScoreBoard2x2,
  &ScoreBoard3x2,
  NULL,
};

#include "level/Congratulations2.h"
#include "level/Congratulations3.h"
#include "level/Congratulations4.h"
#include "level/Congratulations5.h"
#include "level/Congratulations6.h"
#include "level/Congratulations2x2.h"
#include "level/Congratulations3x2.h"
#include "level/CongratulationsD2.h"
#include "level/CongratulationsD3.h"
#include "level/CongratulationsD4.h"


BMLevelData *winning_data[] = {
  &Congratulations2,
  &Congratulations3,
  &Congratulations4,
  &Congratulations5,
  &Congratulations6,
  &Congratulations2x2,
  &Congratulations3x2,
  &CongratulationsD2,
  &CongratulationsD3,
  &CongratulationsD4,
  NULL,
};


/* This is important */

#undef _ 
#undef B 
#undef X 
#undef b 
#undef r 
#undef s 
#undef q 

/*
 * end of file data.c
 */

