// $Id: score.cxx,v 1.2 1995/06/12 14:09:49 beust Exp $

#include "main.hxx"

//////////////////////////////////////////////////////////////////////
// public

//ctor
Score::Score(String path, Bool isCooperativeGame,
	     String userName, String otherUserName)
	     
   : _Score(0), HIGH_SCORE_COUNT(10), _IsCooperativeGame(isCooperativeGame),
     _NonCooScoreCount(0), _CooScoreCount(0)
{
   _Path = new char [strlen(path) + 1];
   strcpy(_Path, path);

   _UserName = new char [strlen(userName) + 2];
   sprintf(_UserName, "%s", userName);   // # is used for consistency check
                                          // when rereading the file
   _OtherUserName = new char [strlen(otherUserName) + 2];
   sprintf(_OtherUserName, "%s", otherUserName);

   _CooScore = new InternalScoreRec_t [HIGH_SCORE_COUNT];
   _NonCooScore = new InternalScoreRec_t [HIGH_SCORE_COUNT];

}

Score::~Score(void)
{
   delete _Path;
   delete _UserName;
   delete _OtherUserName;
   delete _CooScore;
   delete _NonCooScore;
}

Bool
Score::saveScore(void)
{
   Bool result = True;
   readInternalScore();
   saveInternalScore();
//   result = updateScoreFile();
   return result;
}

void
Score::resetScore(void)
{
   setScore(0);
}

void
Score::incrementScore(int lineNumber)
{
   Cardinal s = getScore();
   s += lineNumber * 10;    //@@ add sth wrt the current speed of fall
   setScore(s);
}

void
Score::getHighScores(char cooScores[], char nonCooScores[], size_t size)
{
   readInternalScore();
   strcpy(cooScores, "");
   strcpy(nonCooScores, "");

   char line[128];
   Cardinal n;
   for (n = 0; n < HIGH_SCORE_COUNT; n++) {
      InternalScoreRec_t *s = getCooScore();
      sprintf(line, "%-8d%-40s\n", s[n].score, s[n].name);
      strcat(cooScores, line);

      InternalScoreRec_t *ns = getNonCooScore();
      sprintf(line, "%-8d\t%-40s\n", ns[n].score, ns[n].name);
      strcat(nonCooScores, line);
   }

}

//////////////////////////////////////////////////////////////////////
// private


Bool
Score::lockFile(void)
{
   //
   // check lock
   //
   Bool isLocked = True, lockSuccess = False;
   unsigned int retries = 3;
   char lockFile[100];
   sprintf(lockFile, "%s.lock", getPath());

   while (isLocked && retries > 0) {
      ifstream *lockStream = new ifstream(lockFile);
      if (lockStream -> bad()) {
	 lockStream -> close();
	 delete lockStream;

	 ofstream *newLockStream = new ofstream(lockFile);
	 newLockStream -> close(); delete newLockStream;
	 isLocked = False;
	 lockSuccess = True;
      }
      else {
	 if (--retries > 0) {
	    int n = rand() % 5;
	    cout << "High score file locked, sleeping for " << n
		 << " seconds" << endl;
	    sleep(n);
	 }
	 else {
	    cout << "High score file locked, giving up" << endl;
	 }
      }
   }

   return lockSuccess;
}

void
Score::unlockFile(void)
{
   char lockFile[100];
   sprintf(lockFile, "%s.lock", getPath());

   unlink(lockFile);
}


istream &
operator >> (istream &is, Score::InternalScoreRec_t &s)
{
   char strScore[32];

   // read score
   is.get((char *) strScore, sizeof(strScore));
   s.score = atoi(strScore);
   is.get();    // skip eol

   // read name
   is.get((char *) s.name, 64);
   is.get();    // skip eol

   return is;
}

ostream &
operator << (ostream &os, Score::InternalScoreRec_t &s)
{
   char line[256];
   sprintf(line, "%d\n%s\n", s.score, s.name);
   os << line;

   return os;
}

/*
void
Score::readInternalScore(void)
{
   
}
*/

void
Score::readInternalScore(void)
{
   String teamName = new char [strlen(getUserName())
			       + strlen(getOtherUserName()) + 1];
   sprintf(teamName, "%s & %s", getUserName(), getOtherUserName());

   String path = getPath();
   ifstream *inf = new ifstream(path, ios::in);
   Cardinal n;

   if (inf -> good()) {
      //
      // Read the non-cooperative scores first
      //
      n = 0;
      while (! inf -> eof() && n < HIGH_SCORE_COUNT && inf -> peek() != '@') {
	 *inf >> _NonCooScore[n++];
      }
      //
      // Skip separator
      //
      char dummyBuffer[256];
      while (! inf -> eof() && inf -> peek() == '@')
	 inf -> getline(dummyBuffer, sizeof(dummyBuffer));
      //
      // Read the cooperative part now
      //
      n = 0;
      while (! inf -> eof() && n < HIGH_SCORE_COUNT && inf -> peek() != '@') {
	 *inf >> _CooScore[n++];
      }
      inf -> close();

   } // else no high score file
   else {
      cout << "No high score file, will create one for you ("
	 << getPath() << ")" << endl;

      for (n = 0; n < HIGH_SCORE_COUNT; n++) {
	 strcpy(_CooScore[n].name, "<none>");
	 _CooScore[n].score = 0;
	 strcpy(_NonCooScore[n].name, "<none>");
	 _NonCooScore[n].score = 0;
      }
   }
}

Bool
Score::saveInternalScore(void)
{
   Bool isScoreAdded = False;

   if (! lockFile()) return isScoreAdded;

   String path = getPath();

   //
   // Open backup file and write score in it
   //
   char *bakPath = new char [strlen(path) + 5];
   sprintf(bakPath, "%s.%d", path, getpid());
   ofstream *bak = new ofstream(bakPath, ios::out);
   if (bak -> bad()) {
      cout << "score:: couldn't open " << bakPath << endl;
      return isScoreAdded;
   }
   
   Cardinal index;
   Cardinal writtenScores;
   InternalScoreRec_t thisScore;
   if (getIsCooperativeGame()) {
      char buf[128];
      sprintf(buf, "%s & %s", getUserName(), getOtherUserName());
      strcpy(thisScore.name, buf);
   }
   else {
      strcpy(thisScore.name, getUserName());
   }
   thisScore.score = getScore();
   Bool isScoreInserted = False;

   //
   // Write non-cooperative scores (and possible insert this
   // score if it beats a highest one)
   //
   writtenScores = 0;
   index = 0;
   while (writtenScores < HIGH_SCORE_COUNT) {
      if (! getIsCooperativeGame() &&
	  _NonCooScore[index].score < getScore() &&
	 ! isScoreInserted) {
	 *bak << thisScore;
	 isScoreInserted = True;
      }
      else {
	 *bak << _NonCooScore[index++];
      }
      writtenScores++;
   }
   *bak << "@" << endl;

   //
   // Write cooperative score now
   //
   writtenScores = 0;
   index = 0;

   while (writtenScores < HIGH_SCORE_COUNT) {
      if (getIsCooperativeGame() &&
	  _CooScore[index].score < getScore() &&
	 ! isScoreInserted) {
	 *bak << thisScore;
	 isScoreInserted = True;
      }
      else {
	 *bak << _CooScore[index++];
      }
      writtenScores++;
   }
   *bak << "@" << endl;
   bak -> close();

   //
   // Backup file written, write on the high score file
   //
   {
      char command[100];
      sprintf(command, "mv %s %s", bakPath, path);
      system(command);
      unlink(bakPath);
   }

   unlockFile();
}


//////////////////////////////////////////////////////////////////////
// public

//ctor
MotifScore::MotifScore(String path, Bool isCooperativeGame,
		       Widget topLevel,
		       String userName, String otherUserName) :
      Score(path, isCooperativeGame, userName, otherUserName),
	    _topLevel(topLevel)
{	     
    //
    // Message box
    //
    _infoMB = XmCreateInformationDialog(_topLevel, "infoMB", 0, 0);
    _formMB = XmCreateForm(_infoMB, "formMB", 0, 0);
    _labelMB = XmCreateLabel(_formMB, "labelMB", 0, 0);
    XtVaSetValues(_labelMB,
		  XmNlabelString, XmStringCreateSimple("High scores"),
		  XmNleftAttachment, XmATTACH_POSITION,
		  XmNleftPosition, 40,
		  XmNrightAttachment, XmATTACH_POSITION,
		  XmNrightPosition, 60,
		  XmNtopAttachment, XmATTACH_FORM,
		  0);
    _listMB = XmCreateText(_formMB, "listMB", 0, 0);
    XtVaSetValues(_listMB,
		  XmNleftAttachment, XmATTACH_FORM,
		  XmNrightAttachment, XmATTACH_FORM,
		  XmNtopAttachment, XmATTACH_WIDGET,
		  XmNtopWidget, _labelMB,
		  XmNbottomAttachment, XmATTACH_FORM,
		  XmNeditMode, XmMULTI_LINE_EDIT,
		  XmNrows, 10,
		  XmNcolumns, 40,
		  0);
    XtManageChild(_formMB); XtManageChild(_listMB); XtManageChild(_labelMB);
    XtUnmanageChild(XmMessageBoxGetChild(_infoMB, XmDIALOG_CANCEL_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild(_infoMB, XmDIALOG_HELP_BUTTON));

}

MotifScore::~MotifScore()
{
   
}

void
MotifScore::map(Boolean isCooperative,
		const String messageString, const String labelString)
{
   XmString xmsMsg, xmsMsg2;
   char s1[4096], s2[4096];

   XtVaSetValues(_infoMB,
		 XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
                 XmNmessageString, xmsMsg= XmStringCreateSimple(messageString),
                 XmNokLabelString,xmsMsg2=XmStringCreateSimple(labelString),
                 0);
   getHighScores(s1, s2, sizeof(s1));
   if (isCooperative)
      XtVaSetValues(_listMB,
		    XmNvalue, s1,
		    0);
   else
      XtVaSetValues(_listMB,
		    XmNvalue, s2,
		    0);
   XtManageChild(_infoMB);
}
