// $Id: mainWindow2.cxx,v 1.1 1995/07/28 15:08:31 beust Exp beust $

//
// 2nd part of the MainWindow implementation :
// ctor and related static functions
//

#include "main.hxx"



#ifndef SEND_UDP_PACKET
    extern "C" int
       KoalaSpy_SendPacket(char *host, /* 0 -> SPY_HOST */
			   int port,   /* 0 -> SPY_PORT */
			   char *progName,   /* defines the log file */
			   char *origin,    /* 0 -> hostname */
			   char *msg);

#endif /* SEND_UDP_PACKET */



//////////////////////////////////////////////////////////////////////
// Static functions
//////////////////////////////////////////////////////////////////////

void
cbStart(Widget wid, XtPointer client_data, XtPointer call_data)
{
   MainWindow *w = (MainWindow *) client_data;
   Board *board = w -> board1;
   Bool wasRunning = False;

   //
   // Clean up boards
   //
   if (Board::GAME_RUNNING == w -> getGameStatus())
      wasRunning = True;
   w -> reset();

   //
   // Pick a random block and send it to the opponent
   //
   board -> setActiveBlock(board -> getRandomBlock());
   int value = (board -> lastRandomBlock << 8) |
      Communicator::STARTING_BLOCK;
   w -> communicator -> sendValue(Communicator::Value(value));

   //
   // Indicate start of the game to opponent
   //
   if (0 != call_data) {    // kludge, are we called from communicator ?
      w -> communicator -> sendValue(Communicator::START_GAME);
   }

   board -> mapBlock(*board -> getActiveBlock());
   //
   // Only if game is not running, draw the other block
   //
   if (! wasRunning) board -> drawRest();

   w -> setGameStatus(Board::GAME_RUNNING);
   w -> board1 -> setGameStatus(Board::GAME_RUNNING);
   if (w -> board2)
      w -> board2 -> setGameStatus(Board::GAME_RUNNING);

   void cbTimeout(XtPointer, XtIntervalId *);
   w -> timeoutId = XtAppAddTimeOut(w -> appContext, INITIAL_TIMEOUT,
				    cbTimeout, w);

}

static void
returnPressedMap(Widget w, XEvent *ev, String *str, Cardinal *n)
{
   MainWindow *mw = MainWindow_g;

   char *newKeymap = XmTextFieldGetString(w);
   if (strlen(newKeymap) != 5) {
      cout << "illegal keymap" << endl;
      XmTextFieldSetString(w, mw -> _keymap);
   }
   else {
      mw -> updateKeymap(newKeymap);
   }
   XtSetKeyboardFocus(mw -> toplevel, mw -> draw1);
}

static void
returnPressedName(Widget w, XEvent *ev, String *str, Cardinal *n)
{
   MainWindow *mw = MainWindow_g;
   char *name = XmTextFieldGetString(w);
   mw -> communicator -> sendName(name);
   mw -> board1 -> getScore() -> setUserName(name);
   XtSetKeyboardFocus(mw -> toplevel, mw -> startB);


/*
   char *newKeymap = XmTextFieldGetString(w);
   if (strlen(newKeymap) != 5) {
      cout << "illegal keymap" << endl;
      XmTextFieldSetString(w, mw -> _keymap);
   }
   else {
      mw -> updateKeymap(newKeymap);
   }
*/
}

static void
actionQuit(Widget wid, XEvent *xev, String *s, Cardinal *n)
{
   ::exit(1);
}

static void
actionFlipLeft(Widget wid, XEvent *xev, String *s, Cardinal *n)
{
   if (Board::GAME_RUNNING == MainWindow_g -> getGameStatus())
       MainWindow_g -> flipLeft();
}

static void
actionFlipRight(Widget wid, XEvent *xev, String *s, Cardinal *n)
{
   if (Board::GAME_RUNNING == MainWindow_g -> getGameStatus())
       MainWindow_g -> flipRight();
}

static void
actionMoveRight(Widget wid, XEvent *xev, String *s, Cardinal *n)
{
   if (Board::GAME_RUNNING == MainWindow_g -> getGameStatus())
       MainWindow_g -> moveRight();
}

static void
actionMoveLeft(Widget wid, XEvent *xev, String *s, Cardinal *n)
{
   if (Board::GAME_RUNNING == MainWindow_g -> getGameStatus())
       MainWindow_g -> moveLeft();
}

static void
actionFall(Widget wid, XEvent *xev, String *s, Cardinal *n)
{
   if (Board::GAME_RUNNING == MainWindow_g -> getGameStatus())
       MainWindow_g -> fall();
}

static void
cbQuit(Widget wid, XtPointer client_data, XtPointer call_data)
{
   ::exit(1);
}

static void
cbShowHighScores(Widget wid, XtPointer client_data, XtPointer call_data)
{
   MainWindow *mw = (MainWindow *) client_data;
   mw -> board1 -> getScore() ->
      map(mw -> getPrefs() -> isCooperative, "High scores", "Ok");
	  
}

static void
cbDisplayAbout(Widget wid, XtPointer client_data, XtPointer call_data)
{
   static Widget info = 0;
   char *s = "\nMultitetris v1.30\n\nwritten by\nCedric Beust\n(beust@sophia.inria.fr)\n";
   MainWindow *mw = (MainWindow *) client_data;

   if (0 == info) {
      info = XmCreateInformationDialog(mw -> toplevel, "infoAbout", 0, 0);
      XtVaSetValues(info,
		    XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
		    XmNmessageString, XmStringCreateSimple("About Multitetris"),
		    0);
      Widget form = XmCreateForm(info, "formAbout", 0, 0);
      Widget label = XmCreateLabel(form, "labelAbout", 0, 0);
      XtVaSetValues(label,
		    XmNleftAttachment, XmATTACH_FORM,
		    XmNtopAttachment, XmATTACH_FORM,
		    XmNrightAttachment, XmATTACH_FORM,
		    XtVaTypedArg,XmNlabelString, XtRString, s, strlen(s),
		    0);
      XtManageChild(form);
      XtManageChild(label);

      XtUnmanageChild(XmMessageBoxGetChild(info, XmDIALOG_CANCEL_BUTTON));
      XtUnmanageChild(XmMessageBoxGetChild(info, XmDIALOG_HELP_BUTTON));
   }
   XtManageChild(info);
}

static void
cbExpose(Widget wid, XtPointer client_data, XtPointer call_data)
{
   MainWindow *w = (MainWindow *) client_data;
//   w -> board -> drawAll()
////   w -> activeBlock1 -> draw(w);
////   w -> activeBlock2 -> draw(w);
}


void
cbPause(Widget wid, XtPointer client_data, XtPointer call_data)
{
   MainWindow *w = (MainWindow *) client_data;
   XmString xms;

   if (w -> getGameStatus() != Board::GAME_PAUSED) {
      w -> communicator -> sendValue(Communicator::PAUSE_GAME);
      w -> setGameStatus(Board::GAME_PAUSED);
   }
   else {
      w -> communicator -> sendValue(Communicator::UNPAUSE_GAME);
      w -> setGameStatus(Board::GAME_RUNNING);
   }

}


//////////////////////////////////////////////////////////////////////
// Member functions
//////////////////////////////////////////////////////////////////////


//
// I should really be using XtOffset() but gcc 2.5.8 and 2.6.0
// are broken and flag an error (2.6.3 works fine). So kludge ahead
//
/*
#define XtOffset(p_type,field) \
	(sizeof(int)*((unsigned int)&(((p_type)0)->field)))
*/

static XtResource resources[] = {
#define offset(field) XtOffset(MainWindow::ParamRec *, field)
	 { "client", "Client", XtRBoolean, sizeof(Boolean),
	 offset(isClient),  XtRImmediate, (caddr_t) False},
	 { "cooperative", "Cooperative", XtRBoolean, sizeof(Boolean),
	 offset(isCooperative), XtRImmediate, (caddr_t) False},
	 { "verbose", "Verbose", XtRBoolean, sizeof(Boolean),
	 offset(isVerbose), XtRImmediate, (caddr_t) False },
	 { "3d", "3d", XtRBoolean, sizeof(Boolean),
	 offset(is3D), XtRImmediate, (caddr_t) False },
	 { "help", "Help", XtRBoolean, sizeof(Boolean),
	 offset(isHelp), XtRImmediate, (caddr_t) False },
	 { "debug", "Debug", XtRInt, sizeof(int),
	 offset(debug), XtRImmediate, (caddr_t) 0},
	 { "nopacket", "Nopacket", XtRBoolean, sizeof(Boolean),
	 offset(isNopacket), XtRImmediate, (caddr_t) False},
	 { "myname", "Myame", XtRString, sizeof(XtRString),
	 offset(myname), XtRImmediate, (caddr_t) "<nobody>"},
	 { "opponent", "Opponent", XtRString, sizeof(XtRString),
	 offset(opponent), XtRImmediate, (caddr_t) 0},
	 { "highscore", "Highscore", XtRString, sizeof(XtRString),
         offset(highScoreFile), XtRImmediate, (caddr_t) DEFAULT_HIGH_SCORE_FILE}
#undef offset
};


static XrmOptionDescRec options[] = {
    {"-client", "*client", XrmoptionNoArg, "True"},
    {"-cooperative", "*cooperative", XrmoptionNoArg, "True" },
    {"-verbose", "*verbose", XrmoptionNoArg, "True" },
    {"-3d", "*3d", XrmoptionNoArg, "True" },
    {"-help", "*help", XrmoptionNoArg, "True" },
    {"-debug", "*debug", XrmoptionSepArg, 0 },
    {"-nopacket", "*nopacket",  XrmoptionNoArg, "True" },
    {"-myname", "*myname", XrmoptionSepArg, "<nobodyCL>" },
    {"-opponent", "*opponent", XrmoptionSepArg, 0 },
    {"-highscore", "*highscore", XrmoptionSepArg, DEFAULT_HIGH_SCORE_FILE }

};

// ctor
//  extern "C" XtEventHandler _XEditResCheckMessages;

MainWindow::MainWindow(int argc, char **argv)
   : currentTimeout(INITIAL_TIMEOUT),
     _programName(argv[0])
{
    Widget tmp;
    Arg args[16];
    int n, i;
    String fallbackResources[] = {
/*
       "MultiTetris*XmDrawingArea*translations:   #override \n	<Key>a: moveLeft()\n	<Key>s: flipLeft()\n	<Key>d: moveRight()\n	<Key>space: fall()",
*/
       "MultiTetris*mainForm*XmPushButton*translations:   #override \\n  <Key>s: flipLeft()\\n <Key>a: moveLeft()\\n <Key>d: moveRight()\\n <Key>p: flipRight()\\n <Key>space: fall() \\n <Key>q: quit()\\n",

       "MultiTetris.colorBlock0: black",
       "MultiTetris.colorBlock1: wheat",
       "MultiTetris.colorBlock2: lightblue",
       "MultiTetris.colorBlock3: yellow",
       "MultiTetris.colorBlock4: green",
       "MultiTetris.colorBlock5: peachpuff",
       "MultiTetris.colorBlock6: whitesmoke",
       "MultiTetris.colorBlock7: grey",

    // font of the menubar
       "MultiTetris*menubar*fontList:-bitstream-*-*-r-*-*-16-*-*-*-*-*-*-*",

       "MultiTetris*XmLabel.x: 0",
       "MultiTetris*XmLabel.width: 90",
       "MultiTetris*XmFrame.x: 5",
       "MultiTetris*XmFrame.width 90",

       "MultiTetris*statusFrame.y: 50",
       "MultiTetris*statusFrame.height: 50",
       "MultiTetris*statusL1.y: 0",
       "MultiTetris*statusL1.height:20",
       "MultiTetris*statusL2.y:20",
       "MultiTetris*statusL2.height:30",

       "MultiTetris*scoreFrame.y: 110",
       "MultiTetris*scoreFrame.height: 40",
       "MultiTetris*scoreL1.y:0",
       "MultiTetris*scoreL1.height:30",
       "MultiTetris*linesL1.y: 20",
       "MultiTetris*linesL1.height: 40",

    // About dialogue
       "MultiTetris*infoAbout*foreground: Yellow",
       "MultiTetris*infoAbout*background: Grey60",
       "MultiTetris*infoAbout*fontList: -bitstream-*-*-*-*-*-20-*-*-*-*-*-*-*",
       "MultiTetris*infoAbout.?.foreground: Orange",
       "MultiTetris*infoAbout.foreground: Orange",
       "MultiTetris*infoAbout.Message*fontList: -*-*-*-*-*-*-14-*-*-*-*-*-*-*",

   // keymap
       "MultiTetris*mapL.labelString: Keymap",
       "MultiTetris*mapFrame.y: 180",
       "MultiTetris*mapFrame.height: 40",
       "MultiTetris*mapL.x: 0",
       "MultiTetris*mapL.y: 0",
       "MultiTetris*mapL.height: 30",
       "MultiTetris*mapTF.x: 0",
       "MultiTetris*mapTF.width: 90",
       "MultiTetris*mapTF.y: 30",
       "MultiTetris*mapTF.height: 20",
       "MultiTetris*mapTF*background:gold",

    // name
       "MultiTetris*nameL.labelString: Name",
       "MultiTetris*nameFrame.y: 240",
       "MultiTetris*nameFrame.height: 40",
       "MultiTetris*nameL.x: 0",
       "MultiTetris*nameL.y: 0",
       "MultiTetris*nameL.height: 30",
       "MultiTetris*nameTF.x: 0",
       "MultiTetris*nameTF.width: 90",
       "MultiTetris*nameTF.y: 30",
       "MultiTetris*nameTF.height: 20",
       "MultiTetris*nameTF*background:gold",
//       "MultiTetris*nameTF.value: <nobody>",

       "MultiTetris*startB.labelString: Start",
       "MultiTetris*pauseB.labelString: Pause",
       "MultiTetris*statusL1.labelString: Game status",
       "MultiTetris*statusL2.labelString: Paused",
       "MultiTetris*linesL1.labelString: Lines : 0",
       "MultiTetris*scoreL1.labelString: Score : 0",
       "MultiTetris*geometry: 650",
       "MultiTetris*marginWidth: 0",
       "MultiTetris*marginHeight: 0",
       "MultiTetris*control*XmLabel*background: gold",
       "MultiTetris*control*XmPushButton*background: gold",
       "MultiTetris*control*foreground: RoyalBlue",
       "MultiTetris*control.background: orange",
       "MultiTetris*mainForm.background: orange",
       "MultiTetris*mainForm*geometry:300x100",
       "MultiTetris*form.background: blue",
       "MultiTetris*draw1.background: SlateGray",
       "MultiTetris*sep1.background: orange",
       "MultiTetris*draw2.background: SlateGray",
       "MultiTetris*XmPushButton*recomputeSize: False",
       "MultiTetris*infoMB*XmBulletinBoard.dialogStyle: DIALOG_PRIMARY_APPLICATION_MODAL",
       "MultiTetris*infoMB*geometry: 100x230",
       0
    };

   _keymap =DEFAULT_KEYMAP;

    XtToolkitInitialize();
    appContext = XtCreateApplicationContext();
    XtAppSetFallbackResources(appContext, fallbackResources);
    {
       static XtActionsRec mainWindowActionTable[] = {
	  {"quit", actionQuit},
	  {"flipLeft", actionFlipLeft},
	  {"flipRight", actionFlipRight},
	  {"moveLeft", actionMoveLeft},
	  {"moveRight", actionMoveRight},
	  {"fall", actionFall},
	  0
       };
       XtAppAddActions(appContext,
		       mainWindowActionTable, XtNumber(mainWindowActionTable));
    }

    display = XtOpenDisplay(appContext, NULL, NULL, CLASS_NAME, NULL, 0,
			    & argc, argv);
    if (0 == display) {
       cerr << "Error, can't open display" << endl;
       exit(0);
    }
    toplevel = XtAppCreateShell("MultiTetris", CLASS_NAME,
				applicationShellWidgetClass,
				display, NULL, 0);
    assert(toplevel);

    XtAddEventHandler(toplevel, 0, True,
		      (XtEventHandler) _XEditResCheckMessages, NULL);

    {
       XrmDatabase db = XtDatabase(display);
       XrmParseCommand(& db, options, XtNumber(options), CLASS_NAME,
			       & argc, argv);
    }
    _Prefs = new ParamRec;

#ifndef SEND_UDP_PACKET
    {
       char *p = (char *) getenv("USER");
       if (p)
	  if (strcmp(p, "beust"))
	     if (! getPrefs() -> isNopacket)
		KoalaSpy_SendPacket(0, 0, "tet", 0, "1.30 started");
//       if (p)
//	  free(p);
    }
#endif /* SEND_UDP_PACKET */

    XtGetApplicationResources(toplevel, _Prefs, resources, XtNumber(resources),
			      0, 0);

    cout << "Using score file : " << getPrefs() -> highScoreFile << endl;
    if (getPrefs() -> isHelp) usage();
    if (getPrefs() -> isVerbose) {
       cout <<  "debug level is " <<  _Prefs -> debug << endl;
       cout << "opponent is " << _Prefs -> opponent << endl;
       cout << "modeClient is " << (_Prefs -> isClient ? "on" : "off") << endl;
       cout << "cooperative is " << (_Prefs->isCooperative ? "on" : "off") << endl;
       cout << "3d is " << (_Prefs -> is3D ? "on" : "off") << endl;
       cout << "name is " << _Prefs -> myname << endl;
       cout << "opponent is " << (_Prefs -> opponent ? _Prefs->opponent:"null") << endl;
    }

    mainw = XmCreateMainWindow(toplevel, "mainw", 0, 0);
    assert(mainw);
    menubar = XmCreateMenuBar(mainw, "menubar", 0, 0);
/*
Widget tree :

mainW
  mainForm
    control
      buttons
      labels
    draw1
    sep1
    draw2  
*/
    mainForm = XmCreateForm(mainw, "mainForm", 0, 0);
    assert(mainForm);

    control = XmCreateDrawingArea(mainForm, "control", 0, 0);
    XtVaSetValues(control,
		  XmNleftAttachment, XmATTACH_FORM,
		  XmNbottomAttachment, XmATTACH_FORM,
		  XmNtopAttachment, XmATTACH_FORM,
		  0);
    XtManageChild(control);

    startB = XmCreatePushButton(control, "startB", 0, 0);
    XtVaSetValues(startB,
		  XmNx, 5,
		  XmNy, 5,
		  XmNwidth, 45,
		  XmNheight, 30,
		  0);
    XtAddCallback(startB, XmNactivateCallback, cbStart, this);
    pauseB = XmCreatePushButton(control, "pauseB", 0, 0);
    XtVaSetValues(pauseB,
		  XmNx, 55,
		  XmNy, 5,
		  XmNwidth, 45,
		  XmNheight, 30,
		  0);
    XtAddCallback(pauseB, XmNactivateCallback, cbPause, this);

    frameStatus = XmCreateFrame(control, "statusFrame", 0, 0);
    parentStatus = XmCreateDrawingArea(frameStatus, "statusParent", 0, 0);
    statusL1 = XmCreateLabel(parentStatus, "statusL1", 0, 0);
    XtVaSetValues(statusL1,
/*
		  XmNx, 5,
		  XmNy, 50,
		  XmNwidth, 90,
		  XmNheight, 20,
*/
		  0);
    statusL2 = XmCreateLabel(parentStatus, "statusL2", 0, 0);
    XtVaSetValues(statusL2,
/*
		  XmNx, 5,
		  XmNy, 70,
		  XmNwidth, 90,
		  XmNheight, 30,
*/
		  XmNrecomputeSize, False,
		  0);

    frameScore = XmCreateFrame(control, "scoreFrame", 0, 0);
    parentScore = XmCreateDrawingArea(frameScore, "scoreParent", 0, 0);
    linesL1 = XmCreateLabel(parentScore, "linesL1", 0, 0);
    XtVaSetValues(linesL1,
/*
		  XmNx, 5,
		  XmNy, 130,
		  XmNwidth, 90,
		  XmNheight, 40,
*/
		  XmNrecomputeSize, False,
		  0);
    scoreL1 = XmCreateLabel(parentScore, "scoreL1", 0, 0);
    XtVaSetValues(scoreL1,
/*
		  XmNx, 5,
		  XmNy, 110,
		  XmNwidth, 90,
		  XmNheight, 30,
*/
		  XmNrecomputeSize, False,
		  0);

    //
    // Text field used to type in a new keymap
    //
    mapFrame = XmCreateFrame(control, "mapFrame", 0, 0);
    mapParent = XmCreateDrawingArea(mapFrame, "mapFrame", 0, 0);
    mapL = XmCreateLabel(mapParent, "mapL", 0, 0);
    mapTF = XmCreateTextField(mapParent, "mapTF", 0, 0);
    {
       XtActionsRec actionTable[] = {
	  {"returnPressedMap", (XtActionProc) returnPressedMap},
       };
       XtAppAddActions(appContext,
		       actionTable, XtNumber(actionTable));
    }

    XtManageChild(mapL);
    XtManageChild(mapTF);

    XtOverrideTranslations(mapTF,
		  XtParseTranslationTable("<Key>Return: returnPressedMap()"));
    

    //
    // Text field used to type in the name
    //
    nameFrame = XmCreateFrame(control, "nameFrame", 0, 0);
    nameParent = XmCreateDrawingArea(nameFrame, "nameMap", 0, 0);
    nameL = XmCreateLabel(nameParent, "nameL", 0, 0);
    nameTF = XmCreateTextField(nameParent, "nameTF", 0, 0);
    {
       XtActionsRec actionTable[] = {
	  {"returnPressedName", (XtActionProc) returnPressedName},
       };
       XtAppAddActions(appContext,
		       actionTable, XtNumber(actionTable));
    }

    XtManageChild(nameL);
    XtManageChild(nameTF);

    XtOverrideTranslations(nameTF,
		  XtParseTranslationTable("<Key>Return: returnPressedName()"));

    XtVaSetValues(nameTF,
		  XmNvalue, getPrefs() -> myname,
		  0);

    XtManageChild(frameStatus); XtManageChild(parentStatus);
    XtManageChild(frameScore); XtManageChild(parentScore);
    XtManageChild(mapFrame); XtManageChild(mapParent);
    XtManageChild(nameFrame); XtManageChild(nameParent);
    XtManageChild(statusL1);
    XtManageChild(statusL2);
    XtManageChild(linesL1);
    XtManageChild(scoreL1);
    XtManageChild(startB);
    XtManageChild(pauseB);

    XtManageChild(mainForm);

    //
    // Menus
    //

    helpM = XmCreatePulldownMenu(menubar, "helpM", 0, 0);
    fileM = XmCreatePulldownMenu(menubar, "fileM", 0, 0);
    
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, fileM); n++;
    XtManageChild(XmCreateCascadeButton(menubar, "File", args, n));
//    XtManageChild(XmCreatePushButton(fileM, "Show", 0, 0));
    
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, helpM); n++;
    XtManageChild(tmp=XmCreateCascadeButton(menubar, "Help", args, n));
    XtVaSetValues(menubar, 
		  XmNmenuHelpWidget, tmp,
		  NULL);

/*
    XtManageChild(tmp=XmCreatePushButton(fileM, "open", 0, 0));
    XtManageChild(tmp=XmCreatePushButton(fileM, "save", 0, 0));
    XtManageChild(tmp=XmCreateSeparator(fileM, "s1", 0, 0));
*/
    XtManageChild(tmp=XmCreatePushButton(fileM, "Show high scores", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, cbShowHighScores, this);
    XtManageChild(tmp=XmCreatePushButton(fileM, "Quit", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, cbQuit, 0);

    XtManageChild(tmp=XmCreatePushButton(helpM, "About", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, cbDisplayAbout, this);
/*
    XtManageChild(tmp=XmCreatePushButton(helpM, "Version", 0, 0));
*/

    XtManageChild(menubar);
    XtManageChild(mainw);

    if (getPrefs() -> isCooperative) {
       boardHeight = 14;
/*
       boardWidth = 12;
*/
       boardWidth = 16;
       createCooperativeGame();
    }
    else {
       boardHeight = 14;
       boardWidth = 10;
       createNonCooperativeGame();
    }

    XtRealizeWidget(toplevel);
/*
    XtVaSetValues(control,
		  XmNresizePolicy, XmRESIZE_NONE,
		  0);
*/

   //
   // Initialize communicator interface
   //
   String rendezvousDisplay;
   if (getPrefs() -> isClient) {
      rendezvousDisplay = getPrefs() -> opponent;
      assert(rendezvousDisplay);
      board1 -> customSRand(getpid());
      communicator = new Communicator(rendezvousDisplay, False, this);
                                            // mode client
   }
   else {
      rendezvousDisplay = (char *) getenv("DISPLAY");
      assert(rendezvousDisplay);
      communicator = new Communicator(rendezvousDisplay, True, this);
                                            // mode server
   }

    if (getPrefs() -> isVerbose) {
       String s = communicator -> getProtIn() -> getConnectionStrings();
       cout << "I am " << s << endl;
       delete s;
    }
    //
    // If a display is given and I am server, fork a new instance
    //
    if (! getPrefs() -> isClient && argc >= 2) {
       String s = communicator -> getProtIn() -> getConnectionStrings();
       forkNewInstance(argv[1], s);
       delete s;
    }


    communicator -> getProtIn() -> wedgeIntoXtMainLoop(appContext);

//    setGameStatus(Board::GAME_PAUSED);

    timeoutId = 0;

    updateKeymap(_keymap);
}
