// $Id: mainWindow.cxx,v 1.7 1995/08/02 12:34:18 beust Exp beust $

//
// 1st part of the MainWindow implementation
//


#include "main.hxx"

#ifndef SEND_UDP_PACKET
extern "C" {
#include "spy.h"
}
#endif /* SEND_UDP_PACKET */

//////////////////////////////////////////////////////////////////////
// Static functions
//////////////////////////////////////////////////////////////////////



static Bool
timeoutNonCooperative(MainWindow *w)
{
   Board *boards[] = { w -> board1, w -> board2 } ;
   Bool result = False;   // is new line completed ?

   Board *board = w -> board1;
   if (board -> isActiveBlockValid()) {

      Block *block = board -> getActiveBlock();

      //
      // Move the block down one line if possible
      //
      if (board -> canMoveDown(*block)) {
	 board -> unmapBlock(*block); 
	 block -> moveDown();
	 board -> mapBlock(*block);
	 //
	 // Send new coordinates of my block to opponent,
	 // no need to check for line
	 //
	 w -> communicator -> sendBlockDefinition(*block, False);
      }
      else {
	 //
	 // Block reached bottom, send this block to the opponent and request
	 // that a checkForLine() be made
	 //
	 Cardinal status = board -> getGameStatus();
	 w -> communicator -> sendBlockDefinition(*block, True);
	 result = board -> addBlockToBoard(*block);
	 board -> invalidateActiveBlock();
	 //
	 // If status of the board changed, reflect it
	 // to the mainWindow. If board1's status changed,
	 // reflect its value to the mainWindow. If it's board2,
	 // invert it (if board2 wins, board1 loses and vice-versa)
	 //
	 if (status != board -> getGameStatus()) {
	    w -> setGameStatus(board -> getGameStatus());
	 }
	 delete block;

	 //
	 // Send my board content to the opponent
	 //
	 char *boardRep; Cardinal boardRepSize;
	 board -> getBoardRepresentation(boardRep, boardRepSize);
	 w -> communicator -> sendBytes(boardRep, boardRepSize);
	 delete [] boardRep;
	       
	 //
	 // Tell the opponent about my new block
	 //
	 board -> setActiveBlock(board -> getRandomBlock());
	       
	 int value = (board -> lastRandomBlock << 8) |
	    Communicator::STARTING_BLOCK;
	 w -> communicator -> sendValue(Communicator::Value(value));
	       
	 board -> mapBlock(*board -> getActiveBlock());
      } // block reached bottom
   } // isActiveBlockValid
   return result;

}

static Bool
timeoutCooperative(MainWindow *w)
{
   CooperativeBoard *board = (CooperativeBoard *) w -> board1;
   // ^^^ should used a dynamic_cast here
   Block *block = board -> getActiveBlock();
   Bool result = False;   // is new line completed ?


   //
   // Move activeBlock down one if possible.
   // If the activeBlock is blocked down by the other block, simply
   // wait and do nothing
   //
   if (board -> isActiveBlockBlocked()) {
      // do nothing
   }
   else if (board -> canMoveDown(*block)) {
      board -> unmapBlock(*block); 
      block -> moveDown();
      board -> mapBlock(*block);
      //
      // Send new coordinates of my block to opponent
      // no need to check for line
      //
      w -> communicator -> sendBlockDefinition(*block, False);
   }
   else {
      //
      // Remember current game status to see if it will change
      //
      Cardinal gs = board -> getGameStatus();
      //
      // Send this block to the opponent and request that a checkForLine()
      // be made
      //
      w -> communicator -> sendBlockDefinition(*block, True);
      result = board -> addBlockToBoard(*block);
      if (gs != board -> getGameStatus())
	 w -> setGameStatus(board -> getGameStatus());
      board -> invalidateActiveBlock();

      //
      // Send my board content to the opponent if I am not client
      // (the server is considered as the only authority)
      //
      if (! w -> getPrefs() -> isClient) {
	 char *boardRep; Cardinal boardRepSize;
	 board -> getBoardRepresentation(boardRep, boardRepSize);
	 w -> communicator -> sendBytes(boardRep, boardRepSize);
	 delete [] boardRep;
      }
/*
      else {
	 w -> communicator -> sendBlockDefinition(*block, False);
      }
*/
      delete block;

      //
      // Get myself a new block
      //
      Block *newBlock = board -> getRandomBlock();
      Cardinal startColumn;
      if (w -> getPrefs() -> isClient)
	 startColumn = board -> getWidth() * 2 / 3;
      else
	 startColumn = board -> getWidth() / 3;
      newBlock -> setDefaultColumn(startColumn);
      newBlock -> setCurrentColumn(startColumn);
      board -> setActiveBlock(newBlock);

      //
      // ... and send it to my opponent
      //
      int value = (board -> lastRandomBlock << 8) |
	 Communicator::STARTING_BLOCK;
      w -> communicator -> sendValue(Communicator::Value(value));
      board -> mapBlock(*board -> getActiveBlock());
   }

   return result;
}

void
cbTimeout(XtPointer client_data, XtIntervalId *id)
{
   MainWindow *w = (MainWindow *) client_data;
   Bool isNewLineCompleted = False;

   Board *board;
   Block *block;

   //
   // Check if this game is over
   //
   if (Board::GAME_LOST == w -> getGameStatus()) {
      w -> communicator -> sendValue(Communicator::GAME_IS_LOST);
      w -> board1 -> invalidateActiveBlock();
      w -> board1 -> invalidateOtherBlock();
      if (0 != w -> timeoutId) {
	 XtRemoveTimeOut(w -> timeoutId);
	 w -> timeoutId = 0;
      }
      return;
   }
   else if (Board::GAME_WON == w -> getGameStatus()) {
      if (0 != w -> timeoutId) {
	 XtRemoveTimeOut(w -> timeoutId);
	 w -> timeoutId = 0;
      }
      return;
   }
   

   //
   // Update the main board
   //
   if (Board::GAME_RUNNING == w -> getGameStatus()) {
      if (w -> getPrefs() -> isCooperative)
	 isNewLineCompleted = timeoutCooperative(w);
      else
	 isNewLineCompleted = timeoutNonCooperative(w);
   }

   //
   // If a new line was completed
   // . update the line counter
   // . see if it must cause an acceleration
   //
   int cLines = w -> board1 -> getCompletedLines();
   if (isNewLineCompleted) {

      {
	 char buf[64];
	 XmString xms;
	 sprintf(buf, "Lines : %d", w -> board1 -> getCompletedLines());
	 XtVaSetValues(w -> linesL1,
		       XmNlabelString, xms = XmStringCreateSimple(buf),
		       XmNwidth, 90,
		       XmNheight, 40,
		       0);
	 XmStringFree(xms);
      }

      if (cLines % ACCELERATION_THRESHOLD == 0 && w -> currentTimeout > 100) {
	 w -> currentTimeout = w -> currentTimeout * 2 / 3;
	 w -> communicator -> sendAccelerate(w -> currentTimeout);
      }
   }

//   if (Board::GAME_RUNNING == w -> getGameStatus()) {
      w -> timeoutId = XtAppAddTimeOut(w -> appContext, w -> currentTimeout,
				       cbTimeout, w);
//   }

}

//////////////////////////////////////////////////////////////////////
// Member functions
//////////////////////////////////////////////////////////////////////

void
MainWindow::reset(void)
{
   if (! getPrefs() -> isCooperative)
      board2 -> reset();
//   board1 -> invalidateOtherBlock();
   board1 -> reset();

   setGameStatus(Board::GAME_PAUSED);
   if (0 != timeoutId) {
      XtRemoveTimeOut(timeoutId);
      timeoutId = 0;
   }
   currentTimeout = INITIAL_TIMEOUT;
}

void
MainWindow::createNonCooperativeGame(void)
{
   draw1 = XmCreateDrawingArea(mainForm, "draw1", 0, 0);
   XtVaSetValues(draw1,
		 XmNleftAttachment, XmATTACH_WIDGET,
		 XmNleftWidget, control,
		 XmNbottomAttachment, XmATTACH_FORM,
		 XmNtopAttachment, XmATTACH_FORM,
		 XmNresizePolicy, XmRESIZE_NONE,
		 XmNwidth, boardWidth * BLOCKSIZE,
		 XmNheight, boardHeight * LINESIZE,
		 0);
   sep1 = XmCreateDrawingArea(mainForm, "sep1", 0, 0);
   XtVaSetValues(sep1,
		 XmNleftAttachment, XmATTACH_WIDGET,
		 XmNleftWidget, draw1,
		 XmNbottomAttachment, XmATTACH_FORM,
		 XmNtopAttachment, XmATTACH_FORM,
		 XmNresizePolicy, XmRESIZE_NONE,
		 XmNwidth, 15,
		 XmNheight, boardHeight * LINESIZE,
		 0);
   draw2 = XmCreateDrawingArea(mainForm, "draw2", 0, 0);
   XtVaSetValues(draw2,
		 XmNleftAttachment, XmATTACH_WIDGET,
		 XmNleftWidget, sep1,
		 XmNbottomAttachment, XmATTACH_FORM,
		 XmNtopAttachment, XmATTACH_FORM,
		 XmNresizePolicy, XmRESIZE_NONE,
		 XmNwidth, boardWidth * BLOCKSIZE,
		 XmNheight, boardHeight * LINESIZE,
		 0);

   XtManageChild(draw1);
   XtManageChild(sep1);
   XtManageChild(draw2);
   
   //
   // The boards
   //
   board1 = new Board(boardHeight, boardWidth,
		      draw1, boardWidth / 2,
		      getPrefs() -> is3D,
		      toplevel, getPrefs() -> myname,
		      getPrefs() -> highScoreFile);
   board2 = new Board(boardHeight, boardWidth,
		      draw2, boardWidth / 2, getPrefs() -> is3D,
		      toplevel, getPrefs() -> myname,
		      getPrefs() -> highScoreFile);
}

void
MainWindow::createCooperativeGame(void)
{
   draw1 = XmCreateDrawingArea(mainForm, "draw1", 0, 0);
   XtVaSetValues(draw1,
		 XmNleftAttachment, XmATTACH_WIDGET,
		 XmNleftWidget, control,
		 XmNbottomAttachment, XmATTACH_FORM,
		 XmNtopAttachment, XmATTACH_FORM,
		 XmNresizePolicy, XmRESIZE_NONE,
		 XmNwidth, boardWidth  * BLOCKSIZE,
		 XmNheight, boardHeight * LINESIZE,
		 0);
   XtManageChild(draw1);

   //
   // Create the board(d)
   // In a cooperative game, the activeBlock will be on the left
   // side or right side on start depending if we are client or server
   //

   assert(toplevel);
   if (getPrefs() -> isClient)
      board1 = new CooperativeBoard(boardHeight, boardWidth,
				    draw1, boardWidth * 2 / 3,
				    getPrefs() -> is3D,
				    toplevel,
				    getPrefs() -> myname,
				    getPrefs() -> highScoreFile);
   else
      board1 = new CooperativeBoard(boardHeight, boardWidth,
				    draw1, boardWidth / 3,
				    getPrefs() -> is3D,
				    toplevel,
				    getPrefs() -> myname,
				    getPrefs() -> highScoreFile);
   board2 = 0;
}

void
MainWindow::setGameStatus(Cardinal value)
{
   Cardinal gameStatus = _GameStatus = value;
   char *strStatus;

   //
   // A cooperative game is never won :)
   //
   if (Board::GAME_WON == gameStatus && getPrefs() -> isCooperative) {
      gameStatus = Board::GAME_LOST;
   }


   //
   // Set strStatus accordingly to the new status
   //
   switch(gameStatus) {
      case Board::GAME_RUNNING : {
	 strStatus = "Running";
      }
      break;
      case Board::GAME_LOST : {
	 strStatus = "Lost";
	 if (board1 -> getScore() -> saveScore()) {
	    // new high score
	 }
	 //
	 // Display the high scores
	 //
	 board1 -> getScore()
	    -> map(getPrefs() -> isCooperative, "YOU LOSE !!!", "Sigh");
      }
      break;
      case Board::GAME_WON : {
	 strStatus = "Won";
	 if (board1 -> getScore() -> saveScore()) {
	    // new high score
	 }

	 //
	 // Display the high scores
	 //

	 board1 -> getScore()
	    -> map(getPrefs() -> isCooperative, "YOU WIN !!!", "Rewl");


      }
      break;
      case Board::GAME_PAUSED : {
	 strStatus = "Paused";
      }
      break;
   }

   {
      XmString xms;
      //
      // Special case if the user is pausing or unpausing : I
      // must update the PushButton label as well
      //
      if (value == Board::GAME_PAUSED) {
	 xms = XmStringCreateSimple("Unpause");
      }
      else {
	 xms = XmStringCreateSimple("Pause");
      }
      XtVaSetValues(pauseB,
		    XmNlabelString, xms,
		    0);
      XmStringFree(xms);
   }

   //
   // Reflect the new status on the statusLabel
   //
   XmString xmsStatus;
   xmsStatus = XmStringCreateSimple(strStatus);
   XtVaSetValues(statusL2,
		 XmNlabelString, xmsStatus,
		 0);

   XmStringFree(xmsStatus);

}

Cardinal
MainWindow::getGameStatus(void)
{
   return _GameStatus;
}

MainWindow::~MainWindow()
{
   int i;
   delete board1;
   delete board2;
}

void
MainWindow::run()
{
   XEvent event;

   board1 -> drawBorders();
   if (! getPrefs() -> isCooperative) board2 -> drawBorders();

/*
   updateKeymap(_keymap);
*/
   while (1) {
      XtAppNextEvent(appContext, & event);
/*
      if (event.type == PropertyNotify)
	 isDispatched = communicator -> dispatchEvent(& event, this);
*/
      XtDispatchEvent(& event);
   }
}

void
MainWindow::moveRight()
{
   Block *block = board1 -> getActiveBlock();

   //
   // Must silently add the other block if cooperative, before testing
   //
   Bool isCooperativeOk = getPrefs() -> isCooperative &&
      board1 -> isOtherBlockValid();
   if (isCooperativeOk)
      board1 -> simpleAddBlockToBoard(*board1 -> getOtherBlock());

   if (board1 -> canMoveRight(*block)) {
      if (isCooperativeOk)
	 board1 -> simpleRemoveBlockFromBoard(*board1 -> getOtherBlock());
      board1 -> unmapBlock(*block);
      block -> moveRight();
      board1 -> mapBlock(*block);
      communicator -> sendBlockDefinition(*block, False);
   }
   else {
      if (isCooperativeOk)
	 board1 -> simpleRemoveBlockFromBoard(*board1 -> getOtherBlock());
   }
}

void
MainWindow::moveLeft()
{
   Block *block = board1 -> getActiveBlock();

   //
   // Must silently add the other block if cooperative, before testing
   //
   Bool isCooperativeOk = getPrefs() -> isCooperative &&
      board1 -> isOtherBlockValid();
   if (isCooperativeOk)
      board1 -> simpleAddBlockToBoard(*board1 -> getOtherBlock());

   if (board1 -> canMoveLeft(*block)) {
      if (isCooperativeOk)
	 board1 -> simpleRemoveBlockFromBoard(*board1 -> getOtherBlock());

      board1 -> unmapBlock(*block);
      block -> moveLeft();
      board1 -> mapBlock(*block);
      communicator -> sendBlockDefinition(*block, False);
   }
   else {
      if (isCooperativeOk)
	 board1 -> simpleRemoveBlockFromBoard(*board1 -> getOtherBlock());
   }
}

void
MainWindow::flipLeft()
{
   Block *block = board1 -> getActiveBlock();

   //
   // Must silently add the other block if cooperative, before testing
   //
   Bool isCooperativeOk = getPrefs() -> isCooperative &&
      board1 -> isOtherBlockValid();
   if (isCooperativeOk)
      board1 -> simpleAddBlockToBoard(*board1 -> getOtherBlock());

   if (board1 -> canFlipLeft(*block)) {
      if (isCooperativeOk)
	 board1 -> simpleRemoveBlockFromBoard(*board1 -> getOtherBlock());
      board1 -> unmapBlock(*block);
      block -> flipLeft();
      board1 -> mapBlock(*block);
      communicator -> sendBlockDefinition(*block, False);
   }
   else {
      if (isCooperativeOk)
	 board1 -> simpleRemoveBlockFromBoard(*board1 -> getOtherBlock());
   }
}

void
MainWindow::flipRight()
{
   Block *block = board1 -> getActiveBlock();
    //
   // Must silently add the other block if cooperative, before testing
   //
   Bool isCooperativeOk = getPrefs() -> isCooperative &&
      board1 -> isOtherBlockValid();
   if (isCooperativeOk)
      board1 -> simpleAddBlockToBoard(*board1 -> getOtherBlock());

   if (board1 -> canFlipRight(*block)) {
      if (isCooperativeOk)
	 board1 -> simpleRemoveBlockFromBoard(*board1 -> getOtherBlock());
      board1 -> unmapBlock(*block);
      block -> flipRight();
      board1 -> mapBlock(*block);
      communicator -> sendBlockDefinition(*block, False);
   }
   else {
      if (isCooperativeOk)
	 board1 -> simpleRemoveBlockFromBoard(*board1 -> getOtherBlock());
   }
}



void
MainWindow::fall()
{
   Block *block = board1 -> getActiveBlock();

   //
   //@@ mmh... will have to check if other's block is on the way
   //
   if (! block -> getIsFalling()) {
      //
      // Increment the score only if this block is not already
      // falling
      //
      block -> setIsFalling(True);
      Cardinal currentLine = board1 -> getHeight() - block -> getCurrentLine();
      board1 -> getScore() -> incrementScore(currentLine);
      communicator -> sendScoreIncrement(currentLine);
   }

   //
   // Fall the block until it reaches the bottom
   //
   while (board1 -> canMoveDown(*block)) {
      board1 -> unmapBlock(*block);
      block -> moveDown();
      board1 -> mapBlock(*block);
      communicator -> sendBlockDefinition(*block, False);
   }
   updateScoreLabel(board1 -> getScore() -> getScore());
}

void
MainWindow::updateScoreLabel(Cardinal newValue)
{
   char newLabel[128];
   XmString xms;
   sprintf(newLabel, "Score : %d", newValue);
   xms = XmStringCreateSimple(newLabel);
   XtVaSetValues(scoreL1,
		 XmNlabelString, xms,
		 0);
   XmStringFree(xms);
}

void
MainWindow::updateKeymap(char newKeymap[])
{
   XtTranslations xtTrans;
   char *actions[] = {
      "moveLeft()", "flipLeft()", "flipRight()", "moveRight()",
      "fall() "
   };
   char translations[1024], translation[256];
   
   strcpy(translations, "");
//   strcpy(translations, "#override ");
   for (int i=0; i < 5; i++) {
      if (' ' == newKeymap[i])
	 sprintf(translation, "<Key>space: %s\n ", actions[i]);
      else
	 sprintf(translation, "<Key>%c: %s\n ", newKeymap[i], actions[i]);
      strcat(translations, translation);
   }

   xtTrans = XtParseTranslationTable(translations);
   assert(xtTrans);
   XtOverrideTranslations(startB, xtTrans);

/*
   XtVaSetValues(control,
		 XmNtranslations, xtTrans,
		 0);
*/

   _keymap = strdup(newKeymap);
   XmTextFieldSetString(mapTF, _keymap);
}

void
MainWindow::forkNewInstance(String opponentDisplay, String myIceLocation)
{
   int newArgc = 0;
   String newArgv[10];
   newArgv[newArgc++] = _programName;

   if (! getPrefs() -> isClient) {
      newArgv[newArgc++] = "-client";
      newArgv[newArgc++] = "-opponent";
      newArgv[newArgc++] = myIceLocation;
   }

   newArgv[newArgc++] = "-display";
   newArgv[newArgc++] = opponentDisplay;

   if (getPrefs() -> isCooperative) {
      newArgv[newArgc++] = "-cooperative";
   }

   if (getPrefs() -> isVerbose) {
      newArgv[newArgc++] = "-verbose";
      cout << "Forking ";
      for (int i = 0; i < newArgc; i++) {
	 cout << newArgv[i] << " ";
      }
      cout << endl;
   }

   {
      pid_t pid;
      newArgv[newArgc++] = 0;
      pid = fork();
      switch (pid) {
	 case 0 : {
	    execvp(newArgv[0], (char * const *) newArgv);
	 }
         break;
      } // switch
   }
}

void
MainWindow::usage(void)
{
   cout << "Usage: " << _programName <<
      " [-cooperative] [-3d] [-highscore file] [-myname name] [opponent display]" <<
      endl;
   cout << "\t-cooperative\tStart cooperative game" << endl;
   cout << "\t-3d\t\tUse 3D blocks (nicer but slower)" << endl;
   cout << "\t-myname\t\tUse the supplied name for high scores" << endl;
   cout << "\t-highscore\tPath of the file that contains the high scores" << endl;
   exit(0);
}


