// $Id: main.hxx,v 1.3 1995/03/29 09:45:52 beust Exp beust $

#ifndef __MAIN_HXX__
#define __MAIN_HXX__

//
// X includes
//
#include <X11/Intrinsic.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/CascadeB.h>
#include <Xm/MainW.h>
#include <Xm/Form.h>
#include <Xm/DrawingA.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/Label.h>
#include <Xm/MessageB.h>
#include <Xm/Frame.h>

#include <X11/Xmu/Editres.h>

//
// C++ includes
//
#include <iostream.h>
#include <strstream.h>   // string streams
#include <iomanip.h>     // setw() and friends
#include <fstream.h>

//
// Standard C includes
//
#include <stdlib.h>    // srand()
#include <unistd.h>    // getpid()
#include <assert.h>
#ifdef __GNUC__
extern "C" {
#include<pwd.h>    // struct passwd
}
#endif

//
// Close your eyes...
//

#define ATTRIBUTE(_t, _a)\
private:\
   _t _##_a;\
public:\
   /* inline */ _t get##_a(void) { return _##_a; }\
   /* inline */ void set##_a(_t _v) { _##_a = _v; }

#define DEFINE_ATTRIBUTE(_t, _a)\
private:\
   _t _##_a;\
public:\
   /* inline */ _t get##_a(void);\
   /* inline */ void set##_a(_t _v)

#define PROTECTED_ATTRIBUTE(_t, _a)\
protected:\
   _t _##_a;\
public:\
   /* inline */ _t get##_a(void) { return _##_a; }\
   /* inline */ void set##_a(_t _v) { _##_a = _v; }

//
// ... now you can open your eyes
//


//
// ICE protocol library
//
#include "libprot/lp_lib.hxx"
#include "config/config.hxx"

// time between each call to the timeout function
static const int INITIAL_TIMEOUT = 500;

// number of lines between acceleration of blocks falls
static const int ACCELERATION_THRESHOLD = 10;

// miscellaneous block definitions
static const int BLOCKSIZE = 20;
static const int LINESIZE = BLOCKSIZE;
static const int AVAILABLE_BLOCKS_COUNT = 6;

// class name of my windows
static const char CLASS_NAME[] = "MultiTetris";

// default keymap
static const String DEFAULT_KEYMAP = "aspd ";

class MainWindow;
class Board;
class Block;

//////////////////////////////////////////////////////////////////////

extern MainWindow *MainWindow_g;  // main.cxx

typedef struct _Point {
   int x, y;
} PointRec, *Point;

#if 0
typedef enum { false = 0, true = 1 } bool;  // will need a #ifdef
#endif

//////////////////////////////////////////////////////////////////////

class Communicator
{
public:
   Communicator(const String rendezvousDisplay, Bool isServer, MainWindow *);
   const String MTETRIS_PROPERTY;
   typedef enum {
      VOID = 0,
      STARTING_BLOCK = 6,
      START_GAME = 7,
      GAME_IS_LOST = 8,
      PAUSE_GAME = 9,
      UNPAUSE_GAME = 10
   } Value;
   
   void sendValue(Value value) ;
   void sendName(String name) ;
   void sendAccelerate(CARD32 newTimeout) ;
   void sendBytes(char *bytes, Cardinal bytesCount) ;
   void sendBlockDefinition(Block & block, Bool mustCheckForLine) ;
   void sendScoreIncrement(Cardinal line) ;

   void receiveValue(Value value, MainWindow *mw);
   
   ATTRIBUTE(CProtocolOut *, ProtOut);
   ATTRIBUTE(CProtocolIn *, ProtIn);
   ATTRIBUTE(CDescProtocol *, ProtDesc);

private:
   void interpretValue(Value value, Board & bo, Block & bl, MainWindow *mw);
   Window _window;
   Display *_display;
};


//////////////////////////////////////////////////////////////////////

class BlockDefinition
{
public:
   BlockDefinition(PointRec *, int);
   PointRec coo[4];
   int height;
   BlockDefinition *clone(void);
};
   
class Block
{
public:
   Block(int column, char color);
   ~Block();   // not virtual on purpose
   Block *clone(int column);

   void flipLeft();
   void flipRight();
   void moveDown();
   void moveRight();
   void moveLeft();
   void fall(MainWindow *w, Board &board);
   void getCoordinates(int * & xCoo, int * & yCoo, Cardinal & count);
   void modify(int blockIndex, int orientation, int column, int line);

   DEFINE_ATTRIBUTE(int, CurrentLine);
   DEFINE_ATTRIBUTE(int, CurrentColumn);
   ATTRIBUTE(int, DefaultColumn);
   ATTRIBUTE(int, CurrentOrientation);
   ATTRIBUTE(char, Color);    // 1-7
   // set to true while block is falling, so as to block the score
   ATTRIBUTE(Boolean, IsFalling);
   PROTECTED_ATTRIBUTE(BlockDefinition **, AbsCoo);

protected:
   void updateCoordinates(void);
   String _name;

private:
   Cardinal _sizeOfBlock;
   int *_x;
   int *_y;
   // orientation : 0 up, 1 right, 2, down, 3 left
};


// blocks: L, T, Square S, Z, I
//////////////////////////////////////////////////////////////////////

class BlockT : public Block
{
public:
   BlockT(int column);
};

//////////////////////////////////////////////////////////////////////

class BlockL : public Block
{
public:
   BlockL(int column);
};

//////////////////////////////////////////////////////////////////////

class BlockSquare : public Block
{
public:
   BlockSquare(int column);
};

//////////////////////////////////////////////////////////////////////

class BlockZ : public Block
{
public:
   BlockZ(int column);
};

//////////////////////////////////////////////////////////////////////

class BlockS : public Block
{
public:
   BlockS(int column);
};

//////////////////////////////////////////////////////////////////////

class BlockI : public Block
{
public:
   BlockI(int column);
};

//////////////////////////////////////////////////////////////////////

class GraphicBoard
{
public:
   GraphicBoard(int height, int width, int blockSize, int lineSize,
		Widget parent, Bool want3D);
   void map(int x, int y, char color);
   void unmap(int x, int y);
   Widget widget(int x, int y);

private:
   Widget **_graphicBoard;
   int _h, _w;
   int _blockSize, _lineSize;
   Widget _parent;
};

//////////////////////////////////////////////////////////////////////

class Score
{
public:
   Score(String path, Bool isCooperativeGame,
	 String userName, String otherUserName = "");
   ~Score(void);
   void resetScore(void);
   void incrementScore (int lineNumber);
   // Return true if this score makes it into the high score list
   Bool saveScore(void);
   void getHighScores(char cooScores[], char nonCooScores[], size_t);

   ATTRIBUTE(Cardinal, Score);
   ATTRIBUTE(String, Path);
   ATTRIBUTE(String, UserName);
   ATTRIBUTE(String, OtherUserName);
   ATTRIBUTE(String, TeamName);
   ATTRIBUTE(Bool, IsCooperativeGame);

   // # of people we keep high scores for
   const Cardinal HIGH_SCORE_COUNT;

protected:

   // locking mechanism
   Bool lockFile(void);
   void unlockFile(void);
   //
   // internal form of the score
   //
public:
   typedef struct {
      char name[64];
      unsigned int score;
      unsigned int reserved[7];
   } *InternalScore_t, InternalScoreRec_t;

   ATTRIBUTE(InternalScoreRec_t *, CooScore);
   ATTRIBUTE(Cardinal, CooScoreCount);
   ATTRIBUTE(InternalScoreRec_t *, NonCooScore);
   ATTRIBUTE(Cardinal, NonCooScoreCount);
protected:
   void readInternalScore(void);
   Bool saveInternalScore(void);
   void addThisScore(void);
   void initTeamName(void);
};

class MotifScore : public Score
{
public:
   MotifScore(String path, Bool isCooperativeGame,
	      Widget topLevel,
	      String userName, String otherUserName = "");
   ~MotifScore(void);
   void map(Boolean isCooperative,
	    const String messageString = "",
	    const String labelString = "Ok") ;

private:
   Widget _topLevel, _infoMB, _formMB, _labelMB, _listMB;

};

//////////////////////////////////////////////////////////////////////

class Board
{
public:
   Board(int height, int width, Widget parent, int defaultColumn,
	 Bool want3D, Widget topLevel, String defaultName, String highScoreFile);
   virtual ~Board();

   GraphicBoard *graphicBoard;

   // remove all possible lines, return True if board must be redrawn
   void checkForLines(void);
   // is block(x,y) free ?
   Bool isFree(int x, int y);
   // map/unmap pieces
   void mapBlock(Block &block);
   void unmapBlock(Block &block);
   // end of game ?
   void checkForEnd(void);

   // Score
   PROTECTED_ATTRIBUTE(MotifScore *, Score);

   // Random number generation
   DEFINE_ATTRIBUTE(unsigned long, NextRand);
   unsigned int customRand(void);
   void customSRand(unsigned int seed);
   
   // Invalidate the activeBlock (used when it has reached the bottom
   // and we haven't received the new one from the opponent)
   virtual void invalidateActiveBlock();
   virtual Bool isActiveBlockValid();
   virtual Block *getActiveBlock(void);
   virtual void setActiveBlock(Block *);
   virtual void setActiveBlock(int blockIndex, int orientation,
			       int x, int y);

   virtual Block *getOtherBlock(void);
   virtual void setOtherBlock(Block *);
   virtual void setOtherBlock(int blockIndex, int orientation,
			       int x, int y);
   virtual void invalidateOtherBlock(void);
   virtual Bool isOtherBlockValid(void);

   // a block is at the bottom, update the board and check for end.
   // Return True if this block caused one (or more) line to be completed
   void simpleAddBlockToBoard(Block &block);
   void simpleRemoveBlockFromBoard(Block &block);
   virtual Bool addBlockToBoard(Block &block);

   // return a representation of the board suitable for send
   void getBoardRepresentation(char * & boardRep, Cardinal & size);
   // update the board with respect to the representation
   virtual void setBoardToRepresentation(void *boardRep, Cardinal size);

   virtual Bool canMoveRight(Block &block);
   virtual Bool canMoveLeft(Block &block);
   virtual Bool canMoveDown(Block &block);
   virtual Bool canFlipLeft(Block &block);
   virtual Bool canFlipRight(Block &block);

   void markAsOccupied(int x, int y, Block &block);
   void markAsFree(int x, int y, Block &block);
   int getHeight(void);    // to be inlined
   int getWidth(void);     // to be inlined
   Widget getParent(void);

   int getCompletedLines();
   void incrementCompletedLines(int n = 1);

   // graphical methods
   virtual void drawAll(void);
   virtual void drawBorders(void);
   virtual void drawContent(void);
   virtual void clearBoard(void);
   virtual void drawRest(void);

   // restore board in initial conditions
   virtual void reset(void);

//   void moveRight(void);

   // Block information
   Block *getRandomBlock(void);
   Block *getIndexBlock(int blockIndex);
   int lastRandomBlock;   // index of last returned random block
   // Each element contains a different block
   Block **availableBlocks;

   // Game status
   typedef enum {
      GAME_RUNNING = 1,
      GAME_LOST = 2,
      GAME_WON = 3,
      GAME_PAUSED = 4
   } GameStatus;

   virtual Cardinal getGameStatus(void) { return _gameStatus; }
   virtual void setGameStatus(Cardinal g)  { _gameStatus = g; }

   // debug methods
   void debugDisplay(void);  // debug
   int debugCountBlocks(void);

protected:
   typedef struct {
      Bool isFree;
      char color;    // 1 .. 7
   } BoardUnit;

   Block *_activeBlock;
   BoardUnit **_board;
   int _h, _w;
   Widget _parent;
   Bool _isActiveBlockValid;
   Bool _isOtherBlockValid;
   int _completedLines;
   Cardinal _gameStatus;

   void killLine(int line);
   Bool canMoveRight(void);
   Block *_otherBlock;

private:
//   void drawBlock(Block &block);
};

//////////////////////////////////////////////////////////////////////

class CooperativeBoard : public Board
{
public:
   CooperativeBoard(int height, int width, Widget parent,
		    int defaultColumn, Bool want3D,
		    Widget topLevel, String defaultName, String highScoreFile);

   virtual void drawRest(void);

   //
   // These must be redefined because they have to check possible
   // collision with the other block
   //
   Bool isActiveBlockBlocked(void);
   virtual Bool canFlipLeft(Block &block);
   virtual Bool canFlipRight(Block &block);
};

//////////////////////////////////////////////////////////////////////

class MainWindow
{
public:
   MainWindow(int argc, char **argv);
   ~MainWindow();
   void run(void);
   void moveRight(void);
   void moveLeft(void);
   void fall(void);
   void flipLeft(void);
   void flipRight(void);

   // ask for help
   void usage(void);

   // clean up boards for a new game
   void reset(void);
   // create the appropriate game windows
   void createCooperativeGame(void);
   void createNonCooperativeGame(void);
   // fork a new instance of myself
   void forkNewInstance(String opponentDisplay, String myIceLocation);
   // update the score label
   void updateScoreLabel(Cardinal newValue);

   // gameStatus
   DEFINE_ATTRIBUTE(Cardinal, GameStatus);

   int boardHeight, boardWidth;
   Board *board1, *board2;

   // Keymap defined by the player
   void updateKeymap(char newKeymap[]);
   char *_keymap;


   // Device to send information to other client
   Communicator *communicator;

   XtIntervalId timeoutId;

   XtAppContext appContext;
   Display *display;
   Widget toplevel, mainw, menubar;
   Widget fileM, helpM, file, help, mainForm, form;
   Widget draw1, sep1, draw2, control;
   Widget startB, pauseB;
   Widget frameStatus, parentStatus, statusL1, statusL2;
   Widget frameScore, parentScore, linesL1, linesL2;
   Widget scoreL1, scoreL2;
   Widget mapFrame, mapParent, mapL, mapTF;
   Widget nameParent, nameFrame, nameL, nameTF;
   Widget infoMB, formMB, listMB, labelMB;

   // timeouts (in ms)
   int currentTimeout;

//
// Holds the preferences set by the user
//
   typedef struct {
      Boolean isClient;
      Boolean isCooperative;
      Boolean isVerbose;		/* verbose mode: on / off */
      Boolean isHelp;
      Boolean is3D;
      int debug;			/* debug level: 0 means no debug. */
      Boolean isNopacket;
      char *myname;
      char *opponent;
      char *highScoreFile;
   } ParamRec, *Param;

   ATTRIBUTE(ParamRec *, Prefs);

private:
   String _programName;
   // update Status label
};


#endif /* __MAIN_HXX__ */
