// $Id: lp_message.cxx,v 1.1 1995/04/07 14:32:14 beust Exp beust $

#include <assert.h>
#include "lp_lib.hxx"

CMessage::CMessage(CARD32 opCode, CDescField **fields, Cardinal fieldsCount)
   : _opCode(opCode), _fieldsCount(fieldsCount)
{
   _fields = new CDescField * [_fieldsCount];
   for (int i = 0; i < _fieldsCount; i++) {
      _fields[i] = fields[i];
   }

}

CMessage::~CMessage()
{
   delete [] _fields;
}

CFieldValue *
CMessage::locateField(const String fieldName) const
{
   int n = getFieldsCount();
   CDescField **thisFields = getFields();
   for (int i = 0; i < n; i++) {
      if (0 == strcmp(thisFields[i] -> _fieldName, fieldName))
	 return thisFields[i] -> _cfv;
   }

   return 0;
}

void
CMessage::setField(const String argName, const void *buffer, size_t bufferSize)
{
   CFieldValue *cfv = locateField(argName);
   if (0 != cfv) {
      assert(! cfv -> isNum());
      char *bytesValue = new char [bufferSize];
      memcpy(bytesValue, buffer, bufferSize);
      cfv -> set(bytesValue, bufferSize);
   }
   else {
      cout << "bytes arg " << argName << " not found" << endl;
   }
}

void
CMessage::setField(const String argName, CARD32 value)
{
   CFieldValue *cfv = locateField(argName);
   if (0 != cfv) {
      assert(cfv -> isNum());
      cfv -> set(value);
   }
   else {
      cout << "num arg " << argName << " not found" << endl;
   }
}

void
CMessage::getField(const String fieldName, CARD32 &value) const
{
   CFieldValue *cfv = locateField(fieldName);
   assert(cfv);
   assert(cfv -> isNum());
   value = cfv -> numValue();
}

void
CMessage::getField(const String fieldName, void * & buffer,
		   size_t &bufferSize) const
{
   CFieldValue *cfv = locateField(fieldName);
   assert(cfv);
   assert(! cfv -> isNum());
   buffer  = cfv -> bytesValue();
   bufferSize = cfv -> getSize();
}


CARD32
CMessage::getOpCode(void) const
{
   return _opCode;
}

CMessage *
CMessage::clone(void) const
{
   CMessage *result = new CMessage;

   result -> _opCode = _opCode;
   result -> _fieldsCount = _fieldsCount;
   result -> _fields = new CDescField * [_fieldsCount];
   for (int i = 0; i < _fieldsCount; i++) {
      result -> _fields[i] = _fields[i] -> clone();
   }

   return result;
}

ostream &
operator<<(ostream &os, CMessage &msg)
{
   cout << "CMessage: opCode " << msg._opCode << ", "
	<< msg._fieldsCount << " fields: ";

   for (int i = 0; i < msg._fieldsCount; i++) {
      cout << *msg._fields[i] << " ";
   }
   cout.flush();
   
   return os;
}


