/*
 *
 * $Id: lp_lib.hxx,v 1.2 1995/04/07 14:32:14 beust Exp beust $
 */

#ifndef __LP_LIB_HXX__
#define __LP_LIB_HXX__
//
// STL
//
#if 0
#include <stl/map.h>
#include <stl/function.h>
#include <stl/vector.h>
#endif


#include <iostream.h>

extern "C" {
#include <stddef.h>     /* size_t */
#include <string.h>
#include <sys/types.h>      /* fd_set */
#include <sys/time.h>      /* struct timeval */
#include <X11/Xproto.h>
#include <X11/Intrinsic.h>
#include <X11/ICE/ICE.h>
#include <X11/ICE/ICElib.h>
#include <X11/ICE/ICEconn.h>
#include <X11/ICE/ICEmsg.h>
#include <X11/ICE/ICEproto.h>
#include <X11/ICE/ICEutil.h>
}

static const Cardinal MAX_CONNECTIONS = 20;


///////////////////////////////////////////////////////////////////////////
// CFieldValue
//
// This class is used to hold one of the two possible values of an
// argument :
// . a CARD32 : use the ctor CFieldValue(CARD32)
// . bytes : use the ctor CFieldValue(char *, size_t)

class CFieldValue
{
public:
   CFieldValue(CARD32 n) : _n(n), _size(sizeof(CARD32)), _isNum(True) {}
   CFieldValue(char s[], size_t size) : _s(s), _size(size), _isNum(False) {}
   ~CFieldValue() {}
   Boolean isNum(void) const { return _isNum; }
   void set(CARD32 n) { _n = n; }
   void set(char s[], size_t size) { _size = size; _s = s; }
   CARD32 numValue() { return _n; }
   String bytesValue() { String result = new char [_size];
                         memcpy(result, _s, _size); return result; }
   size_t getSize() const { return _size; }
//   CFieldValue *clone(void) const { return new CFieldValue(isNum() ? CFieldValue(_n) : CFieldValue(_s, _size)); }
   CFieldValue *clone(void) const { if (isNum()) return new CFieldValue(_n);
                                       else return new CFieldValue(_s, _size); }
   friend ostream &operator << (ostream &os, CFieldValue &cfv);

private:
   CARD32 _n;
   char * _s;
   size_t _size;
   Boolean _isNum;
};

///////////////////////////////////////////////////////////////////////////
// CDescField
//
// Private definition

typedef struct _CDescField
{
   _CDescField(String f, CFieldValue *d) : _fieldName(f), _cfv(d -> clone()) {}
   ~_CDescField() { delete _cfv; }
   struct _CDescField *clone(void) const {
                 return new _CDescField(_fieldName, _cfv -> clone());  }
   String _fieldName;
   CFieldValue *_cfv;
} CDescField;

ostream &operator << (ostream &os, CDescField &cfv);

///////////////////////////////////////////////////////////////////////////
// CMessage
//
// Main class to create a message
// Creation of a message is performed by supplying a set of descriptions
//   for each field of the message and tagging the message with an opcode.
// Once the message is created, its fields can be set with setField() and
//   read with getField().

class CMessage 
{
public:

   CMessage(CARD32 opCode, CDescField **df, Cardinal fieldCount);
   ~CMessage();
   void setField(const String fieldName, CARD32 value);
   void setField(const String fieldName, const void *buffer,
		 size_t bufferSize);
   void getField(const String fieldName, CARD32 &value) const;
   // The returned buffer must *not* be modified, nor freed
   void getField(const String fieldName, void * & buffer,
		 size_t &bufferSize) const;
   CARD32 getOpCode(void) const;
   CMessage *clone(void) const;
   friend ostream &operator << (ostream &os, CMessage &msg);
   CDescField **getFields() const { return _fields; }
   Cardinal getFieldsCount() const { return _fieldsCount; }

protected:
   CMessage(void) {}    // clone constructor

private:

//   friend CProtocolOut;
   class CDescProtocol;
   class CCoding;
   friend CDescProtocol;
   friend CCoding;
   CARD32 _opCode;

   CFieldValue *locateField(const String fieldName) const;
   CDescField **_fields;
   Cardinal _fieldsCount;
};

///////////////////////////////////////////////////////////////////////////
// CDescPacket
//
// A CDescPacket is a CMessage that has been received (i.e. that has been
//   sent to us by another client). Its only difference with a CMessage
//   is an additional virtual member function handle() that performs
//   the operation requested on receipt of this message.

class CDescPacket : public CMessage
{
public:
   CDescPacket(CARD32 opCode, CDescField **df, Cardinal fieldCount);
//   virtual void handle(void) = 0;
   CDescPacket *clone(void) const { CDescPacket *result;
                                    cout << "CDescPacket:: clone()" << endl;
                                      return new CDescPacket(getOpCode(),
							   getFields(),
							   getFieldsCount()); }

   virtual void handle(void) { cerr << "ERROR: virtual handle called" << endl; }

protected:
   CDescPacket(CMessage *msg) : CMessage(){}   // clone constructor

private:
};



///////////////////////////////////////////////////////////////////////////
// CDescProtocol
//
// A CDescProtocol is a set of CDescPacket. The whole set defines a
//   protocol. Once a protocol is create, you can use the messageKit()
//   factory function to create the different messages from this
//   protocol
//
// Notes : this class uses the Factory design pattern

class CDescProtocol
{
public:
    CDescProtocol(CDescPacket *cdp[], Cardinal msgCount);
    ~CDescProtocol();

    // Create a new message
    CMessage *messageKit(CARD32 opCode);
    CDescPacket **getMessages(void) const;

private:
   CDescPacket **_messages;
   Cardinal _messagesCount;
};


///////////////////////////////////////////////////////////////////////////
// CCoding
//
// CCoding is responsible for encoding and decoding a CMessage in
//   a way that doesn't depend on the architecture (no little/big
//   endian considerations). The two virtual functions encode()/decode()
//   can be derived and redefined if another coding is desired. The
//   default coding is to reorder all CARD32 entities with high byte
//   first (see CCoding::encodeCARD32 in lp_protocols.cxx)

class CCoding
{
public:
   CCoding() {}

   // Encode msg into the buffer outBuffer (must be allocated)
   // Return the size of the buffer
   virtual size_t encode(const CMessage *msg, char *outBuffer);

   // Decode the supplied buffer using the pattern msg
   virtual CDescPacket *decode(CDescPacket *msg, const char *inBuffer);

private:
   CARD32 decodeCARD32(const char *pt);
   void encodeCARD32(CARD32 n, char *pt);

};

///////////////////////////////////////////////////////////////////////////
// CProtocolOut
//
// Use an instance of this class to send a message. The ctor
//   must be given a protocol description (CDescProtocol).
// The message coding can be dynamically changed after creation
//   with the member function setCoding()

class CProtocolOut
{
public:   

   CProtocolOut(CDescProtocol &protDesc,
		const String recipient,
		const String protocolName = "libprot",
		const String protocolVendor = "Bull",
		const String protocolRelease = "1");

   void send(CMessage *msg);
//   void setCallback(CARD32 opCode, void (*callback)());
   int getFileNumber(void) const;    // to be inlined
   IceConn getIceConn(void) const;    // to be inlined
   int getProtocol(void) const;    // to be inlined
   void setCoding(CCoding *coding);

private:

   IceConn _iceConn;
   int _iceProtocol;
   CDescProtocol &_protDesc;
   const char *_recipient;
   CCoding *_coding;
};

///////////////////////////////////////////////////////////////////////////
// CProtocolIn
//
// Use an instance of this class to handle incoming messages.The ctor
//   must be given a protocol description (CDescProtocol).
// The message decoding can be dynamically changed after creation
//   with the member function setCoding().
// If X Window is being used, use wedgeIntoXtMainLoop(), and then
//   call XtMainLoop().
// Otherwise, dispatch() is a never-returning function that will
//   handle automatically incoming messages and dispatch them appropriately

class CProtocolIn
{
public:
   CProtocolIn(CDescProtocol &protDesc,
	       const String protocolName = "libprot",
	       const String protocolVendor = "Bull",
	       const String protocolRelease = "1");
   void mainLoop(void);
   void dispatch(int ready, fd_set *fds);

   CDescProtocol & getProtocolDescription(void) const;
   void setCoding(CCoding *coding);
   String getConnectionStrings(void) const;
   CDescPacket *decode(CDescPacket *msg, const char *inBuffer);
   void wedgeIntoXtMainLoop(XtAppContext appContext);
   friend ostream & operator << (ostream &, CProtocolIn &);

private:

   friend void inFileDescriptorReady(XtPointer, int *, XtInputId *);
   void addConnection(IceConn newConn);
   void removeConnection(IceConn newConn);

   CDescProtocol &_protDesc;

   IceConn _openConnections[MAX_CONNECTIONS];
   Cardinal _openConnectionsCount;

   IceConn _iceConn;
   int _iceProtocol;

   IceConn _newConn;
   XtInputId _newConnInputId;
   XtInputId _inputIds[MAX_CONNECTIONS];
   IceListenObj *_obj;
   int _objCount;

   CCoding *_coding;

   XtAppContext _appContext;
};

///////////////////////////////////////////////////////////////////////////
// Private definitions
///////////////////////////////////////////////////////////////////////////





#endif /* __LP_LIB_H__ */
