// $Id: libprotocol.cxx,v 1.1 1995/04/07 14:32:14 beust Exp $

#ifndef __LIBPROTOCOL_HXX__
#define __LIBPROTOCOL_HXX__

#include "lp_lib.hxx" 

#define PVENDOR "Bull"
#define PNAME "ktalk"
#define PRELEASE "1"

///////////////////////////////////////////////////////////////////////////

class CDescPacket1 : public CDescPacket
{
private:
   static CDescField *fields[];
public:
   CDescPacket1() : CDescPacket(0, fields, 2) {}
   virtual void handle()
   {
      cout << "handling opcode 0" << endl;
      cout << *this << endl;
   }
};

CDescField *CDescPacket1::fields[] = {
   new CDescField("krlId", new CFieldValue(42)),
   new CDescField("op", new CFieldValue("operation", strlen("operation")))
};

///////////////////////////////////////////////////////////////////////////

class CDescPacket2 : public CDescPacket
{
private:
   static CDescField *fields[];
public:
   CDescPacket2() : CDescPacket(1, fields, 1) {}
   virtual void handle()
   {
      cout << "handling opcode 1" << endl;
      CARD32 moveValue;
      getField("move", moveValue);
      cout << "received moveValue = " << moveValue << endl;
   }
};
CDescField *CDescPacket2::fields[] = {
   new CDescField("move", new CFieldValue(16))
};

CDescPacket *MyProtocol[] = {
   new CDescPacket1,
   new CDescPacket2
};



#endif /* __LIBPROTOCOL_HXX__ */
