// $Id: graphicBoard.cxx,v 1.1 1995/03/29 09:45:52 beust Exp beust $

#include "main.hxx"


GraphicBoard::GraphicBoard(int width, int height,
			   int blockSize, int lineSize,
			   Widget parent, Bool want3D)
   : _w(width), _h(height), _blockSize(blockSize), _lineSize(lineSize),
     _parent(parent)
{

   Widget w;
   int x, y;
   // allocate
   _graphicBoard = new Widget * [_w];
   for (x = 0; x < _w; x++)
      _graphicBoard[x] = new Widget[_h];
   
   for (x = 0; x < _w; x++) {
      for (y = 0; y < _h; y++) {
	 if (want3D)
	    w = XmCreatePushButton(_parent, "", 0, 0);
	 else
	    w = XmCreateLabel(_parent, "", 0, 0);
//	 w = XtCreateWidget("", xmPushButtonGadgetClass, _parent, 0, 0);
	 _graphicBoard[x][y] = w; 
	 XtVaSetValues(w,
		       XmNwidth, blockSize - (want3D ? 0 : 2),
		       XmNheight, blockSize - (want3D ? 0 : 2),
		       XmNx, x * blockSize,
		       XmNy, y * lineSize,
		       XmNmappedWhenManaged, False,
		       0);
	 XtManageChild(w);
      }
   }
}

void
GraphicBoard::map(int x, int y, char color)
{
   char *strTypeReturn, *strColor;
   XrmValue valueReturn, valueReturn2;

/*
   assert(x >= 0 && x < _h);
   assert(y >= 0 && y < _w);
*/

   Widget w = _graphicBoard[x][y];
   {
      // I use the parent just in case w is a gadget...
      XrmDatabase db = XtDatabase(XtDisplay(XtParent(w)));
      char strResource[32];
      sprintf(strResource, "%s.colorBlock%d", CLASS_NAME, color);
      XrmGetResource(db, strResource, strResource,
		     & strTypeReturn, & valueReturn);
      if (valueReturn.addr) {
	 strColor = (char *) valueReturn.addr;
      }
      else {
	 cerr << "couldn't find resource " << strResource
	      << "." << endl << "Did you install the application-defaults file ?"
	      << endl;
	 strColor = "grey";
      }
   }
   XtVaSetValues(w,
		 XtVaTypedArg, XmNbackground, XtRString,
		 strColor, strlen(strColor),
		 0);
   XtMapWidget(w);
}

void
GraphicBoard::unmap(int x, int y)
{
   XtUnmapWidget(_graphicBoard[x][y]);
}

Widget
GraphicBoard::widget(int x, int y)
{
   return _graphicBoard[x][y];
}
