// $Id: board.cxx,v 1.2 1995/03/29 09:45:52 beust Exp beust $

//
// The board is represented by two units :
// the Board itself, which

#include "main.hxx"

// ctor
Board::Board(int h, int w, Widget parent, int defaultColumn,
	     Bool want3D, Widget topLevel, String defaultName,
	     String highScoreFile)
   : _isActiveBlockValid(False), _completedLines(0), _gameStatus(GAME_PAUSED),
     _otherBlock(0), _isOtherBlockValid(False)
{
   int x, y;
//   _h = h + 1; _w = w + 2;
   _h = h + 1; _w = w + 1;
   _parent = parent;

   //
   // Initialize the map
   //
//   _board = (BoardUnit **) malloc(_w * sizeof(BoardUnit**));   // @@ remove that
   _board = new BoardUnit * [_w];
   for (x = 0; x < _w; x++)
//      _board[x] = (BoardUnit *) malloc(_h * sizeof(BoardUnit*));
      _board[x] = new BoardUnit [_h];
   

   // mark everything free
   for (x = 0; x < _w; x++)
      for (int y = 0; y < _h; y++) {
	 _board[x][y].isFree = True;
      }

#ifdef WANT_BORDERS
   // mark borders occupied
   for (y = 0; y < _h; y++) {
      _board[0][y].isFree = False;
      _board[0][y].color = 7;
      _board[_w - 1][y].isFree = False;
      _board[_w - 1][y].color = 7;
      
   }
   for (x = 0; x < _w; x++) {
      _board[x][_h - 1].isFree = False;
      _board[x][_h - 1].color = 7;
   }
#endif

   // Initialize score
   {
      struct passwd *pwd;
      pwd = getpwuid(getuid());
      _Score = new MotifScore(highScoreFile,
			      False,    // non cooperative
			      topLevel,
			      defaultName, "");
/*
      _Score =  (MotifScore *)  new Score(DEFAULT_HIGH_SCORE_FILE, False,
			 pwd -> pw_name, "<nobody>");
      {
	    char s1[4096], s2[4096];
	    getScore() -> getHighScores(s1, s2, sizeof(s1));
	    cout << "mainW:: highscores :" << endl
	       << s1 << endl
	       << "=----=" << endl
	       << s2 << endl;
	 }
*/
   }

    //
    // Initialize the available blocks
    //
    int i = 0;
    availableBlocks = new Block * [AVAILABLE_BLOCKS_COUNT];
    availableBlocks[i++] = new BlockT(defaultColumn);
    availableBlocks[i++] = new BlockL(defaultColumn);
    availableBlocks[i++] = new BlockSquare(defaultColumn);
    availableBlocks[i++] = new BlockZ(defaultColumn);
    availableBlocks[i++] = new BlockS(defaultColumn);
    availableBlocks[i++] = new BlockI(defaultColumn);
    assert(i == AVAILABLE_BLOCKS_COUNT);

   
   graphicBoard = new GraphicBoard(_w, _h, BLOCKSIZE, LINESIZE,
				   parent, want3D);

//   customSRand(getpid());
   setActiveBlock(getRandomBlock());
   invalidateOtherBlock();

}

Board::~Board()
{
   for (int i = 0; i < AVAILABLE_BLOCKS_COUNT; i++)
      delete availableBlocks[i];
   delete _Score;
/*
   for (int i = 0; i < _h; i++)
      delete [] _board[i];
   delete [] _board;
*/
}

void
Board::debugDisplay(void)
{
   cout << "\t";
   for (int i = 0; i < _w; i++)
      cout << i % 10;
   cout << endl;
   for (int y = 0; y < _h; y++) {
      cout << y << "\t";
      for (int x = 0; x < _w; x++) {
	 if (_board[x][y].isFree)
	    cout << " ";
	 else {
	    if (_board[x][y].color == 7) cout << "O";
	    else cout << "+";
	 }
      }
      cout << endl;
   }
}

int
Board::debugCountBlocks()
{
   int result = 0;
   for (int y = 0; y < _h - 1; y++) {
      for (int x = 0; x < _w; x++) {
	 if (! _board[x][y].isFree) result++;
      }
   }

   return result;
}

Bool
Board::isFree(int x, int y)
{
   if (x < 0 || x >= _w - 1  || y >= _h)
      return False;
   else
      return _board[x][y].isFree;
}

int
Board::getHeight(void)
{
   return _h;
}

int
Board::getWidth(void)
{
   return _w;
}

Widget
Board::getParent(void)
{
   return _parent;
}

void
Board::drawAll()
{
   drawBorders();
   drawContent();
}

void
Board::drawContent()
{
   Widget pb;

   int x, y;
   int j, i;

   for (y = 0; y < _h; y++) {
      for (x = 0; x < _w; x++) {
	 if (! isFree(x, y)) {
	    graphicBoard -> map(x, y, _board[x][y].color);
	 }
	 else {
	    graphicBoard -> unmap(x, y);
	 }
      }
   }

   drawRest();
}

void
Board::drawBorders()
{
#ifdef WANT_BORDERS
   for (int y = 0; y < _h; y++) {
      graphicBoard -> map(0, y, _board[0][y].color);
      graphicBoard -> map(_w - 1, y, _board[_w-1][y].color);
   }
   for (int x = 0; x < _w; x++)
      graphicBoard -> map(x, _h - 1, _board[x][_h-1].color);
#endif
}

void
Board::drawRest()
{
}

void
Board::clearBoard(void)
{
   // Clear the board and its internal representation
   for (int x = 0; x < _w; x++) {
      for (int y = 0; y < _h; y++) {
	 _board[x][y].isFree = True;
	 graphicBoard -> unmap(x, y);
      }
   }

#if 0
   // ... and clear the graphic representation
   for (int z = 0; z < _w - 2; z++) {
      for (int t = 0; t < _h - 1; t++) {
	 graphicBoard -> unmap(z, t);
      }
   }
#endif
}


void
Board::markAsOccupied(int x, int y, Block &block)
{
   _board[x][y].isFree = False;
   _board[x][y].color = block.getColor();
//   graphicBoard -> map(x, y, block.getColor());
//   mapBlock(block);
}

void
Board::markAsFree(int x, int y, Block &block)
{
   _board[x][y].isFree = True;
//   graphicBoard -> map(x, y, block.getColor());
}

void
Board::checkForLines(void)
{
   int x, y;
   Bool foundHole, redrawNeeded = False;

   for (y = 0; y < _h; y++) {
      foundHole = False;
      x = 0;
      while (! foundHole && x < _w) {
	 if (isFree(x, y)) {
	    foundHole = True;
	 }
	 x++;
      }
      if (! foundHole) {
	 incrementCompletedLines();
	 killLine(y);
	 redrawNeeded = True;
      }
   }

   if (redrawNeeded)
      drawContent();
}

void
Board::killLine(int line)
{
   int y, x;

   // shift all lines
   for (y = line; y >= 0; y--) {
      for (x = 0; x < _w; x++) {
	 _board[x][y] = _board[x][y - 1];  // @@ inefficient, use a _height attr
      }
   }
   // mark first line as all free 
   for (x = 0; x < _w; x++)
      _board[x][0].isFree = True;


#ifdef DEBU
#define IsMapped(_w) (XtWindow(_w) != None)
   {
      Widget w; Bool isMapped;
      for (int y = 0; y < _h - 1; y++) {
	 for (int x = 1; x < _w - 1; x++) {
	    w = graphicBoard -> widget(x, y);
	    isMapped = IsMapped(w);
	    if ((isMapped && _board[x][y].isFree) ||
		(! isMapped && ! _board[x][y].isFree)) {
	       cerr << "ERROR IN BOARD REPRESENTATION" << endl;
	    }
	 }
      }
   }
#undef IsMapped
#endif
}

void
Board::unmapBlock(Block &block)
{
   int *x, *y;
   Cardinal count;
   block.getCoordinates(x, y, count);

   for (int i = 0; i < count; i++) {
      graphicBoard -> unmap(x[i], y[i]);
   }
}

void
Board::mapBlock(Block &block)
{
   int *x, *y;
   Cardinal count;
   block.getCoordinates(x, y, count);

   for (int i = 0; i < count; i++) {
      graphicBoard -> map(x[i], y[i], block.getColor());
      // subtract 1 to x because the graphic representation has
      // no borders
   }
}

Bool
Board::canMoveDown(Block &block)
{
   int *x, *y;
   Cardinal count;
   block.getCoordinates(x, y, count);

   for (int i = 0; i < count; i++) {
      if (! isFree(x[i], y[i] + 1)) return False;
   }
   return True;
}

Bool
Board::canMoveRight(Block &block)
{
   int *x, *y;
   Cardinal count;
   block.getCoordinates(x, y, count);

   for (int i = 0; i < count; i++) {
      if (! isFree(x[i] + 1, y[i])) return False;
   }
   return True;
}

Bool
Board::canMoveLeft(Block &block)
{
   int *x, *y;
   Cardinal count;
   block.getCoordinates(x, y, count);

   for (int i = 0; i < count; i++) {
      if (! isFree(x[i] -1, y[i])) return False;
   }
   return True;

}

Bool
Board::canFlipLeft(Block &block)
{
   int newOrientation = (block.getCurrentOrientation() + 1) % 4;
   BlockDefinition *bd = block.getAbsCoo() [newOrientation];
   int newLine, newColumn;
   Bool result = True;
   int i;

   // totally inefficient algorithm
   for (i=0; i < 4; i++) {
      newColumn = block.getCurrentColumn() + bd -> coo[i].x;
      newLine = block.getCurrentLine() + bd -> coo[i].y;
      if (! isFree(newColumn, newLine))
	 return False;
   }
   return result;
}

Bool
Board::canFlipRight(Block &block)
{
   int co = block.getCurrentOrientation();
   int newOrientation = (co == 0 ? 3 : co - 1);
   BlockDefinition *bd = block.getAbsCoo() [newOrientation];
   int newLine, newColumn;
   Bool result = True;
   int i;

   // totally inefficient algorithm
   for (i=0; i < 4; i++) {
      newColumn = block.getCurrentColumn() + bd -> coo[i].x;
      newLine = block.getCurrentLine() + bd -> coo[i].y;
      if (! isFree(newColumn, newLine))
	 return False;
   }
   return result;
   
}

void
Board::simpleAddBlockToBoard(Block &block)
{
   int *x, *y;
   Cardinal count;
   block.getCoordinates(x, y, count);

   for (int i = 0; i < count; i++) {
      markAsOccupied(x[i], y[i], block);
   }
}

void
Board::simpleRemoveBlockFromBoard(Block &block)
{
   int *x, *y;
   Cardinal count;
   block.getCoordinates(x, y, count);

   for (int i = 0; i < count; i++) {
      markAsFree(x[i], y[i], block);
   }
}

Bool
Board::addBlockToBoard(Block &block)
{
   simpleAddBlockToBoard(block);
   checkForEnd();

   int previousCompletedLines = getCompletedLines();
   checkForLines();

//   debugDisplay();

   if (previousCompletedLines != getCompletedLines())
      return True;
   else
      return False;
}

Block *
Board::getRandomBlock(void)
{
   lastRandomBlock = customRand() % AVAILABLE_BLOCKS_COUNT;
   return availableBlocks[lastRandomBlock] -> clone(_w / 2);
}

Block *
Board::getIndexBlock(int blockIndex)
{
   return availableBlocks[blockIndex] -> clone(_w / 2);

}

void
Board::checkForEnd(void)
{
   for (int i = 1; i < _w - 1; i++)
      if (! _board[i][0].isFree) {
	 _gameStatus = GAME_LOST;
	 break;
      }

}

void
Board::getBoardRepresentation(char * & boardRep, Cardinal & size)
{
   size = _h * _w;
   char *result = new char [size];
   char *presult = result;
   
   for (int x = 0; x < _w; x++) {
      for (int y = 0; y < _h; y++) {
	 *presult++ = (_board[x][y].isFree ? 0 : _board[x][y].color);
      }
   }
   boardRep = result;
}

void
Board::setBoardToRepresentation(void *boardRep, Cardinal size)
{
   char *presult = (char *) boardRep;
   Bool redrawNeeded = False;

   if (size != _w * _h) {
      cerr << "ERROR: mismatch in board sizes !!!" << endl;
      cerr << "       NEW_BOARD packet ignored" << endl;
   }
   else {
      for (int x = 0; x < _w; x++) {
	 for (int y = 0; y < _h; y++) {
	    char value = (isFree(x, y) ? 0 : _board[x][y].color);
	    //
	    // Value of zero means : this block is free
	    // otherwise, it's a color
	    //
	    if ((0 == value && ! isFree(x, y)) ||
		(value != *presult)) {
	       redrawNeeded = True;
	       if (0 == *presult)
		  _board[x][y].isFree = True;
	       else {
		  _board[x][y].isFree = False;
		  _board[x][y].color = *presult;
	       }
	    }
	    presult++;
	 }
      }
   }

   if (redrawNeeded)
      drawContent();
}

void
Board::invalidateActiveBlock()
{
   _isActiveBlockValid = False;
}

Bool
Board::isActiveBlockValid()
{
   return _isActiveBlockValid;
}

Block *
Board::getActiveBlock(void)
{
   return _activeBlock;
}

void
Board::setActiveBlock(Block *b)
{
   _activeBlock = b;
   _isActiveBlockValid = True;
}

void
Board::setActiveBlock(int blockIndex, int orientation, int x, int y)
{
   _activeBlock -> modify(blockIndex, orientation, x, y);
   _isActiveBlockValid = True;
}

int
Board::getCompletedLines()
{
   return _completedLines;
}

void
Board::incrementCompletedLines(int n)
{
   _completedLines += n;
}

void
Board::reset(void)
{
   clearBoard();
   getScore() -> resetScore();
   _completedLines = 0;
   _gameStatus = GAME_PAUSED;
}

Block *
Board::getOtherBlock(void)
{
#ifdef DEBUG
   {
      int *x, *y; Cardinal count;
      if (_otherBlock) {
	 _otherBlock -> getCoordinates(x, y, count);
	 assert(x[0] >= 0 &&x[0] < _w && y[0] >= 0 &&y[0] < _h);
      }
   }
#endif
   return _otherBlock;
}

void
Board::setOtherBlock(Block *block)
{
   _isOtherBlockValid = True;
   _otherBlock = block;
#ifdef DEBUG
   {
      int *x, *y; Cardinal count;
      block -> getCoordinates(x, y, count);
      assert(x[0] >= 0 &&x[0] < _w && y[0] >= 0 &&y[0] < _h);
   }
#endif
}

void
Board::setOtherBlock(int blockIndex, int orientation, int x, int y)
{
   _otherBlock -> modify(blockIndex, orientation, x, y);
   _isOtherBlockValid = True;
}

void
Board::invalidateOtherBlock(void)
{
   _isOtherBlockValid = False;
}

Bool
Board::isOtherBlockValid(void)
{
   return _isOtherBlockValid;
}

void
Board::customSRand(unsigned int seed)
{
   setNextRand(seed);
}

unsigned int
Board::customRand(void)
{
   unsigned int result;
   unsigned int previous;
   unsigned long  next = previous = getNextRand();
//   result = ((next = next * 1103515245 + 12345) % ((u_long)65536 + 1));
   result = ++next;
   setNextRand(next);

/*
   cout << getpid() << " board:: rand returning " << previous << " -> "
	<< result << endl;
*/
   return result;
}

void
Board::setNextRand(unsigned long nr)
{
   _NextRand = nr;
}

unsigned long
Board::getNextRand(void)
{
   return _NextRand;
}

