#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>

#include "font.C"

static Display	*dpy;
static int		scr;
static Window	win;
static GC		gc;

#define	WIDTH		1000
#define	HEIGHT	720

#define	OFFX		64
#define	OFFY		70

// #define	TST_FNT	"-adobe-times-medium-r-normal--34-240-100-100-p-170-iso8859-1"
#define TST_FNT "-adobe-courier-bold-r-normal--24-240-75-75-m-150-iso8859-1"
#define	TST_STR	"_Helmut_\rHoenig\r_"

#include "smiletab.H"

static int cmp(const void *a,const void *b) {
	return strcmp(*(char**)a,*(char**)b);
}

void main(int argc,char **argv)
{
int		i;
int		width=WIDTH;
char		*dispname="";
int		sync_flag=0;
XEvent	event;
ScalableFont	*sf;

	for (i=1;i<argc;i++) {
		if (!strncmp(argv[i],"-d",2))			dispname=argv[++i];
		else if (!strncmp(argv[i],"-s",2))	sync_flag=1;
	}
	dpy = XOpenDisplay(dispname);
	if (!dpy) {
		fprintf(stderr,"can't open display '%s'\n", dispname);
		exit(-1);
	}
	if (sync_flag)		XSynchronize(dpy,1);
	scr = DefaultScreen(dpy);
	win=XCreateSimpleWindow(dpy,RootWindow(dpy,scr),
			0,0,WIDTH,HEIGHT,2,BlackPixel(dpy,scr),WhitePixel(dpy,scr) );
	XStoreName(dpy,win,argv[0]);
	gc =XCreateGC(dpy,win,0,0);
	XSetForeground(dpy,gc,BlackPixel(dpy,scr));
	XSetBackground(dpy,gc,WhitePixel(dpy,scr));
	XSetFont(dpy,gc,XLoadFont(dpy,TST_FNT));

	XSelectInput(dpy,win,ExposureMask|ButtonPressMask|StructureNotifyMask);
	XMapRaised(dpy,win);


	qsort(smiletab,sizeof(smiletab)/sizeof(char*),sizeof(char*),cmp);
	for (i=1;i<sizeof(smiletab)/sizeof(char*);i++) {
		if (!strcmp(smiletab[i],smiletab[i-1])) {
			printf( "Duplicated Entry: %s\n", smiletab[i] );
		}
	}
	printf( "%d entries in table\n", sizeof(smiletab)/sizeof(char*) );

	sf = new FlipFont( dpy, TST_FNT, 270 );

	while(1) {
		XNextEvent(dpy,&event);
		switch(event.type) {
		case ButtonPress:
			switch(event.xbutton.button) {
			case 1:	sf->TurnLeft();	break;
			case 2:	sf->Flip();			break;
			case 3:	sf->TurnRight();	break;
			}
			XClearWindow(dpy,win);

		case Expose: {
			int	x,y;

			sf->DrawCentered(win,gc,150,150,TST_STR);
			sf->DrawCentered(win,gc,200,200,TST_STR);
			XDrawImageString(dpy,win,gc,250,250,TST_STR,strlen(TST_STR));
#if (0)
			x = OFFX;
			y = 400;
			for (i=0;i<sizeof(smiletab)/sizeof(char*);i++) {
				sf->DrawCentered(win,gc,x,y,smiletab[i]);
				x+=OFFX;
				if (x>width-OFFX) {
					y+=OFFY;
					x =OFFX;
				}
			}
#endif
			break;
		}
		case ConfigureNotify:
			width = event.xconfigure.width;
			/* Size: event.xconfigure.width,event.xconfigure.height */
			break;
		}
	}
}
