.TH xmemory 1 "July-17-1996" "X Version 11"
.SH NAME
xmemory \- game of memory for several players
.SH SYNOPSIS
.B xmemory
<options>
.SH DESCRIPTION
.I XMemory
is a multi player memory game. It is played simultaenously
on several X Displays, which have to be listed on the command-line.
To run properly, the access to the selected X Displays must be
allowed. This can be achieved in the usual manner by running \fIxhost\fP
on the desired displays.

.SH RULES

Like in the traditional memory game, the players have to find similar tiles
on the table to get the tiles. The main change in this version is, that the
players play simultaenously and therefor the whole game gets some kind of an
action game.

Opening a tile leads to a lock of the tile for about 3 seconds when opening
the first tile. 1 second after opening the second tile, both tiles flip back
and therefor are accessable again for all other players. (In synchronous mode
the 1st tile remains opened until the second tile is selected)

Winner is the player who collected the most matching tiles.

.SH OPTIONS
.SS "Tile Selection"
.TP 12
.B -pictures
The tiles are switched from the default Smileys to the default set of picture tiles.
Use \fB-help\fP to check, if there are any picture packages installed on your system.
.TP 12
.B -file \fIname\fP
Use the picture file \fIname\fP for creating the tiles
.TP 12
.B -letter
The tiles are switched from the default Smileys to a normal letter mode.

.SS "Game Selection"
.TP 12
.B -small
small amount of tiles
.TP 12
.B -normal
normal amount of tiles (default)
.TP 12
.B -big
large amount of tiles
.TP 12
.B -remain
leave tiles on screen after match. Tiles will only remain on the screen
of the player who found the match.
.TP 12
.B -sync
play the traditional game where only one player can select at a time.
.TP 12
.B -tile  <\fIw\fP>x<\fIh\fP>
set number of tiles explicitly, which overrides the other size selection options.
The total amount of tiles has to be even.
.TP 12
.B -lock <\fIn\fP>
locks the size of picture images to \fIn\fP perecent of the original size. This
might be usefull for better results, since the images are stored in an pre-dithered
format and are scaled in the most primitive way, so that there might be
undesired effects, when scaling to odd amounts.

.SS "Fonts"

.TP 12
.B -font \fIname\fP
Override the default pattern '-adobe-courier-bold-r-normal-*' to search for
a different set of fonts in letter or smiley game. The program tries to use scalable fonts on the
displays, when bitmap fonts in the necessary size can't be found. If the fonts
don't look pretty, check out if the fontserver \fIfs\fP (or \fIxfs\fP) is
running on the display.

.SS "Player Selection"

.TP 12
.B <\fIdisplay\fP>
Each name of a display (containing a colon) activates a player on that
screen. The total amount of players is internally limited to 10.
.TP 12
.B <\fIdisplay\fP>/<\fIcolor\fP>
A display name can be extended by a color specification. Otherwise, a default
color is selected for that player.
.TP 12
.B -color<\fIn\fP> <\fIname\fP>
The color for player \fIn\fP can be set explicitly to \fIname\f, even so
previous option is the easier way to achive this.

.SH EXAMPLE
xmemory -big / barcley:0.0/ genesis:0.0/green

.SH "SEE ALSO"
xhost(1)
xfs(1)
X(1)

.SH COPYRIGHT
Copyright 1993,1995,1996, Helmut Hoenig, Heiligenhaus
.nf
.TP 8
email (for any comments):
Helmut.Hoenig@hub.de
.TP 5
smail (for gifts):
   Helmut Hoenig
   Hopfenstrasse 8a
   65520 Bad Camberg
   GERMANY
.PP
.ce 8
********************************************************

By the way, I am collecting banknotes! If you want 
to join into my collection, get any bill of your
country, sign it on the backside and send it to me
so I will pin it on my world map.
(Don't forget the exact location for the pin :-)
But you can also just send me a picture postcard ...

********************************************************
.fi
.PP
Permission to use, copy, modify, and distribute this
software for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies.


.SS "other fancy things from the author"
.ta 15
.nf
xcol (1990)	- color selector for editing text-files
flying (94/95)	- pool billard simulation
xdefmap (1995)	- enhanced tool for setting up standard colormaps
xjig (1996)	- jigsaw puzzle with texture mapping animations

available at ftp.x.org and its mirrors
.fi
