#ifndef __tile_h
#define __tile_h

// ===========================================================================
//
// The tile-class stores the pixmap of a single tile. It actually has the
// depth of 2 bit only, since (in an extension to a bitmap) it is contructed
// of 4 colors to achieve a 3D effect.
// The actual color has to be added by a rectangle in a different plane on the
// screen (with the base-pixel allocated from the desired Color-instance.
//
// ===========================================================================

class Tile {
	friend class Port;

public:
	Tile( class Port *p, class ScalableFont *font_info, int id );
	~Tile();

private:
	void CopyImage8( class Port *p, int id );
	void CopyImage16( class Port *p, int id );
	void CopyImage32( class Port *p, int id );

	Display	*display;
	Pixmap	pixmap;

public:
	static void init_used_syms(int n);
private:
	static int used_syms[];		// ids of the character, that are really used
};

#endif
