
#ifndef __global_h
#	include "global.H"
#endif
#ifndef __tile_h
#	include "tile.H"
#endif
#ifndef __port_h
#	include "port.H"
#endif
#ifndef __font_h
#	include "font.H"
#endif

#ifndef __smiletab_H
#	include "smiletab.H"
#endif

#ifndef __mem_image_h
#	include "mem_image.H"
#endif

#ifdef HUBSYM
/*
 * to use special ContronicS cyrillic font of Hartmann&Braun
 */
static unsigned char cyr_lock_flag[] = {
	1,1,1,1,  1,1,1,1,  1,1,1,1,  1,1,1,1,		/* 00 - 0f */
	1,1,1,1,  1,1,1,1,  1,1,1,1,  1,1,1,1,		/* 10 - 1f */
	1,1,1,1,  1,1,1,1,  1,1,1,1,  1,1,1,1,		/* 20 - 2f */
	0,0,0,0,  0,0,0,0,  0,0,1,1,  1,1,1,1,		/* 30 - 3f */

	1,1,1,1,  1,1,1,1,  1,1,1,1,  1,1,1,1,		/* 40 - 4f */
	1,1,1,1,  1,1,1,1,  1,1,1,1,  1,1,1,1,		/* 50 - 5f */
	1,1,1,1,  1,1,1,1,  1,1,1,1,  1,1,1,1,		/* 60 - 6f */
	1,1,1,1,  1,1,1,1,  1,1,1,1,  1,1,1,1,		/* 70 - 7f */

	1,1,1,1,  1,1,1,1,  1,1,1,1,  1,1,1,1,		/* 80 - 8f */
	1,1,1,1,  1,1,1,1,  1,1,1,1,  1,1,1,1,		/* 90 - 9f */
	1,0,1,1,  1,1,1,1,  1,1,1,1,  1,1,1,1,		/* a0 - af */
	0,0,0,0,  0,0,0,0,  0,0,0,0,  0,0,0,0,		/* b0 - bf */

	0,0,0,0,  0,0,0,0,  0,0,0,0,  0,0,0,0,		/* c0 - cf */
	0,0,0,0,  0,0,0,0,  0,0,0,0,  0,0,0,0,		/* d0 - df */
	0,0,0,0,  0,0,0,0,  0,0,0,0,  0,0,0,0,		/* e0 - ef */
	1,0,1,1,  1,1,1,1,  1,1,1,1,  1,1,1,1		/* f0 - ff */
};

/*
 * to use special ContronicS symbol font of Hartmann&Braun
 */
static unsigned char symb_lock_flag[] = {
   1, 0, 0, 0, 0, 0, 0, 0,   0, 1, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 1, 1, 0,
   1, 0, 0, 1, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 1, 1,
   1, 1, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 1, 0, 1, 1,
   1
};
#endif

int Tile::used_syms[128];

void Tile::init_used_syms(int n) {
char help[256];
int i,j;

	memset(help,0,sizeof(help));
	switch( Port::def_mode ) {
#ifdef HUBSYM
	case Cyrillic:
		memcpy(help,cyr_lock_flag,sizeof(cyr_lock_flag));
		for (i=0;i<n;i++) {
			do {
				j=rand()%sizeof(cyr_lock_flag);
			}
			while(help[j]);
			help[j]=1;
			used_syms[i] = j;
		}
		break;
	case Symbol:
		memcpy(help,symb_lock_flag,sizeof(symb_lock_flag));
		for (i=0;i<n;i++) {
			do {
				j=rand()%sizeof(symb_lock_flag);
			}
			while(help[j]);
			help[j]=1;
			used_syms[i] = j;
		}
		break;
#endif
	case Photo:
		if ( !Port::gif ) {
			fprintf( stderr, "gif-file not yet loaded\n" );
			exit(0);
		}
		if (n>Port::gif->PicNum()) {
			fprintf( stderr, "sorry - no enough tiles in picture file\n" );
			exit(0);
		}
		for (i=0;i<n;i++) {
			do {
				if (rand()%1==0)	j=rand()%Port::gif->PicNum();
				else					j=rand()%(Port::gif->PicNum()/2);
			}
			while(help[j]);
			help[j]=1;
			used_syms[i] = j;
		}
		break;

	default:
		for (i=0;i<((n<7)?n:7);i++)
			used_syms[i]=i;		// always used the standard smileys

		for (   ;i<n;i++) {
			used_syms[i]=rand()%(sizeof(smiletab)/sizeof(char*));
			for (j=0;j<i;j++) {
				if (used_syms[i]==used_syms[j]) {
					i--;
					break;
				}
			}
		}
		break;
	}
}

/*----------------------------------------------------------------------------*/
#define	DATA_TYPE	unsigned long
#define	DATA_PAD		32
void Tile::CopyImage32( Port *p, int id ) {
#	include "reset_image.h"
}
#undef DATA_TYPE
#undef DATA_PAD
/*----------------------------------------------------------------------------*/
#define	DATA_TYPE	unsigned short
#define	DATA_PAD		16
void Tile::CopyImage16( Port *p, int id ) {
#	include "reset_image.h"
}
#undef DATA_TYPE
#undef DATA_PAD
/*----------------------------------------------------------------------------*/
#define	DATA_TYPE	unsigned char
#define	DATA_PAD		8
void Tile::CopyImage8( Port *p, int id ) {
#	include "reset_image.h"
}
#undef DATA_TYPE
#undef DATA_PAD
/*----------------------------------------------------------------------------*/



Tile::Tile( Port *p, ScalableFont *font, int id )
{
char buffer[40];

#ifdef HUBSYM
	if (p->mode==Cyrillic||p->mode==Symbol) {
		buffer[0] = (id>=0)?used_syms[id]:32;
		buffer[1] = 0;
	}
	else
#endif
	if (p->mode==Smiley) {
		if (id>=0)	strcpy(buffer,smiletab[used_syms[id]]);
		else			strcpy(buffer,"");
	}
	else {
// check justification of sign
		if ((id>=0)&&(id<=9))	buffer[0] = id+48;
		if ((id>=10)&&(id<=35))	buffer[0] = id-10+65;
		if ((id>=36)&&(id<=61))	buffer[0] = id-36+97;
		if (id>61)					buffer[0] = id-62+60;
		if (id>67)					buffer[0] = id-67+33;
		buffer[1] = 0;
	}

// create Pixmap
	display = p->display;	// for automatic destruction

	pixmap = XCreatePixmap( display, RootWindowOfScreen(p->screen),
							p->sizex, p->sizey, DefaultDepthOfScreen(p->screen) );

// Background
	if (Port::def_mode==Photo && id>=0) {
		if (DefaultDepthOfScreen(p->screen)==8)			CopyImage8(p,used_syms[id]);
		else if (DefaultDepthOfScreen(p->screen)==16)	CopyImage16(p,used_syms[id]);
		else if (DefaultDepthOfScreen(p->screen)==32)	CopyImage32(p,used_syms[id]);
		else if (DefaultDepthOfScreen(p->screen)==24)	CopyImage32(p,used_syms[id]);
		else {
			fprintf(stderr,"Depth %d currently not supported\n", DefaultDepthOfScreen(p->screen) );
			exit(0);
		}
	}
	else {
		XSetForeground( display, p->gc_all, (id!=-1)?p->bg:p->fg );
		XFillRectangle( display, pixmap, p->gc_all, 0, 0, p->sizex, p->sizey );
	}

// TopLeft highlight
	XSetForeground( display, p->gc_all, (id>=-1)?p->dark:p->light);
	XDrawLine( display, pixmap, p->gc_all, 0, 0, p->sizex-1, 0 );
	XDrawLine( display, pixmap, p->gc_all, 0, 0, 0, p->sizey-1 );
	if (p->stipple_pmap) {
		if (id==-2) {
			XDrawLine( display, pixmap, p->gc_all, 1, 1, p->sizex-2, 1 );
			XDrawLine( display, pixmap, p->gc_all, 1, 1, 1, p->sizey-2 );
		}
	}

	if (Port::def_mode!=Photo) {
		if (id>=0) {
#ifdef DoubleString
			font->DrawCentered(pixmap,p->gc_all,
									p->sizex/2+2,p->sizey/2+2, buffer);
#endif
			font->DrawCentered(pixmap,p->gc_all,
									p->sizex/2+1,p->sizey/2+1, buffer);
		}
	}

// BottomRight shade
	XSetForeground( display, p->gc_all, (id>=-1)?p->light:p->dark);
	XDrawLine( display, pixmap, p->gc_all, 0, p->sizey-1, p->sizex-1, p->sizey-1);
	XDrawLine( display, pixmap, p->gc_all, p->sizex-1, 0, p->sizex-1, p->sizey-1);
	if (p->stipple_pmap) {
		if (id==-2) {
	 	XDrawLine( display, pixmap, p->gc_all, 1, p->sizey-2, p->sizex-2, p->sizey-2);
	 	XDrawLine( display, pixmap, p->gc_all, p->sizex-2, 1, p->sizex-2, p->sizey-2);
		}
	}

	if (Port::def_mode!=Photo) {
		if (id>=0) {
#ifdef DoubleString
			font->DrawCentered(pixmap,p->gc_all,
									p->sizex/2-2,p->sizey/2-2, buffer);
#endif
			font->DrawCentered(pixmap,p->gc_all,
									p->sizex/2-1,p->sizey/2-1, buffer);
		}
	// Foreground
		XSetForeground( display, p->gc_all, p->fg );
		if (id>=0)
			font->DrawCentered(pixmap,p->gc_all,
									p->sizex/2,p->sizey/2, buffer);
	}
}


Tile::~Tile() {
	XFreePixmap( display, pixmap );
}

