#ifndef __font_h
#define __font_h

// ===========================================================================
//
// The module <font> contains some classes which re-implement some
// textoutput-function on the X-client side. The images of the characters
// are transferred (on demand) from the server to the client, where the
// client then can rotate them or do any other manipulations
//
// To draw them on the screen, they are transferred back into a pixmap of the
// server.
//
// This module actually gets somehow obsolete which functionality of the
// Xserver and fontserver to rotate fonts in X11R6, but nevertheless is
// a  nice demo.
//
// ===========================================================================
// classes:
//
// Character:    a Character-object holds the image and the size information
//               for a single character (as ximage on the client side and as
//               a pixmap on the server side) and has some functions like
//               Rotating and Mirroring...
// ScalableFont: contains a list of characters, which is constructed on the fly
//               when characters of the desired font need to be drawn
// FlipFont:     extension to ScalableFont, where letters can be used both
//               upside down and normal
//
// ===========================================================================

#include <X11/Xlib.h>
#include <X11/Xutil.h>

// ===========================================================================

class ScalableFont {
	public:
		ScalableFont( Display *dpy, const char *fontname, int mode );
		virtual ~ScalableFont();

		void Draw( Drawable w, GC gc, int x, int y, const char *str );
		void DrawCentered( Drawable d, GC gc, int x, int y, const char *str );

		void Width( const char *str, int *ox, int *oy );
		void BBox( const char *str, int *tlx, int *tly, int *brx, int *bry );

		void TurnRight();
		void TurnLeft();
		void Flip();

		virtual class Character *GetChar(char c);
		virtual const char *GetString(const char *str);

	protected:
		Display				*dpy;
		XFontStruct			*fs;
		class Character	**chr;
		char					*name;
		int					mode;
		int					nchr;		// number of characters

	friend class Character;
};

// ===========================================================================

class Character {
	public:
		Character(class ScalableFont *sf,char c);
		~Character();

		void Draw( Drawable d, GC gc, int *x, int *y );
		void Width( int *ox, int *oy )		{ *ox  = addx;	*oy  = addy; }
		void AddWidth( int *ox, int *oy )	{ *ox += addx;	*oy += addy; }
		void BBox( int *ulx, int *uly, int *brx, int *bry );

		void TurnRight();
		void TurnLeft();
		void ImgFlipX();
		void FlipX();
		void ImgFlipY();
		void FlipY();
		void Mirror()	{ FlipX(); FlipY(); }

	protected:
		void Init(class ScalableFont *sf=0l);

		void Pix2Img();
		void Img2Pix();
		void PrintImg();

		void DropPix()	
			{ if (pix!=0)	{ XFreePixmap(dpy,pix); pix=0; } }
		void DropImg()
			{ if (img!=0)	{ XDestroyImage(img); img=0l; } }
		void DropData()
			{ DropPix(); DropImg(); }

		void PreparePix()
			{ if (pix==0)	Init(); }
		void PrepareImg()
			{	if (img==0) {
					PreparePix();
					Pix2Img();
				}
			}

	private:
		Display			*dpy;
	//	ScalableFont	*sf;
	//	XCharStruct		*cs;
		Pixmap			pix;
		XImage			*img;
		int				w,h;				// width, height
		int				offx, offy;		// offset of starting position
		int				addx, addy;		// offset to next point;
		char				c;
};

// ===========================================================================

class FlipFont : public ScalableFont {
	public:
		FlipFont( Display *dpy, const char *fontname, int mode );
		virtual ~FlipFont();

		virtual class Character *GetChar(char c);
		virtual const char *GetString(const char *str);
};

// ===========================================================================

#endif
