
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "defs.h"
#include "struct.h"
#include "global.h"

#include "newplayer.h"
#include "commands.h"
#include "socket.h"
#include "map.h"

/* newplayer_enter_player_xy(pl)

   Move this player to his base

   Return: none
   */
void newplayer_enter_player_xy(int pl)
{
    GLO_players[pl].p_x = (GLO_bases[GLO_players[pl].p_team].b_x * GRIDWIDTH + GRIDWIDTH / 2) << 4;
    GLO_players[pl].p_y = (GLO_bases[GLO_players[pl].p_team].b_y * GRIDHEIGHT + GRIDWIDTH / 2) << 4;
}

/* newplayer_new_player(pl)

   Add this player into the game

   Return: none
   */
void newplayer_new_player(int pl)
{
    int i;
    char buf[80];

    /* he's at the motd */
    GLO_players[pl].p_status = POUTFIT;

    /* when he chooses a team he will be at his base */
    newplayer_enter_player_xy(pl);

    /* his number is his number */
    GLO_players[pl].p_num = pl;

    /* his initial course is random */
    GLO_players[pl].p_dir = GLO_players[pl].p_desdir = rand() % 256;

    /* he is not moving */
    GLO_players[pl].p_speed = 0;
    GLO_players[pl].p_desspeed = 0;

    /* obsolete*/
    GLO_players[pl].p_keys = 0;

    /* he can turn in TURNSPEED ticks */
    GLO_players[pl].p_turnok = TURNSPEED;

    /* His statistics are all 0 */
    GLO_players[pl].p_wins = 0;
    GLO_players[pl].p_losses = 0;
    GLO_players[pl].p_kills = 0;

    /* everyone needs to know about his status */
    GLO_players[pl].p_updateplayers = 0xffff;

    /* his default team is his number mod 2 -
       his actual team will be whatever he chooses */
    GLO_players[pl].p_team = pl % 2;

    /* he is carrying no flags */
    GLO_players[pl].p_carryflag = -1;

    /* fuel him up and load his ammo */
    GLO_players[pl].p_ammo = MAXAMMO;
    GLO_players[pl].p_fuel = MAXFUEL;

    /* he hasn't voted for anything */
    commands_clear_votes(pl);

    /* all his mines are inactive */
    for (i = MINESPERPLAYER * pl; i < MINESPERPLAYER * (pl + 1); i++) {
        GLO_mines[i].mi_status = MIEMPTY;
        GLO_mines[i].mi_updated = 0;
    }

    /* he hasn't been updated about any mines */
    for (i = 0; i < MAXPLAYERS * MINESPERPLAYER; i++) {
        GLO_mines[i].mi_updated &= ~(1 << pl);
    }

    /* tell him about everyone else */
    NET_update_all_players(pl);

    /* send him his own info */
    socket_send_personal_info(pl);

    /* let everyone else know this guy is alive */
    for (i = 0; i < MAXPLAYERS; i++) {
        if (GLO_players[i].p_status != PEMPTY) {
            GLO_players[i].p_updateplayers |= (1 << pl);
            NET_update_one_player(i, pl);
            NET_send_playerdata(i, pl);
            NET_send_playerdata(pl, i);
        }
    }

    /* send a text message about him */
    sprintf(buf, "Player %d joining", pl);
    NET_send_message_to_all(buf, M_SRV);
}

/* newplayer_remove_player(pl)

   Called when a player leaves the server entirely (connection dies)

   Return: none
   */
void newplayer_remove_player(int pl)
{
    int i;
    int livecount = 0;
    char buf[80];

    /* All he is is dust in the wind. */
    GLO_players[pl].p_status = PEMPTY;

    /* If he was carrying any flas, drop them where he was */
    if (GLO_players[pl].p_carryflag >= 0) {
        GLO_flags[GLO_players[pl].p_carryflag].f_carrier = -1;
    }
    /* Tell everyone else he left */
    for (i = 0; i < MAXPLAYERS; i++) {
        if (GLO_players[i].p_status != PEMPTY) {
            livecount++;
            NET_update_one_player(i, pl);
            NET_send_playerdata(i, pl);
        }
    }

    /* clear all his mines */
    for (i = MINESPERPLAYER * pl; i < MINESPERPLAYER * (pl + 1); i++) {
        GLO_mines[i].mi_status = MIEMPTY;
        GLO_mines[i].mi_updated = 0;
    }

    /* send a text message about this */
    sprintf(buf, "%s has left the building.", GLO_players[pl].p_name);
    NET_send_message_to_all(buf, M_SRV);

    if (!livecount) {
        /* no players are left, read a new map in and wait for connections */
        map_pick_map(GLO_maplist);
    }
}

/* newplayer_game_over(team)

   The game has been won by team #team, reset the server

   Return: none
   */
void newplayer_game_over(int team)
{
    char buf[80];
    int i;

    /* send a text message describing the victory */
    sprintf(buf, "The game has been won by team #%d, reseting map", team + 1);
    NET_send_message_to_all(buf, M_SRV);

    /* pick a new map, read it in */
    map_pick_map(GLO_maplist);

    /* tell everyone the new name */
    sprintf(buf, "Map name is %s", GLO_map_info.m_name);
    NET_send_message_to_all(buf, M_SRV);

    /* Send everyone the new map, put them all at the motd (effectively killing them
     if they were alive */
    for (i = 0; i < MAXPLAYERS; i++) {
        if (GLO_players[i].p_status != PEMPTY) {
            NET_send_map(i);
            newplayer_new_player(i);
        }
    }
}

/* newplayer_find_host(sock, pl)

   Get this player's FQDN

   Return: none (fills the FQDN into the player struct
   */
void newplayer_find_host(int sock, int pl)
{
    struct sockaddr_in sin;
    struct hostent *hp;
    int len;
    char buf[80];

    len = sizeof(sin);
    if (!(getpeername(sock, (struct sockaddr *) &sin, &len))) {
        hp = gethostbyaddr((char *) &sin.sin_addr.s_addr, sizeof(sin.sin_addr.s_addr),
                           AF_INET);
        if (hp != NULL)
            (void) strcpy(buf, hp->h_name);
        else
            (void) strcpy(buf, inet_ntoa(sin.sin_addr));
        strncpy(GLO_players[pl].p_host, buf, 31);
        GLO_players[pl].p_host[31] = 0;
    }
}
