
/* main.c for firepower

   Does initial setup of global arrays, then sits in a loop calling NET_checkSockets

   Copyright (c) 1995   Joe Rumsey
*/
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <time.h>
#include "defs.h"
#include "global.h"

#include "socket.h"
#include "map.h"
#include "motd.h"
#include "sintab.h"
#include "commands.h"
#include "sintab.h"

int listenSock = -1;

/* init_players()
 *
 * Clear all the player structures
 *
 * Return: none
 */
static void init_players()
{
    int i, j;

    for (i = 0; i < MAXPLAYERS; i++) {
        /* Set the number/display character for each slot, never changes */
        GLO_players[i].p_num = i;
        GLO_players[i].p_char = (i < 10) ? i + '0' : i - 10 + 'a';

        /* Make the slot empty */
        GLO_players[i].p_status = PEMPTY;

        /* clear all the mines for this player */
        for (j = 0; j < MINESPERPLAYER; j++) {
            GLO_mines[i * MINESPERPLAYER + j].mi_status = MIEMPTY;
            GLO_mines[i * MINESPERPLAYER + j].mi_updated = 0;
        }
    }
}

/* init_shells()
 *
 * clear all the shell structures
 *
 * Return: none
 */
static void init_shells()
{
    int i;
    for (i = 0; i < MAXPLAYERS * SHELLSPERPLAYER; i++) {
        GLO_shells[i].s_status = SDEAD;
        GLO_shells[i].s_num = i;
        GLO_shells[i].s_owner = i / SHELLSPERPLAYER;
    }
}

/* main()
 *
 * Do the usual setup stuff, sit in a loop calling NET_checkSockets() forever
 *
 */
int main(int argc, char **argv)
{

    /* have to specify a map list file on the command line */
    if (argc != 2) {
        printf("Usage: %s <map_list_file>\n", argv[0]);
        exit(0);
    }
    srand(time(0));

    /* load the motd into memory */
    motd_read_motd();

    /* ignores certain errors from sockets */
    signal(SIGPIPE, SIG_IGN);

    /* Open up our initial sockets */
    NET_listenSocket(XFIREPORT);

    /* call map_pick_map to choose (at random) a map and read it in */
    GLO_maplist = argv[1];
    GLO_mapname = "maps/map1";  /* fallback file */
    if (!map_pick_map(GLO_maplist)) {
        printf("Could not load map, exiting\n");
        exit(0);
    }
    init_players();
    init_shells();

    /* Init Sin and Cos arrays for quick math */
    sintab_inittrigtables();

    /* clear the voting status of commands */
    commands_init_commands();

    /* This is it, NET_checkSockets() does all the real work. */
    while (1) {
        NET_checkSockets();
    }
}
