
/* Log handling for XFirepower server */

#include <stdio.h>
#include <time.h>
#include "data.h"
#include "struct.h"

#include "log.h"

/* log_log_message(msg)

   Write this message to the logfile

   Return: none
   */
void log_log_message(char *msg)
{
    static FILE *ml = 0;
    time_t t = time(0);
    struct tm *tmv = localtime(&t);
    char tbuf[40];

    /* open the file if it isn't already */
    if (!ml) {
        ml = fopen("logs/message.log", "a");
        if (!ml) {
            fprintf(stderr, "Can't open log file!\n");
            return;
        }
    }
    /* add the time/date to every message */
#ifdef NO_STRFTIME
    sprintf(tbuf, "%02d/%02d %d/%d", tmv->tm_hour, tmv->tm_min,
            tmv->tm_mday, tmv->tm_mon);
#else
    strftime(tbuf, 39, "%R %D", tmv);
#endif
    fprintf(ml, "%s:%s\n", tbuf, msg);

    /* flush the file so we can read it all while the server is still running */
    fflush(ml);
}
