#include <stdio.h>
#include <math.h>
#include "Wlib.h"
#include "struct.h"
#include "defs.h"
#include "data.h"
#include "proto.h"

void choose_team(int team)
{
    teamOk = -1;

    sendTeam(team);
    while(teamOk < 0)
	doServer();
    if(teamOk) {
	W_DestroyWindow(teamwin[0]);
	W_DestroyWindow(teamwin[1]);
	W_DestroyWindow(quitwin);
	W_DestroyWindow(motdwin);
	teamwin[0] = teamwin[1] = motdwin = quitwin = 0;
    }	
}

void redraw_teamwins()
{
    char *teamname[2] = {
	"Blues Brothers",
	"Red Dawn"
    };

    W_FillArea(teamwin[0], 0, 0, 100, 100, W_Blue);
    W_FillArea(teamwin[1], 0, 0, 100, 100, W_Red);
    W_MaskText(teamwin[0], 50-(strlen(teamname[0])*W_Textwidth)/2, 0, W_White, 
		teamname[0], strlen(teamname[0]), W_RegularFont);
    W_MaskText(teamwin[1], 50-(strlen(teamname[1])*W_Textwidth)/2, 0, W_White, 
		teamname[1], strlen(teamname[1]), W_RegularFont);

    W_ClearWindow(quitwin);
    W_WriteText(quitwin, 50-(4 * W_Textwidth)/2, 45, W_White, "QUIT", 4, W_RegularFont);
}

void do_outfit()
{
    W_Event ev;

    if(!teamwin[0]) {
	teamwin[0] = W_MakeWindow("blue_team", 0, 0, 100, 100, baseWin, 0, 1, W_White);
	teamwin[1] = W_MakeWindow("red_team", 200, 0, 100, 100, baseWin, 0, 1, W_White);
	quitwin = W_MakeWindow("quit", 100, 0, 100, 100, baseWin, 0, 1, W_White);
	W_Buffer(teamwin[0], 0);
	W_Buffer(teamwin[1], 0);
	W_Buffer(quitwin, 0);
	W_MapWindow(teamwin[0]);
	W_MapWindow(teamwin[1]);
	W_MapWindow(quitwin);
	if(motdwin)
	    W_DestroyWindow(motdwin);
	motdwin = W_MakeTextWindow("Motd", 0, 100, 80, LINESPERPAGE, baseWin, 0, 1);
	W_Buffer(motdwin, 0);
	W_MapWindow(motdwin);
    }

    while(W_EventsPending()) {
	W_NextEvent(&ev);
	switch(ev.type) {
	  case W_EV_KEY:
	    if(ev.Window == typewin || 
	       ev.Window == messwin[0] ||
	       ev.Window == messwin[1] ||
	       ev.Window == messwin[2] ||
	       ev.Window == messwin[3]) {
		message_event(&ev);
	    } else if(ev.Window == motdwin) {
		motd_key(ev.key);
	    }
	    break;
	  case W_EV_EXPOSE:
	    if(ev.Window == mapwin)
		redraw_map();
	    else if(ev.Window == typewin)
		redraw_message_win();
	    else if(ev.Window == playerwin)
		redraw_player_win();
	    else if(ev.Window == motdwin)
		display_motd();
	    else if(ev.Window == teamwin[0] || ev.Window == teamwin[1] || ev.Window == quitwin)
		redraw_teamwins();
	    break;
	  case W_EV_BUTTON:
	    if(ev.Window == teamwin[0]) {
		choose_team(0);
	    } else if(ev.Window == teamwin[1]) {
		choose_team(1);
	    } else if(ev.Window == quitwin) {
		quit = 1;
	    }
	    break;
	}
    }
}
