#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Wlib.h"
#include "data.h"
#include "defs.h"
#include "struct.h"
#include "proto.h"

/* wall shape based on neighbors */
#define W_TOP 1
#define W_RIGHT 2
#define W_BOT 4
#define W_LEFT 8

int wallshapes[16] = {
    T_POST,
    T_WALL_T,
    T_WALL_R,
    T_WALL_TR,
    T_WALL_B,
    T_WALL_TB,
    T_WALL_BR,
    T_WALL_TBR,
    T_WALL_L,
    T_WALL_TL,
    T_WALL_RL,
    T_WALL_TRL,
    T_WALL_BL,
    T_WALL_TBL,
    T_WALL_BRL,
    T_WALL_TBRL,
};

int iswall(char v)
{
    if(v>=T_GWALL && v<= T_WALL_TBRL)
	return 1;
    return 0;
}

int
read_map(char *name)
{
    FILE *mf;
    int w,h,x,y;
    char buf[512];
    int walls;

    if(!(mf = fopen(name, "r"))) {
	fprintf(stderr, "Can't open map file %s\n", name);
	return 0;
    }
    
    fgets(buf, 512, mf);
    strncpy(map_info.m_name, buf, 32);
    if(strlen(buf) < 32)
	map_info.m_name[strlen(buf)-1] = 0;
    else
	map_info.m_name[31] = 0;

    fprintf(stderr, "Map name is %s\n", map_info.m_name);

    fgets(buf, 512, mf);
    if(sscanf(buf, "%d %d", &w, &h) != 2) {
	fprintf(stderr, "Error parsing width and height from %s", buf);
	fclose(mf);
	return 0;
    }
    map_info.m_width = w;
    map_info.m_height = h;

    for(y=0;y<h;y++) {
	if(!fgets(buf, 512, mf)) {
	    perror("read_map");
	    fclose(mf);
	    return 0;
	}
	for(x=0;x<w;x++) {
	    switch(buf[x]) {
	      case '.':
		map[x][y] = T_GRASS;
		break;
	      case 'r':
		map[x][y] = T_ROAD;
		break;
	      case 't':
		map[x][y] = T_TREE;
		break;
	      case 'w':
		map[x][y] = T_GWALL;
		break;
	    }
	}
    }

    fclose(mf);

    /* post process */
    for(y=0;y<h;y++) {
	for(x=0;x<w;x++) {
	    if(map[x][y] == T_GWALL) {
		walls=0;
		if(iswall(map[x][y-1]))
		    walls |= W_TOP;
		if(iswall(map[x+1][y]))
		    walls |= W_RIGHT;
		if(iswall(map[x][y+1]))
		    walls |= W_BOT;
		if(iswall(map[x-1][y]))
		    walls |= W_LEFT;
		map[x][y] = wallshapes[walls];
	    }
	}
    }
    return 1;
}

