/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993-1997 Elan Feingold (elan@jeeves.net)                  *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include "server.h"
#include "riskgame.h"
#include "debug.h"


/************************************************************************ 
 *  FUNCTION: main
 *  HISTORY: 
 *     08.16.94  ESF  Created.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
void main(void)
{
  FILE *hLogFile=NULL; 

  /* Startup the memory debugging system */
  MEM_BootStrap("server-memory.log");

#ifdef LOGGING
  /* Open debugging log file */
  if ((hLogFile = fopen("server.log", "w")) == NULL)
    {
      printf("Could not open \"server.log\" for writing, exiting...");
      exit(-1);
    }
#endif

  /* Initialize the distributed object */
  RISK_InitObject(SRV_Replicate, NULL, NULL, SRV_LogFailure, hLogFile);

  /* Initialize the server and start things going */
  SRV_Init();
  SRV_PlayGame();
}

