/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993-1997 Elan Feingold (elan@jeeves.net)                  *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _CALLBACKS
#define _CALLBACKS

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "types.h"

void CBK_XIncomingMessage(XtPointer pClientData, int *iSource, XtInputId *id);
void CBK_IncomingMessage(Int32 iMessType, void *pvMessage);
void CBK_RefreshMap(Widget w, XtPointer pData, XtPointer call_data);
void CBK_RefreshDice(Widget w, XtPointer pData, XtPointer call_data);
void CBK_MapClick(Widget w, XEvent *pEvent, String *str, Cardinal *card);
void CBK_Quit(Widget w, XtPointer pData, XtPointer call_data);
void CBK_ShowCards(Widget w, XtPointer pData, XtPointer call_data);
void CBK_CancelCards(Widget w, XtPointer pData, XtPointer call_data);
void CBK_ShowMission(Widget w, XtPointer pData, XtPointer call_data);
void CBK_Attack(Widget w, XtPointer pData, XtPointer call_data);
void CBK_Action(Widget w, XtPointer pData, XtPointer call_data);
void CBK_MsgDest(Widget w, XtPointer pData, XtPointer call_data);
void CBK_SendMessage(void);
void CBK_CancelAttack(Widget w, XtPointer pData, XtPointer call_data);
void CBK_About(Widget w, XtPointer pData, XtPointer call_data);
void CBK_Repeat(Widget w, XtPointer pData, XtPointer call_data);
void CBK_Help(Widget w, XtPointer pData, XtPointer call_data);
void CBK_ExchangeCards(Widget w, XtPointer pData, XtPointer call_data);
void CBK_EndTurn(Widget w, XtPointer pData, XtPointer call_data);
void CBK_ArmiesShell(Widget w, XtPointer pData, XtPointer call_data);
void CBK_HelpOk(Widget w, XtPointer pData, XtPointer call_data);
void CBK_HelpSelectTopic(Widget w, XtPointer pData, XtPointer call_data);
void CBK_Replicate(Int32 iMessType, void *pvMess, Int32 iType, Int32 iSrc);
void CBK_Callback(Int32 iMessType, void *pvMess);

extern Int32      iActionState, iCurrentPlayer;
extern Int32      iState;
extern Flag       fGameStarted, fForceExchange;
extern Int32      iReply;
extern Char       strScratch[256];

/* Relating to the message destination listbox */
extern CString    pstrMsgDstCString[];
extern Int32      piMsgDstPlayerID[];
extern Int32      iIndexMD;

#endif

