/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993-1997 Elan Feingold (elan@jeeves.net)                  *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _SERVER
#define _SERVER

#include "types.h"

#define SERVER_REGISTERING  0
#define SERVER_FORTIFYING   1
#define SERVER_PLAYING      2

/* Methods for the server-specific data */
void     SRV_SetAddressOfClient(Int32 iNumClient, CString strAddress);
void     SRV_SetAllocationStateOfClient(Int32 iNumClient, Int32 iState);
void     SRV_SetStartStateOfClient(Int32 iNumClient, Int32 iState);
void     SRV_SetCommLinkOfClient(Int32 iNumClient, Int32 iCommLink);
void     SRV_SetNumClients(Int32 iNumClients);
void     SRV_SetTypeOfClient(Int32 iNumClient, Int32 iType);
void     SRV_SetSpeciesOfClient(Int32 iNumClient, Int32 iSpecies);

CString  SRV_GetAddressOfClient(Int32 iNumClient);
Int32    SRV_GetAllocationStateOfClient(Int32 iNumClient);
Int32    SRV_GetStartStateOfClient(Int32 iNumClient);
Int32    SRV_GetCommLinkOfClient(Int32 iNumClient);
Int32    SRV_GetNumClients(void);
Int32    SRV_GetTypeOfClient(Int32 iNumClient);
Int32    SRV_GetSpeciesOfClient(Int32 iNumClient);

void     SRV_Init(void);
void     SRV_Reset(void);
void     SRV_BroadcastTextMessage(CString strMessage);
void     SRV_BroadcastMessage(Int32 iMessType, void *pvMessage);
void     SRV_CompleteBroadcast(Int32 iClientExclude, Int32 iMessType, 
			       void *pvMess);
Int32    SRV_AllocClient(void);
void     SRV_FreeClient(Int32 i);
Int32    SRV_AllocSpecies(void);
void     SRV_FreeSpecies(Int32 i);

void     SRV_PlayGame(void);
void     SRV_Replicate(Int32 iMessType, void *pvMess, Int32 iType, Int32 iSrc);
void     SRV_LogFailure(CString strReason, Int32 iCommLink);
void     SRV_RecoverFailures(void);

#endif
