/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, 1995, Elan Feingold (feingold@zko.dec.com)     *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _RISK
#define _RISK

#include "network.h"
#include "types.h"

/* Fields of the RiskGame object.  There MUST NOT be any gaps in the
 * numeric sequence (because of how the replication works.
 */

#define PLR_ATTACKMODE       0   /* Remembers the attack mode of the player */
#define PLR_MSGDSTMODE       1   /* Remembers the last message destination */
#define PLR_DICEMODE         2   /* Remembers the last die mode */

#define PLR_STATE            3   /* Either TRUE = Alive, FALSE = Dead */
#define PLR_CLIENT           4   /* The client of the player */
#define PLR_NUMCOUNTRIES     5   /* Number of territories the player owns */
#define PLR_NUMARMIES        6   /* Number of armies the player holds */
#define PLR_NUMCARDS         7   /* Number of cards the player holds */
#define PLR_NAME             8   /* Name of the player */
#define PLR_COLORSTRING      9   /* Name of the color of the player */
#define PLR_CARD            10   /* A card of the player */
#define PLR_SPECIES         11   /* What is the player */

#define CNT_NAME            12   
#define CNT_CONTINENT       13
#define CNT_NUMARMIES       14
#define CNT_OWNER           15
#define CNT_ADJCOUNTRY      16
#define CNT_TEXTX           17
#define CNT_TEXTY           18

#define CON_NAME            19
#define CON_VALUE           20
#define CON_NUMCOUNTRIES    21

#define GEN_NUMPLAYERS      22
#define GEN_NUMLIVEPLAYERS  23

/* Port at which the clients can find the server */
#define RISK_PORT 5324

/* Amount of time (in ms) for graphical notification */
#define NOTIFY_TIME 750

/* Limits */
#define MAX_CLIENTS     10
#define MAX_CARDS       10
#define MAX_PLAYERS      8
#define MAX_COLORS     256

/* Numbers */
#define NUM_CONTINENTS     6
#define NUM_COUNTRIES     42
#define NUM_OTHERCOLORS    3
#define NUM_CARDS         (NUM_COUNTRIES+2)

/* Card types */
#define CARD_CANON    0
#define CARD_FOOTMAN  1
#define CARD_HORSEMAN 2
#define CARD_JOKER    3 

/* Continents */
#define CNT_NORTHAMERICA  0 
#define CNT_SOUTHAMERICA  1
#define CNT_AFRICA        2
#define CNT_AUSTRALIA     3
#define CNT_ASIA          4
#define CNT_EUROPE        5

/* Macros */
#ifdef MAX
#undef MAX
#endif
#define MAX(a, b) ((a)>(b)?(a):(b))

#ifdef MIN
#undef MIN
#endif
#define MIN(a, b) ((a)>(b)?(b):(a))

#ifndef TRUE
#define TRUE   1
#endif
#ifndef FALSE
#define FALSE  0
#endif

/* States in risk state machine */
#define STATE_REGISTER  0
#define STATE_FORTIFY   1
#define STATE_PLACE     2
#define STATE_ATTACK    3
#define STATE_MOVE      4

/* Defines for widgets */
#define ATTACK_ONE     0
#define ATTACK_TWO     1
#define ATTACK_THREE   2
#define ATTACK_AUTO    3

#define ACTION_PLACE   0
#define ACTION_ATTACK  1
#define ACTION_DOORDIE 2
#define ACTION_MOVE    3

/* Species of players */
#define SPECIES_HUMAN     0
#define SPECIES_COMPUTER  1

/* The main modes are SERVER and CLIENT.  If the object is created as
 * a SERVER, it broadcasts information to the other clients when it receives
 * updates from another CLIENT.  If the object is created as a CLIENT, it
 * just updates its own fields when it receives an update.
 */

#define MODE_CLIENT            1
#define MODE_SERVER            2
#define MODE_AI_CLIENT         4

/* A PERSISTANT object will maintain a copy of itself on secondary storage.  
 * Every time the object updates a field, it also updates the field on disk.
 */

#define MODE_PERSISTANT        8


/* These functions support all of the functionality of the RiskGame structure,
 * in order for it to work as a fully distributed object.  The functions
 * are split into two catagories, those that receive input from a remote 
 * source (through a message), those that receive input from the local
 * client, which is sent back to the server to broadcast to all the other
 * clients, and those that return fields of the object to the local client.
 * This file serves the functionality of a C++ object -- I would use GCC but
 * its C++ side is not stable enough.
 */

/* Constructor */

void     RISK_InitObject(Int32 iMode, 
			 void (*Callback)(Int32, void *, Int32, Int32),
			 void (*FailureCallback)(CString, Int32));

#define MESS_INCOMING 0
#define MESS_OUTGOING 1

/* For persistance */

void     RISK_SaveObject(CString strFileName);
void     RISK_LoadObject(CString strFileName);


/* Utilities */

Int32    RISK_GetNthLivePlayer(Int32 iIndex);
Int32    RISK_GetNthPlayer(Int32 iIndex);
Int32    RISK_GetNthPlayerAtClient(Int32 iClient, Int32 iIndex);
Int32    RISK_GetNumPlayersOfClient(Int32 iClient);
Int32    RISK_GetNumLivePlayersOfClient(Int32 iClient);
void     RISK_ObjectFailure(CString strReason, Int32 iCommLink);

/* For the failure routine */
#define SERVER -1


/* Reliable communication */

Int32    RISK_SendMessage(Int32 iDest, Int32 iMessType, void *pvMessage);
Int32    RISK_ReceiveMessage(Int32 iSource, Int32 *piMessType, 
			     void **ppvMessage);
Int32    RISK_SendSyncMessage(Int32 iCommLink, Int32 iMessType, 
			      void *pvMessage, Int32 iReturnMessType,
			      void (*CBK_MessageReceived)(Int32, void *)); 

/* Methods for the distributed object. */

void     RISK_SelectiveReplicate(Int32 iClientToServerSocket, Int32 iField, 
				 Int32 iIndex1, Int32 iIndex2);
void     RISK_ResetObj(void);
void     RISK_ResetGame(void);
void     RISK_ProcessMessage(Int32 iMessType, void *pMessage, Int32 iSrc);

void     RISK_SetSpeciesOfPlayer(Int32 iPlayer, Int32 iSpecies);
void     RISK_SetAttackModeOfPlayer(Int32 iPlayer, Int32 iMode);
void     RISK_SetDiceModeOfPlayer(Int32 iPlayer, Int32 iMode);
void     RISK_SetMsgDstModeOfPlayer(Int32 iPlayer, Int32 iMode);
void     RISK_SetStateOfPlayer(Int32 iPlayer, Int32 iState);
void     RISK_SetClientOfPlayer(Int32 iPlayer, Int32 iClient);
void     RISK_SetNumCountriesOfPlayer(Int32 iCountry, Int32 iNumCountries);
void     RISK_SetNumArmiesOfPlayer(Int32 iCountry, Int32 iNumArmies);
void     RISK_SetNumCardsOfPlayer(Int32 iPlayer, Int32 iNumCards);
void     RISK_SetNameOfPlayer(Int32 iPlayer, CString strName);
void     RISK_SetColorCStringOfPlayer(Int32 iPlayer, CString strColor);
void     RISK_SetCardOfPlayer(Int32 iPlayer, Int32 iCard, Int32 iValue);
void     RISK_SetNameOfCountry(Int32 iCountry, CString strName);
void     RISK_SetContinentOfCountry(Int32 iCountry, Int32 iContinent);
void     RISK_SetOwnerOfCountry(Int32 iCountry, Int32 iOwner);
void     RISK_SetNumArmiesOfCountry(Int32 iCountry, Int32 iNumArmies);
void     RISK_SetAdjCountryOfCountry(Int32 iCountry, Int32 iIndex, 
				     Int32 OtherC);
void     RISK_SetNumLivePlayers(Int32 iNumPlayers);
void     RISK_SetNumPlayers(Int32 iNumPlayers);

Int32    RISK_GetSpeciesOfPlayer(Int32 iPlayer);
Int32    RISK_GetDiceModeOfPlayer(Int32 iPlayer);
Int32    RISK_GetMsgDstModeOfPlayer(Int32 iPlayer);
Int32    RISK_GetAttackModeOfPlayer(Int32 iPlayer);
Int32    RISK_GetStateOfPlayer(Int32 iPlayer);
Int32    RISK_GetClientOfPlayer(Int32 iPlayer);
Int32    RISK_GetNumCountriesOfPlayer(Int32 iCountry);
Int32    RISK_GetNumArmiesOfPlayer(Int32 iCountry);
Int32    RISK_GetNumCardsOfPlayer(Int32 iPlayer);
CString  RISK_GetNameOfPlayer(Int32 iPlayer);
CString  RISK_GetColorCStringOfPlayer(Int32 iPlayer);
Int32    RISK_GetCardOfPlayer(Int32 iPlayer, Int32 iCard);
CString  RISK_GetNameOfCountry(Int32 iCountry);
Int32    RISK_GetContinentOfCountry(Int32 iCountry);
Int32    RISK_GetNumArmiesOfCountry(Int32 iCountry);
Int32    RISK_GetOwnerOfCountry(Int32 iCountry);
Int32    RISK_GetAdjCountryOfCountry(Int32 iCountry, Int32 iIndex);
Int32    RISK_GetTextXOfCountry(Int32 iCountry);
Int32    RISK_GetTextYOfCountry(Int32 iCountry);
Int32    RISK_GetValueOfContinent(Int32 iContinent);
CString  RISK_GetNameOfContinent(Int32 iContinent);
Int32    RISK_GetNumCountriesOfContinent(Int32 iContinent);
Int32    RISK_GetNumLivePlayers(void);
Int32    RISK_GetNumPlayers(void);

#endif


